/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.CfgBranchingBlock;
import org.sonar.plugins.php.api.cfg.ControlFlowGraph;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.BreakStatementTree;
import org.sonar.plugins.php.api.tree.statement.GotoStatementTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1751")
public class LoopExecutingAtMostOnceCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1751";
    private static final String MESSAGE = "Refactor this loop to do more than one iteration.";
    private static final Set<Tree.Kind> LOOPS = EnumSet.of(Tree.Kind.WHILE_STATEMENT, new Tree.Kind[]{Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.ALTERNATIVE_WHILE_STATEMENT, Tree.Kind.ALTERNATIVE_FOR_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.ALTERNATIVE_SWITCH_STATEMENT});
    private Map<Tree, List<Tree>> jumpsByLoop = new HashMap<Tree, List<Tree>>();

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.jumpsByLoop.clear();
        super.visitCompilationUnit(tree);
        this.reportIssues();
    }

    private void reportIssues() {
        this.jumpsByLoop.forEach((loop, jumps) -> {
            PreciseIssue preciseIssue = this.context().newIssue(this, ((PHPTree)loop).getFirstToken(), MESSAGE);
            jumps.forEach(jump -> preciseIssue.secondary((Tree)jump, "loop exit"));
        });
    }

    @Override
    public void visitBreakStatement(BreakStatementTree tree) {
        this.checkJump(tree);
    }

    @Override
    public void visitReturnStatement(ReturnStatementTree tree) {
        this.checkJump(tree);
    }

    @Override
    public void visitThrowStatement(ThrowStatementTree tree) {
        this.checkJump(tree);
    }

    @Override
    public void visitGotoStatement(GotoStatementTree tree) {
        this.checkJump(tree);
    }

    private void checkJump(Tree tree) {
        Tree loop = TreeUtils.findAncestorWithKind(tree, LOOPS);
        if (loop == null || loop.is(Tree.Kind.SWITCH_STATEMENT, Tree.Kind.ALTERNATIVE_SWITCH_STATEMENT)) {
            return;
        }
        if (!LoopExecutingAtMostOnceCheck.isWhileTrue(loop) && !this.canExecuteMoreThanOnce(loop)) {
            this.jumpsByLoop.computeIfAbsent(loop, key -> new ArrayList()).add(tree);
        }
    }

    private static boolean isWhileTrue(Tree loop) {
        return loop.is(Tree.Kind.WHILE_STATEMENT, Tree.Kind.ALTERNATIVE_WHILE_STATEMENT) && CheckUtils.isTrueValue(((WhileStatementTree)loop).condition().expression());
    }

    private boolean canExecuteMoreThanOnce(Tree loop) {
        CfgBranchingBlock loopBlock = this.findLoopBlock(loop);
        if (loopBlock == null) {
            return true;
        }
        ArrayDeque<CfgBlock> worklist = new ArrayDeque<CfgBlock>();
        worklist.add(loopBlock.trueSuccessor());
        HashSet<CfgBlock> seen = new HashSet<CfgBlock>();
        while (!worklist.isEmpty()) {
            CfgBlock b = (CfgBlock)worklist.pop();
            if (b.successors().contains(loopBlock)) {
                return true;
            }
            if (!seen.add(b)) continue;
            b.successors().stream().filter(succ -> LoopExecutingAtMostOnceCheck.blockInsideLoop(succ, loop)).forEach(worklist::push);
        }
        return false;
    }

    private static boolean blockInsideLoop(CfgBlock block, Tree loop) {
        return block.elements().isEmpty() || TreeUtils.isDescendant(block.elements().get(0), loop);
    }

    @CheckForNull
    private CfgBranchingBlock findLoopBlock(Tree loop) {
        Tree treeWithFlow = TreeUtils.findAncestorWithKind(loop, ControlFlowGraph.KINDS_WITH_CONTROL_FLOW);
        if (treeWithFlow == null) {
            return null;
        }
        ControlFlowGraph cfg = ControlFlowGraph.build(treeWithFlow, this.context());
        if (cfg == null) {
            return null;
        }
        List<CfgBlock> loopBlocks = cfg.blocks().stream().filter(CfgBranchingBlock.class::isInstance).filter(b -> ((CfgBranchingBlock)b).branchingTree().equals(loop)).toList();
        return (CfgBranchingBlock)ListUtils.getOnlyElement(loopBlocks);
    }
}

