/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.ControlFlowGraph;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;

@Rule(key="S3626")
public class RedundantJumpCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S3626";
    private static final String MESSAGE = "Remove this redundant jump.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return new ArrayList<Tree.Kind>(ControlFlowGraph.KINDS_WITH_CONTROL_FLOW);
    }

    @Override
    public void visitNode(Tree tree) {
        ControlFlowGraph cfg = ControlFlowGraph.build(tree, this.context());
        if (cfg != null) {
            this.checkCfg(cfg);
        }
    }

    private void checkCfg(ControlFlowGraph cfg) {
        for (CfgBlock cfgBlock : cfg.blocks()) {
            Tree lastElement;
            if (cfgBlock.successors().size() != 1 || !cfgBlock.successors().contains(cfgBlock.syntacticSuccessor()) || RedundantJumpCheck.isIgnoredJump(lastElement = ListUtils.getLast(cfgBlock.elements())) || !lastElement.is(Tree.Kind.RETURN_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.GOTO_STATEMENT)) continue;
            this.context().newIssue(this, lastElement, MESSAGE);
        }
    }

    private static boolean isIgnoredJump(Tree tree) {
        if (tree.is(Tree.Kind.RETURN_STATEMENT) && (((ReturnStatementTree)tree).expression() != null || tree.getParent().is(Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE))) {
            return true;
        }
        Tree tryAncestor = TreeUtils.findAncestorWithKind(tree, Collections.singletonList(Tree.Kind.TRY_STATEMENT));
        return tryAncestor != null;
    }
}

