/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.declaration;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.tree.symbols.HasClassSymbol;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.AttributeGroupTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ClassMemberTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class ClassDeclarationTreeImpl
extends PHPTree
implements ClassDeclarationTree,
HasClassSymbol {
    private final Tree.Kind kind;
    private final List<AttributeGroupTree> attributeGroups;
    private final List<SyntaxToken> modifiersToken;
    private final SyntaxToken classEntryTypeToken;
    private final NameIdentifierTree name;
    private final SyntaxToken extendsToken;
    private final NamespaceNameTree superClass;
    private final SyntaxToken implementsToken;
    private final SeparatedListImpl<NamespaceNameTree> superInterfaces;
    private final SyntaxToken openCurlyBraceToken;
    private final List<ClassMemberTree> members;
    private final SyntaxToken closeCurlyBraceToken;
    private ClassSymbol symbol;

    protected ClassDeclarationTreeImpl(Tree.Kind kind, List<AttributeGroupTree> attributeGroups, List<SyntaxToken> modifiersToken, SyntaxToken classEntryTypeToken, NameIdentifierTree name, @Nullable SyntaxToken extendsToken, @Nullable NamespaceNameTree superClass, @Nullable SyntaxToken implementsToken, SeparatedListImpl<NamespaceNameTree> superInterfaces, SyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, SyntaxToken closeCurlyBraceToken) {
        this.kind = kind;
        this.attributeGroups = attributeGroups;
        this.modifiersToken = modifiersToken;
        this.classEntryTypeToken = classEntryTypeToken;
        this.name = name;
        this.extendsToken = extendsToken;
        this.superClass = superClass;
        this.implementsToken = implementsToken;
        this.superInterfaces = superInterfaces;
        this.openCurlyBraceToken = openCurlyBraceToken;
        this.members = members;
        this.closeCurlyBraceToken = closeCurlyBraceToken;
    }

    @Override
    @Nullable
    public SyntaxToken modifierToken() {
        return this.modifiersToken.stream().filter(modifier -> modifier.text().equalsIgnoreCase("final") || modifier.text().equalsIgnoreCase("abstract")).findFirst().orElse(null);
    }

    @Override
    public List<SyntaxToken> modifiersToken() {
        return this.modifiersToken;
    }

    @Override
    public List<AttributeGroupTree> attributeGroups() {
        return this.attributeGroups;
    }

    @Override
    public SyntaxToken classToken() {
        return this.classEntryTypeToken;
    }

    @Override
    public NameIdentifierTree name() {
        return this.name;
    }

    @Override
    @Nullable
    public SyntaxToken extendsToken() {
        return this.extendsToken;
    }

    @Override
    @Nullable
    public NamespaceNameTree superClass() {
        return this.superClass;
    }

    @Override
    @Nullable
    public SyntaxToken implementsToken() {
        return this.implementsToken;
    }

    public SeparatedListImpl<NamespaceNameTree> superInterfaces() {
        return this.superInterfaces;
    }

    @Override
    public SyntaxToken openCurlyBraceToken() {
        return this.openCurlyBraceToken;
    }

    @Override
    public List<ClassMemberTree> members() {
        return this.members;
    }

    @Override
    public SyntaxToken closeCurlyBraceToken() {
        return this.closeCurlyBraceToken;
    }

    @Override
    public boolean isAbstract() {
        return this.modifiersToken.stream().anyMatch(token -> token.text().equalsIgnoreCase("abstract"));
    }

    @Override
    public boolean isFinal() {
        return this.modifiersToken.stream().anyMatch(token -> token.text().equalsIgnoreCase("final"));
    }

    @Override
    public boolean isReadOnly() {
        return this.modifiersToken.stream().anyMatch(token -> token.text().equalsIgnoreCase("readonly"));
    }

    @Override
    @Nullable
    public MethodDeclarationTree fetchConstructor() {
        MethodDeclarationTree oldStyleConstructor = null;
        MethodDeclarationTree newStyleConstructor = null;
        for (ClassMemberTree member : this.members) {
            if (!member.is(Tree.Kind.METHOD_DECLARATION)) continue;
            MethodDeclarationTree method = (MethodDeclarationTree)member;
            String methodName = method.name().text();
            if (this.name.text().equalsIgnoreCase(methodName)) {
                oldStyleConstructor = method;
                continue;
            }
            if (!"__construct".equalsIgnoreCase(methodName)) continue;
            newStyleConstructor = method;
        }
        return newStyleConstructor != null ? newStyleConstructor : oldStyleConstructor;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(this.attributeGroups.iterator(), this.modifiersToken.iterator(), IteratorUtils.iteratorOf(this.classEntryTypeToken, this.name, this.extendsToken, this.superClass, this.implementsToken), this.superInterfaces.elementsAndSeparators(), IteratorUtils.iteratorOf(this.openCurlyBraceToken), this.members.iterator(), IteratorUtils.iteratorOf(this.closeCurlyBraceToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitClassDeclaration(this);
    }

    public static ClassDeclarationTree createInterface(List<AttributeGroupTree> attributes, InternalSyntaxToken interfaceToken, NameIdentifierTree name, @Nullable InternalSyntaxToken extendsToken, SeparatedListImpl<NamespaceNameTree> interfaceList, InternalSyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, InternalSyntaxToken closeCurlyBraceToken) {
        return new ClassDeclarationTreeImpl(Tree.Kind.INTERFACE_DECLARATION, attributes, List.of(), interfaceToken, name, extendsToken, null, null, interfaceList, openCurlyBraceToken, members, closeCurlyBraceToken);
    }

    public static ClassDeclarationTree createTrait(List<AttributeGroupTree> attributes, InternalSyntaxToken traitToken, NameIdentifierTree name, InternalSyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, InternalSyntaxToken closeCurlyBraceToken) {
        return new ClassDeclarationTreeImpl(Tree.Kind.TRAIT_DECLARATION, attributes, List.of(), traitToken, name, null, null, null, SeparatedListImpl.empty(), openCurlyBraceToken, members, closeCurlyBraceToken);
    }

    public static ClassDeclarationTree createClass(List<AttributeGroupTree> attributes, List<SyntaxToken> modifiersToken, InternalSyntaxToken classToken, NameIdentifierTree name, @Nullable InternalSyntaxToken extendsToken, @Nullable NamespaceNameTree superClass, @Nullable InternalSyntaxToken implementsToken, SeparatedListImpl<NamespaceNameTree> superInterfaces, InternalSyntaxToken openCurlyBraceToken, List<ClassMemberTree> members, InternalSyntaxToken closeCurlyBraceToken) {
        return new ClassDeclarationTreeImpl(Tree.Kind.CLASS_DECLARATION, attributes, modifiersToken, classToken, name, extendsToken, superClass, implementsToken, superInterfaces, openCurlyBraceToken, members, closeCurlyBraceToken);
    }

    @Override
    public ClassSymbol symbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(ClassSymbol symbol) {
        this.symbol = symbol;
    }
}

