/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.quickfix;

import org.sonarsource.analyzer.commons.checks.verifier.quickfix.TextSpan;

public class TextEdit {
    private final TextSpan textSpan;
    private final String replacement;

    private TextEdit(TextSpan textSpan, String replacement) {
        this.textSpan = textSpan;
        this.replacement = replacement;
    }

    public String toString() {
        return this.textSpan.toString() + " -> {{" + this.replacement + "}}";
    }

    public TextSpan getTextSpan() {
        return this.textSpan;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public static TextEdit removeTextSpan(TextSpan textSpan) {
        return new TextEdit(textSpan, "");
    }

    public static TextEdit replaceTextSpan(TextSpan textSpan, String replacement) {
        return new TextEdit(textSpan, replacement);
    }

    public static TextEdit insertAtPosition(int line, int column, String addition) {
        return new TextEdit(TextEdit.position(line, column), addition);
    }

    public static TextSpan position(int line, int column) {
        return TextEdit.textSpan(line, column, line, column);
    }

    public static TextSpan textSpan(int startLine, int startColumn, int endLine, int endColumn) {
        return new TextSpan(startLine, startColumn, endLine, endColumn);
    }

    public boolean equals(Object obj) {
        return obj instanceof TextEdit && this.textSpan.equals(((TextEdit)obj).textSpan) && this.replacement.equals(((TextEdit)obj).replacement);
    }

    public int hashCode() {
        return 17 * this.textSpan.hashCode() + 31 * this.replacement.hashCode();
    }
}

