/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.stream;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.conqat.engine.core.stream.DelegatingStreamWithException;
import org.conqat.engine.core.stream.ICollectorWithException;
import org.conqat.engine.core.stream.IIteratorWithException;
import org.conqat.engine.core.stream.IStreamSource;
import org.conqat.engine.core.stream.StreamWithExceptionBuilder;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.BiFunctionWithException;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.PredicateWithException;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.function.SupplierWithException;

public interface IStreamWithException<T, E extends Exception> {
    public IStreamWithException<T, E> filter(PredicateWithException<? super T, ? extends E> var1);

    public <R> IStreamWithException<R, E> map(FunctionWithException<? super T, ? extends R, ? extends E> var1);

    public <R> IStreamWithException<R, E> flatMap(FunctionWithException<? super T, ? extends IStreamWithException<? extends R, ? extends E>, ? extends E> var1);

    public <R> IStreamWithException<R, E> flatMapStream(FunctionWithException<? super T, ? extends Stream<? extends R>, ? extends E> var1);

    public <R> IStreamWithException<R, E> mapMulti(BiConsumerWithException<? super T, Consumer<? super R>, ? extends E> var1);

    public IStreamWithException<T, E> distinctBy(FunctionWithException<T, ?, ? extends E> var1);

    default public IStreamWithException<T, E> distinct() {
        return this.distinctBy(FunctionWithException.identity());
    }

    public IStreamWithException<T, E> sorted(Comparator<? super T> var1);

    public IStreamWithException<T, E> peek(ConsumerWithException<? super T, ? extends E> var1);

    public IStreamWithException<T, E> limit(long var1);

    public IStreamWithException<T, E> skip(long var1);

    public IStreamWithException<List<T>, E> batch(int var1);

    public <U> IStreamWithException<Pair<T, U>, E> zip(IStreamWithException<U, E> var1);

    public IStreamWithException<T, E> afterTerminal(RunnableWithException<? extends E> var1);

    public void forEach(ConsumerWithException<? super T, ? extends E> var1) throws E;

    public Object[] toArray() throws E;

    public T[] toArray(IntFunction<T[]> var1) throws E;

    public T reduce(T var1, BiFunctionWithException<T, T, T, ? extends E> var2) throws E;

    public Optional<T> reduce(BiFunctionWithException<T, T, T, ? extends E> var1) throws E;

    public <U> U reduce(U var1, BiFunctionWithException<U, ? super T, U, ? extends E> var2, BiFunctionWithException<U, U, U, ? extends E> var3) throws E;

    public <R> R collect(SupplierWithException<R, ? extends E> var1, BiConsumerWithException<R, ? super T, ? extends E> var2, BiConsumerWithException<R, R, ? extends E> var3) throws E;

    default public <R, A> R collect(Collector<? super T, A, R> collector) throws E {
        return this.collect(ICollectorWithException.of(collector));
    }

    public <R, A> R collect(ICollectorWithException<? super T, A, R, ? extends E> var1) throws E;

    public Optional<T> min(Comparator<? super T> var1) throws E;

    public Optional<T> max(Comparator<? super T> var1) throws E;

    public long count() throws E;

    public boolean anyMatch(PredicateWithException<? super T, ? extends E> var1) throws E;

    public boolean allMatch(PredicateWithException<? super T, ? extends E> var1) throws E;

    public boolean noneMatch(PredicateWithException<? super T, ? extends E> var1) throws E;

    public Optional<T> findFirst() throws E;

    default public Optional<T> findAny() throws E {
        return this.findFirst();
    }

    public IStreamSource<T, E> source();

    public static <T, E extends Exception> IStreamWithException<T, E> of(IStreamSource<T, E> source) {
        return new DelegatingStreamWithException<T, E>(source);
    }

    public static <T> StreamWithExceptionBuilder<T> wrap(Stream<T> stream) {
        return new StreamWithExceptionBuilder<T>(stream);
    }

    public static <T> StreamWithExceptionBuilder<T> empty() {
        return IStreamWithException.wrap(Stream.empty());
    }

    public static <T> StreamWithExceptionBuilder<T> of(T element) {
        return IStreamWithException.wrap(Stream.of(element));
    }

    @SafeVarargs
    public static <T> StreamWithExceptionBuilder<T> of(T first, T ... further) {
        return IStreamWithException.wrap(Stream.concat(Stream.of(first), Stream.of(further)));
    }

    public static <T> StreamWithExceptionBuilder<T> ofNullable(T element) {
        return IStreamWithException.wrap(Stream.ofNullable(element));
    }

    @SafeVarargs
    public static <T> StreamWithExceptionBuilder<T> ofNullable(T first, T ... further) {
        return IStreamWithException.wrap(Stream.concat(Stream.ofNullable(first), Stream.of(further).filter(Objects::nonNull)));
    }

    @SafeVarargs
    public static <T, E extends Exception> IStreamWithException<T, E> concat(IStreamWithException<T, E> first, IStreamWithException<T, E> ... further) {
        return IStreamWithException.concat(first, Arrays.asList(further));
    }

    public static <T, E extends Exception> IStreamWithException<T, E> concat(IStreamWithException<T, E> first, Collection<IStreamWithException<T, E>> further) {
        return IStreamWithException.of(IStreamSource.concat(first.source(), further.stream().map(IStreamWithException::source).toList()));
    }

    public IIteratorWithException<T, E> toIterator();
}

