/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.ui.resources;

import com.teamscale.core.authenticate.SessionIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import com.teamscale.ui.ETeamscalePerspective;
import com.teamscale.ui.resources.TeamscalePerspectiveService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.persistence.store.StorageException;

@Hidden
@Path(value="login")
public class TeamscaleLoginPerspectiveService
extends ApiBase {
    @Context
    private ContainerRequestContext requestContext;

    @GET
    @RequiresNoLogin
    @Produces(value={"text/html"})
    public String getPerspectiveHtml(@QueryParam(value="target") @Parameter(description="Specifies the page to which the user should be redirected to after successful login") String target) throws StorageException {
        if (this.hasValidSessionCookie()) {
            this.throwRedirectToException(target);
        }
        return TeamscalePerspectiveService.getIndexHtml(this.serviceInfo);
    }

    private void throwRedirectToException(String target) {
        String destination = ETeamscalePerspective.DEFAULT.createUri("show").toString();
        if (target != null && !target.startsWith("/") && !target.contains("//")) {
            destination = target;
        }
        throw new RedirectionException(Response.Status.TEMPORARY_REDIRECT, this.createRedirectUri(destination));
    }

    private boolean hasValidSessionCookie() throws StorageException {
        SessionIndex sessionIndex = (SessionIndex)this.serviceInfo.getGlobalStorageSystem().openGlobalIndex(SessionIndex.class);
        return this.serviceInfo.getAuthenticationRequestHandler().hasValidSessionCookie(this.requestContext, sessionIndex);
    }
}

