/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.swift.platformconditions;

import eu.cqse.check.framework.preprocessor.swift.platformconditions.EnumPlatformCondition;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.ImportPlatformCondition;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.ParseException;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionBase;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.PlatformConditionParseResult;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.StringLiteralVersionPlatformCondition;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.StringPlatformCondition;
import eu.cqse.check.framework.preprocessor.swift.platformconditions.VersionPlatformCondition;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.util.tokens.TokenStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SwiftPlatformConditions {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern CONFIG_ASSIGNMENT_SPLIT_PATTERN = Pattern.compile("\\s*:=\\s*");
    private static final @Unmodifiable Map<String, PlatformConditionBase> KNOWN_PLATFORM_CONDITIONS = Map.ofEntries(SwiftPlatformConditions.newEnumConditionEntry("os", "OSX", "macOS", "tvOS", "watchOS", "iOS", "visionOS", "xrOS", "Linux", "FreeBSD", "OpenBSD", "Windows", "Android", "PS4", "Cygwin", "Haiku", "WASI", "none"), SwiftPlatformConditions.newEnumConditionEntry("arch", "arm", "arm64", "arm64_32", "i386", "x86_64", "powerpc", "powerpc64", "powerpc64le", "s390x", "wasm32", "riscv64", "avr"), SwiftPlatformConditions.newEnumConditionEntry("targetEnvironment", "unspecified", "simulator", "macabi", "macCatalyst"), SwiftPlatformConditions.newEnumConditionEntry("_endian", "little", "big"), SwiftPlatformConditions.newEnumConditionEntry("_pointerBitWidth", "_16", "_32", "_64"), SwiftPlatformConditions.newEnumConditionEntry("_runtime", "_ObjC", "_Native", "_multithreaded"), SwiftPlatformConditions.newEnumConditionEntry("_ptrauth", "_none", "_arm64e"), SwiftPlatformConditions.newEnumConditionEntry("_hasAtomicBitWidth", "_8", "_16", "_32", "_64", "_128"), SwiftPlatformConditions.newImportConditionnEntry("canImport"), SwiftPlatformConditions.newStringConditionEntry("hasAttribute"), SwiftPlatformConditions.newStringConditionEntry("hasFeature"), SwiftPlatformConditions.newVersionConditionEntry("compiler"), SwiftPlatformConditions.newVersionConditionEntry("swift"), SwiftPlatformConditions.newStringLiteralVersionConditionEntry("_compiler_version"));
    private static final @Unmodifiable List<PlatformConditionBase> FALLBACK_UNKNOWN_CONDITIONS = List.of(new VersionPlatformCondition("DUMMY"), new StringPlatformCondition("DUMMY"));

    @Contract(value="_, _ -> new")
    private static @NonNull @Unmodifiable Map.Entry<String, PlatformConditionBase> newEnumConditionEntry(@NonNull String name, String ... possibleValues) {
        return Map.entry(name, new EnumPlatformCondition(name, Set.of(possibleValues)));
    }

    @Contract(value="_ -> new")
    private static @NonNull @Unmodifiable Map.Entry<String, PlatformConditionBase> newStringConditionEntry(@NonNull String name) {
        return Map.entry(name, new StringPlatformCondition(name));
    }

    @Contract(value="_ -> new")
    private static @NonNull @Unmodifiable Map.Entry<String, PlatformConditionBase> newVersionConditionEntry(@NonNull String name) {
        return Map.entry(name, new VersionPlatformCondition(name));
    }

    @Contract(value="_ -> new")
    private static @NonNull @Unmodifiable Map.Entry<String, PlatformConditionBase> newStringLiteralVersionConditionEntry(@NonNull String name) {
        return Map.entry(name, new StringLiteralVersionPlatformCondition(name));
    }

    @Contract(value="_ -> new")
    private static @NonNull @Unmodifiable Map.Entry<String, PlatformConditionBase> newImportConditionnEntry(@NonNull String name) {
        return Map.entry(name, new ImportPlatformCondition(name));
    }

    @VisibleForTesting
    static @Nullable PlatformConditionBase getKnownPlatformCondition(@NonNull String name) {
        return KNOWN_PLATFORM_CONDITIONS.get(name);
    }

    @VisibleForTesting
    static @NonNull @Unmodifiable Collection<PlatformConditionBase> getAllKnownPlatformConditions() {
        return KNOWN_PLATFORM_CONDITIONS.values();
    }

    public static Optional<PlatformConditionParseResult> parse(@NonNull TokenStream tokenStream) throws ParseException {
        Optional<String> maybeIdentifierName = PlatformConditionBase.looksLikePlatformCondition(tokenStream);
        if (maybeIdentifierName.isEmpty()) {
            return Optional.empty();
        }
        String identifierName = maybeIdentifierName.get();
        PlatformConditionBase condition = KNOWN_PLATFORM_CONDITIONS.get(identifierName);
        if (condition != null) {
            return Optional.of(condition.parse(tokenStream));
        }
        IToken startToken = tokenStream.peekCurrent();
        LOGGER.info("Encountered unknown platform condition '{}' in '{}:{}'. Condition will still be evaluated if the format can be recognized.", (Object)identifierName, (Object)startToken.getOriginId(), (Object)(startToken.getLineNumber() + 1));
        for (PlatformConditionBase fallbackCondition : FALLBACK_UNKNOWN_CONDITIONS) {
            try {
                return Optional.of(fallbackCondition.copyWithName(identifierName).parse(tokenStream));
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("Could not parse platform condition '%s' in '%s:%d'.".formatted(identifierName, startToken.getOriginId(), startToken.getLineNumber() + 1));
    }

    @Contract(value="_ -> new")
    public static @NonNull Map<String, Set<Object>> parseConfig(@Nullable String config) throws ParseException {
        if (StringUtils.isEmpty((String)config)) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<Object>> configMap = new HashMap<String, Set<Object>>();
        for (String line : StringUtils.splitLines((String)config)) {
            SwiftPlatformConditions.parseConfigSingleLine(line, configMap);
        }
        return configMap;
    }

    private static void parseConfigSingleLine(@NonNull String line, @NonNull Map<String, Set<Object>> configMap) throws ParseException {
        String[] split = CONFIG_ASSIGNMENT_SPLIT_PATTERN.split(line, 3);
        if (split.length != 2) {
            throw new ParseException("Cannot parse line in configuration: " + line);
        }
        String name = split[0];
        String value = split[1];
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)value)) {
            throw new ParseException("Cannot parse configuration with empty name or value: " + line);
        }
        if (SwiftPlatformConditions.parseConfigKnownCondition(configMap, name, value)) {
            return;
        }
        SwiftPlatformConditions.parseConfigUnknownCondition(configMap, value, name);
    }

    private static boolean parseConfigKnownCondition(@NonNull Map<String, Set<Object>> configMap, @NonNull String name, @NonNull String value) throws ParseException {
        PlatformConditionBase condition = KNOWN_PLATFORM_CONDITIONS.get(name);
        if (condition == null) {
            return false;
        }
        try {
            configMap.computeIfAbsent(name, k -> new HashSet()).add(condition.parseConfig(value));
        }
        catch (ParseException e) {
            throw new ParseException("Cannot parse configuration value for '%s': '%s'. Unknown or invalid value format.".formatted(name, value), e);
        }
        return true;
    }

    private static void parseConfigUnknownCondition(@NonNull Map<String, Set<Object>> configMap, @NonNull String value, @NonNull String name) throws ParseException {
        LOGGER.warn("Swift platform condition '{}' configured: Unknown platform condition with value '{}'. Condition will still be evaluated if the format can be recognized.", (Object)name, (Object)value);
        for (PlatformConditionBase condition : FALLBACK_UNKNOWN_CONDITIONS) {
            try {
                configMap.computeIfAbsent(name, k -> new HashSet()).add(condition.parseConfig(value));
                return;
            }
            catch (ParseException parseException) {
            }
        }
        throw new ParseException("Cannot parse configuration value for '%s': '%s'. Unknown or invalid value format for unknown platform condition.".formatted(name, value));
    }
}

