/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.rust;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.rust.RustSubExpressionRecognizer;
import java.util.Arrays;
import java.util.List;

public class RustShallowParser
extends ShallowParserBase<ERustParserStates> {
    private static final ITokenMatcher MATCH_CLAUSE_START_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CHARACTER_LITERAL, ETokenType.STRING_LITERAL, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL, ETokenType.BOOLEAN_LITERAL, ETokenType.IDENTIFIER, ETokenType.LPAREN, ETokenType.REF, ETokenType.MUT});
    private static final ITokenMatcher STATEMENT_START_TOKENS = MATCH_CLAUSE_START_TYPES.or(new ITokenMatcher[]{ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.RETURN, ETokenType.CONTINUE, ETokenType.BREAK, ETokenType.SUPER, ETokenType.MULT, ETokenType.AND, ETokenType.NOT, ETokenType.MINUS, ETokenType.LT, ETokenType.SELF})});
    private static final List<ETokenType> OPENING_PARENS = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK);
    private static final List<ETokenType> CLOSING_PARENS = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK);
    private static final List<ETokenType> OPENING_BRACES = Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE);
    private static final List<ETokenType> CLOSING_BRACES = Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE);

    public RustShallowParser() {
        super(ERustParserStates.class, ERustParserStates.IN_MODULE);
        this.createModuleRules();
        this.createMethodRules();
        this.createEnumRules();
        this.createTraitRules();
        this.createStructRules();
        this.createMetaRules();
        this.createStatementRules();
        this.createLambdaRules();
    }

    private void createModuleRules() {
        this.createModuleLevelRule(ERustParserStates.IN_MODULE, EShallowEntityType.MODULE, ETokenType.MOD, INameResolver.ofString("module"));
        this.createModuleLevelTypeRule(ERustParserStates.IN_TRAIT, ETokenType.IMPL, INameResolver.ofString("implementation"));
        this.createModuleLevelTypeRule(ERustParserStates.IN_TRAIT, ETokenType.TRAIT, INameResolver.firstMatchedTokenText());
        this.createModuleLevelTypeRule(ERustParserStates.IN_ENUM, ETokenType.ENUM, INameResolver.firstMatchedTokenText());
        this.createModuleStructRules();
        this.createVariableRules(ERustParserStates.IN_MODULE, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONST, ETokenType.STATIC}), EShallowEntityType.ATTRIBUTE, "global variable");
    }

    private void createModuleStructRules() {
        RecognizerBase<ERustParserStates> structRule = this.inState(new ERustParserStates[]{ERustParserStates.IN_MODULE}).optional(new ITokenMatcher[]{ETokenType.PUB}).markStart().sequence(new ITokenMatcher[]{ETokenType.STRUCT, ETokenType.IDENTIFIER}).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.LPAREN, ETokenType.LBRACE}));
        structRule.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.TYPE, "unit struct", INameResolver.secondMatchedTokenText()).endNode();
        RustShallowParser.finishStructRule(structRule, ERustParserStates.IN_STRUCT, "struct", ETokenType.LBRACE, ETokenType.RBRACE);
        RustShallowParser.finishStructRule(structRule, ERustParserStates.IN_TUPLE_STRUCT, "tuple struct", ETokenType.LPAREN, ETokenType.RPAREN);
    }

    private static void finishStructRule(RecognizerBase<ERustParserStates> structRule, ERustParserStates subState, String subType, ETokenType openingToken, ETokenType closingToken) {
        structRule.sequence(new ITokenMatcher[]{openingToken}).createNode(EShallowEntityType.TYPE, subType, INameResolver.secondMatchedTokenText()).parseUntil(subState).sequence(new ITokenMatcher[]{closingToken}).optional(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createModuleLevelTypeRule(ERustParserStates subState, ETokenType keyword, INameResolver subType) {
        this.createModuleLevelRule(subState, EShallowEntityType.TYPE, keyword, subType);
    }

    private void createModuleLevelRule(ERustParserStates subState, EShallowEntityType type, ETokenType keyword, INameResolver subType) {
        this.inState(new ERustParserStates[]{ERustParserStates.IN_MODULE}).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUB, ETokenType.UNSAFE})).markStart().sequence(new ITokenMatcher[]{keyword}).skipNested(ETokenType.LT, ETokenType.GT).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(type, subType, INameResolver.previousTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(subState).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createMethodRules() {
        RecognizerBase methodRule = this.inState(new ERustParserStates[]{ERustParserStates.IN_MODULE, ERustParserStates.IN_TRAIT, ERustParserStates.IN_METHOD}).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUB, ETokenType.UNSAFE})).markStart().sequence(new ITokenMatcher[]{ETokenType.FN, ETokenType.IDENTIFIER}).skipBefore(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LBRACE, ETokenType.SEMICOLON}));
        methodRule.sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.METHOD, "function declaration", INameResolver.secondMatchedTokenText()).endNode();
        methodRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "function", INameResolver.secondMatchedTokenText()).parseUntil(ERustParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createEnumRules() {
        this.inState(new ERustParserStates[]{ERustParserStates.IN_ENUM}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "enum literal", INameResolver.firstMatchedTokenText()).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.RBRACE}), OPENING_BRACES, CLOSING_BRACES, RustShallowParser.getSubExpressionRecognizer()).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
    }

    private void createTraitRules() {
        this.inState(new ERustParserStates[]{ERustParserStates.IN_TRAIT}).sequence(new ITokenMatcher[]{ETokenType.TYPE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "associated type", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
    }

    private void createStructRules() {
        this.createStructRule(ERustParserStates.IN_STRUCT, INameResolver.firstMatchedTokenText());
        this.createStructRule(ERustParserStates.IN_TUPLE_STRUCT, INameResolver.noName());
    }

    private void createStructRule(ERustParserStates state, INameResolver name) {
        this.inState(new ERustParserStates[]{state}).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PUB, ETokenType.MUT})).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.ATTRIBUTE, "attribute", name).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.COMMA, ETokenType.RPAREN, ETokenType.RBRACE}), Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LT), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.GT)).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
    }

    private void createMetaRules() {
        this.inAnyState().optional(new ITokenMatcher[]{ETokenType.PUB}).markStart().sequence(new ITokenMatcher[]{ETokenType.USE}).createNode(EShallowEntityType.META, INameResolver.firstMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.EXTERN, ETokenType.CRATE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, INameResolver.ofIndices(0, 1), INameResolver.ofIndex(2)).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.ATTRIBUTE_DIRECTIVE}).createNode(EShallowEntityType.META, "attribute directive").endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.TYPE, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "type alias", INameResolver.secondMatchedTokenText()).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.LIFETIME, ETokenType.COLON}).createNode(EShallowEntityType.META, "label", INameResolver.firstMatchedTokenText()).endNode();
        this.inAnyState().sequence(new ITokenMatcher[]{ETokenType.MACRO_RULES, ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "macro", INameResolver.secondMatchedTokenText()).skipNested(ETokenType.LBRACE, ETokenType.RBRACE).endNode();
    }

    private void createStatementRules() {
        this.createBlockRule("anonymous block", new ITokenMatcher[]{ETokenType.LBRACE});
        this.createBlockRule("unsafe block", new ITokenMatcher[]{ETokenType.UNSAFE, ETokenType.LBRACE});
        this.createIfRules();
        this.createLoopRules();
        this.createMatchRules();
        this.createVariableRules(ERustParserStates.IN_METHOD, ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LET, ETokenType.STATIC, ETokenType.CONST}), EShallowEntityType.STATEMENT, "local variable");
        this.createSimpleStatementRules();
    }

    private void createBlockRule(String subType, ITokenMatcher ... sequence) {
        this.inState(new ERustParserStates[]{ERustParserStates.IN_METHOD, ERustParserStates.IN_EXPRESSION}).sequence(sequence).createNode(EShallowEntityType.STATEMENT, subType).parseUntil(ERustParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createIfRules() {
        this.createIfRule(true, new ITokenMatcher[]{ETokenType.IF});
        this.createIfRule(true, new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF});
        this.createIfRule(false, new ITokenMatcher[]{ETokenType.ELSE});
    }

    private void createIfRule(boolean continued, ITokenMatcher ... ifSequence) {
        RecognizerBase<ERustParserStates> ifRule = this.inState(new ERustParserStates[]{ERustParserStates.IN_METHOD, ERustParserStates.IN_EXPRESSION, ERustParserStates.IN_LAMBDA}).sequence(ifSequence).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, OPENING_PARENS, CLOSING_PARENS, RustShallowParser.getSubExpressionRecognizer()).createNode(EShallowEntityType.STATEMENT, INameResolver.ofRange(0, ifSequence.length - 1)).parseUntil(ERustParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE});
        if (continued) {
            this.endWithPossibleContinuation(ifRule, (ITokenMatcher)ETokenType.ELSE);
        } else {
            ifRule.endNode();
        }
    }

    private void createLoopRules() {
        this.inState(new ERustParserStates[]{ERustParserStates.IN_METHOD}).sequence(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.LOOP, ETokenType.FOR, ETokenType.WHILE})).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, OPENING_PARENS, CLOSING_PARENS).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(ERustParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createMatchRules() {
        this.inState(new ERustParserStates[]{ERustParserStates.IN_METHOD, ERustParserStates.IN_EXPRESSION, ERustParserStates.IN_LAMBDA}).sequence(new ITokenMatcher[]{ETokenType.MATCH}).skipAfterWithNesting((ITokenMatcher)ETokenType.LBRACE, OPENING_PARENS, CLOSING_PARENS, RustShallowParser.getSubExpressionRecognizer()).createNode(EShallowEntityType.STATEMENT, INameResolver.firstMatchedTokenText()).parseUntil(ERustParserStates.IN_MATCH).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        RecognizerBase<ERustParserStates> clauseRule = this.inState(new ERustParserStates[]{ERustParserStates.IN_MATCH}).sequence(MATCH_CLAUSE_START_TYPES).skipAfter(new ITokenMatcher[]{ETokenType.DOUBLE_ARROW}).createNode(EShallowEntityType.META, "match clause");
        clauseRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(ERustParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
        clauseRule.parseOnce(ERustParserStates.IN_METHOD).optional(new ITokenMatcher[]{ETokenType.COMMA}).endNode();
    }

    private void createVariableRules(ERustParserStates state, ITokenMatcher keywords, EShallowEntityType type, String subType) {
        RecognizerBase<ERustParserStates> rule = this.inState(new ERustParserStates[]{state}).optional(new ITokenMatcher[]{ETokenType.PUB}).sequence(keywords).repeated(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MUT, ETokenType.REF}));
        RustShallowParser.finishVariableRule(rule.markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}), type, subType, INameResolver.firstMatchedTokenText());
        RustShallowParser.finishVariableRule(rule, type, subType, INameResolver.noName());
    }

    private static void finishVariableRule(RecognizerBase<ERustParserStates> rule, EShallowEntityType type, String subType, INameResolver name) {
        rule.createNode(type, subType, name).skipAfterWithNesting((ITokenMatcher)ETokenType.SEMICOLON, OPENING_BRACES, CLOSING_BRACES, RustShallowParser.getSubExpressionRecognizer()).endNode();
    }

    private void createSimpleStatementRules() {
        this.createSimpleStatementRule(ERustParserStates.IN_METHOD, "simple statement", true);
        this.inState(new ERustParserStates[]{ERustParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SEMICOLON}).createNode(EShallowEntityType.STATEMENT, "empty statement").endNode();
    }

    private void createSimpleStatementRule(ERustParserStates state, String subType, boolean consumeSemicolon) {
        RecognizerBase<ERustParserStates> statementRule = this.inState(new ERustParserStates[]{state}).sequence(STATEMENT_START_TOKENS).createNode(EShallowEntityType.STATEMENT, subType, INameResolver.firstMatchedTokenText()).skipBeforeWithNesting(ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SEMICOLON, ETokenType.COMMA, ETokenType.RBRACE, ETokenType.RPAREN}), OPENING_BRACES, CLOSING_BRACES, RustShallowParser.getSubExpressionRecognizer());
        if (consumeSemicolon) {
            statementRule = statementRule.optional(new ITokenMatcher[]{ETokenType.SEMICOLON});
        }
        statementRule.endNode();
    }

    private void createLambdaRules() {
        RustShallowParser.continueLambdaRule(this.inState(new ERustParserStates[]{ERustParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.OR}).skipAfter(new ITokenMatcher[]{ETokenType.OR}));
        RustShallowParser.continueLambdaRule(this.inState(new ERustParserStates[]{ERustParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.OROR}));
        this.createSimpleStatementRule(ERustParserStates.IN_LAMBDA, "lambda expression", false);
    }

    private static void continueLambdaRule(RecognizerBase<ERustParserStates> lambdaRule) {
        lambdaRule = lambdaRule.createNode(EShallowEntityType.METHOD, "lambda");
        RustShallowParser.finishLambdaRule(lambdaRule.sequence(new ITokenMatcher[]{ETokenType.LBRACE}));
        RustShallowParser.finishLambdaRule(lambdaRule.sequence(new ITokenMatcher[]{ETokenType.ARROW}).skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}));
        lambdaRule.parseOnce(ERustParserStates.IN_LAMBDA).endNode();
    }

    private static void finishLambdaRule(RecognizerBase<ERustParserStates> lambdaRule) {
        lambdaRule.parseUntil(ERustParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private static RecognizerBase<ERustParserStates> getSubExpressionRecognizer() {
        return new RustSubExpressionRecognizer();
    }

    public static enum ERustParserStates {
        IN_MODULE,
        IN_STRUCT,
        IN_TUPLE_STRUCT,
        IN_TRAIT,
        IN_ENUM,
        IN_METHOD,
        IN_MATCH,
        IN_EXPRESSION,
        IN_LAMBDA;

    }
}

