/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.nativex;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.nativex.BasicJsonWriter;
import org.springframework.aot.nativex.ReflectionHintsAttributes;
import org.springframework.aot.nativex.ResourceHintsAttributes;
import org.springframework.aot.nativex.SerializationHintsAttributes;
import org.springframework.core.SpringVersion;

class RuntimeHintsWriter {
    RuntimeHintsWriter() {
    }

    public void write(BasicJsonWriter writer, RuntimeHints hints) {
        List<Map<String, Object>> serialization;
        List<Map<String, Object>> resourceBundles;
        List<Map<String, Object>> resourceHints;
        List<Map<String, Object>> jni;
        List<Map<String, Object>> reflection;
        LinkedHashMap<String, Object> document = new LinkedHashMap<String, Object>();
        String springVersion = SpringVersion.getVersion();
        if (springVersion != null) {
            document.put("comment", "Spring Framework " + springVersion);
        }
        if (!(reflection = new ReflectionHintsAttributes().reflection(hints)).isEmpty()) {
            document.put("reflection", reflection);
        }
        if (!(jni = new ReflectionHintsAttributes().jni(hints)).isEmpty()) {
            document.put("jni", jni);
        }
        if (!(resourceHints = new ResourceHintsAttributes().resources(hints.resources())).isEmpty()) {
            document.put("resources", resourceHints);
        }
        if (!(resourceBundles = new ResourceHintsAttributes().resourceBundles(hints.resources())).isEmpty()) {
            document.put("bundles", resourceBundles);
        }
        if (!(serialization = new SerializationHintsAttributes().toAttributes(hints.serialization())).isEmpty()) {
            document.put("serialization", serialization);
        }
        writer.writeObject(document);
    }
}

