/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.logging;

import com.teamscale.core.log.AuditLogs;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ServiceLoggingUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static @NonNull String determineLoggedUserName(boolean includeUsername, @Nullable String username, MetaIndex metaIndex) {
        Object loggedUserName = null;
        if (username != null) {
            if (includeUsername) {
                loggedUserName = username;
            } else {
                try {
                    loggedUserName = "anon-" + DigestUtils.md5Hex((String)(username + metaIndex.getUserPseudonymizationSalt()));
                    AuditLogs.registerDeanonymizationHint((String)loggedUserName, (String)username);
                }
                catch (StorageException e) {
                    LOGGER.error("Unexpected error occurred while determining username.", (Throwable)e);
                }
            }
        }
        if (loggedUserName == null) {
            loggedUserName = "anonymous";
        }
        return loggedUserName;
    }

    private ServiceLoggingUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

