/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import java.io.Serializable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.jspecify.annotations.Nullable;

class BranchCommitInfo
implements IBranchCommitInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] commitName;
    private final byte[] parentCommitName;
    private final byte[] deltaPredecessorCommitName;
    private final byte[][] allDeltaPredecessorCommitNames;
    private final int depth;
    private final ECommitStatus status;

    public BranchCommitInfo(byte[] commitName, byte[] directPredecessorCommitName, byte[][] allDeltaPredecessorCommitNames, int depth, ECommitStatus status) {
        this.commitName = commitName;
        this.parentCommitName = directPredecessorCommitName;
        this.deltaPredecessorCommitName = (byte[])(allDeltaPredecessorCommitNames == null || allDeltaPredecessorCommitNames.length == 0 ? null : allDeltaPredecessorCommitNames[0]);
        this.allDeltaPredecessorCommitNames = allDeltaPredecessorCommitNames;
        this.depth = depth;
        this.status = status;
    }

    private BranchCommitInfo(BranchCommitInfo other, ECommitStatus status) {
        this.commitName = other.commitName;
        this.parentCommitName = other.parentCommitName;
        this.deltaPredecessorCommitName = other.deltaPredecessorCommitName;
        this.allDeltaPredecessorCommitNames = other.allDeltaPredecessorCommitNames;
        this.depth = other.depth;
        this.status = status;
    }

    @Override
    public byte[] getCommitName() {
        return this.commitName;
    }

    @Override
    public byte[] getCommitNameForDataKeys() {
        return this.getCommitName();
    }

    @Override
    public byte[] getParentCommitName() {
        return this.parentCommitName;
    }

    @Override
    public byte[] getDeltaPredecessorCommitName() {
        return this.deltaPredecessorCommitName;
    }

    @Override
    public byte[] @Nullable [] getAllDeltaPredecessorCommitNamesForDataKeys() {
        return this.allDeltaPredecessorCommitNames;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public ECommitStatus getStatus() {
        return this.status;
    }

    @Override
    public IBranchCommitInfo cloneWithNewStatus(ECommitStatus newStatus) {
        return new BranchCommitInfo(this, newStatus);
    }

    @Override
    public byte[] serializeToBytes() throws StorageException {
        return StorageUtils.serialize(this);
    }
}

