/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.monitoring;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import org.conqat.engine.persistence.store.monitoring.MonitoringToggle;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

public class OperationMonitor {
    private static final int MAX_REPORTED_OPERATION_COUNTS = 10;
    private final String name;
    private final long slowThresholdNanos;
    private final ISlowOperationReporter slowOperationReporter;
    private final AtomicLong operationCount = new AtomicLong();
    private final AtomicLong keyCount = new AtomicLong();
    private final AtomicLong timeSumNanos = new AtomicLong();
    private long resetTimeNanos;
    private final CounterSet<String> locationCounts;

    public OperationMonitor(String name, long slowThresholdNanos, ISlowOperationReporter slowOperationReporter) {
        this.name = name;
        this.slowThresholdNanos = slowThresholdNanos;
        this.slowOperationReporter = slowOperationReporter;
        this.locationCounts = MonitoringToggle.MONITORS_WITH_LOCATION_COUNTS.contains(name) ? new CounterSet() : null;
        this.reset();
    }

    public void reset() {
        this.operationCount.set(0L);
        this.keyCount.set(0L);
        this.timeSumNanos.set(0L);
        this.resetTimeNanos = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOperation(long startTimeNanos, int keyCount, String storeName) {
        long nanos = System.nanoTime() - startTimeNanos;
        this.timeSumNanos.addAndGet(nanos);
        this.operationCount.incrementAndGet();
        this.keyCount.addAndGet(keyCount);
        if (nanos > this.slowThresholdNanos) {
            this.slowOperationReporter.report(this.name, storeName, nanos, keyCount);
        }
        if (this.locationCounts != null) {
            CounterSet<String> counterSet = this.locationCounts;
            synchronized (counterSet) {
                this.locationCounts.inc((Object)("Store " + storeName + ": \n" + StringUtils.obtainStackTrace((Throwable)new RuntimeException())));
            }
        }
    }

    public OperationRates determineRatesAndReset() {
        if (this.locationCounts != null) {
            this.reportLocationCountsToStdErrAndReset();
        }
        long durationNanos = System.nanoTime() - this.resetTimeNanos;
        OperationRates rates = new OperationRates(this.name, this.operationCount.get(), this.keyCount.get(), this.timeSumNanos.get(), durationNanos);
        this.reset();
        return rates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLocationCountsToStdErrAndReset() {
        CounterSet<String> counterSet = this.locationCounts;
        synchronized (counterSet) {
            System.err.println("Storage call location counts for " + this.name + ":");
            this.locationCounts.getKeysByValueDescending().stream().limit(10L).forEach(loc -> System.err.println(this.locationCounts.getValue(loc) + " times: \n" + loc));
            this.locationCounts.clear();
        }
    }

    @FunctionalInterface
    public static interface ISlowOperationReporter {
        public static final ISlowOperationReporter EMPTY = (a, b, c, d) -> {};

        public void report(String var1, String var2, long var3, int var5);
    }

    @IndexValueClass
    public static class OperationRates
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final double operationsPerSecond;
        private final double keysPerSecond;
        private final double averageOperationSeconds;

        public OperationRates(String name, long operationCount, long keyCount, long timeSumNanos, long durationNanos) {
            this.name = name;
            this.averageOperationSeconds = operationCount == 0L ? 0.0 : OperationRates.nanosToSeconds(timeSumNanos) / (double)operationCount;
            if (durationNanos == 0L) {
                this.operationsPerSecond = 0.0;
                this.keysPerSecond = 0.0;
            } else {
                this.operationsPerSecond = (double)operationCount / OperationRates.nanosToSeconds(durationNanos);
                this.keysPerSecond = (double)keyCount / OperationRates.nanosToSeconds(durationNanos);
            }
        }

        private static double nanosToSeconds(long nanos) {
            return (double)nanos / 1.0E9;
        }

        public String getName() {
            return this.name;
        }

        public double getOperationsPerSecond() {
            return this.operationsPerSecond;
        }

        public double getKeysPerSecond() {
            return this.keysPerSecond;
        }

        public double getAverageOperationSeconds() {
            return this.averageOperationSeconds;
        }

        public String toString() {
            return this.name + ": ops/sec: " + this.operationsPerSecond + ", key/sec: " + this.keysPerSecond + ", avg sec: " + this.averageOperationSeconds;
        }
    }
}

