/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration;

import com.teamscale.core.analysis.configuration.IDynamicMetricComputation;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.metrics.AssessedRange;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.CounterSetValueCountMetricSource;
import com.teamscale.core.metrics.source.DivisionMetricSource;
import com.teamscale.core.metrics.source.DoubleAssessorMetricSource;
import com.teamscale.core.metrics.source.DynamicMetricSource;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.core.metrics.source.NormalizationMetricSource;
import com.teamscale.core.metrics.source.RangedDivisionMetricSource;
import com.teamscale.core.metrics.values.EMetricValueType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public class MetricSchemaProxy {
    private final InternalProjectId projectId;
    private final List<MetricDirectorySchemaEntry> schemaEntries = new ArrayList<MetricDirectorySchemaEntry>();
    private final List<IMetricSource> metricSources = new ArrayList<IMetricSource>();
    private final Map<String, Integer> metricNameToIndex = new HashMap<String, Integer>();

    MetricSchemaProxy(InternalProjectId projectId) {
        this.projectId = projectId;
    }

    public void addNumericMetric(String name, String displayName, String displayDescription, MetricDirectorySchemaEntry.EAggregation aggregation, EMetricProperty ... properties) throws ProjectConfigurationException {
        this.addMetric(name, this.createMetricIndexSource(name), displayName, displayDescription, EMetricValueType.NUMERIC, aggregation, properties);
    }

    public void addMetric(String metricName, IMetricSource metricSource, String displayName, String displayDescription, EMetricValueType metricValueType, MetricDirectorySchemaEntry.EAggregation aggregation, EMetricProperty ... metricProperties) throws ProjectConfigurationException {
        if (this.hasMetric(metricName)) {
            throw new ProjectConfigurationException("Metric name " + metricName + " already used in project " + String.valueOf(this.projectId));
        }
        if (aggregation == null) {
            throw new ProjectConfigurationException("Aggregation for metric " + metricName + " is not provided!");
        }
        if (!metricValueType.supportsAggregation(aggregation)) {
            throw new ProjectConfigurationException("Metric name " + metricName + " of type " + String.valueOf((Object)metricValueType) + " does not support " + String.valueOf((Object)aggregation) + " aggregation in project " + String.valueOf(this.projectId));
        }
        int metricOffset = this.metricSources.size();
        this.metricNameToIndex.put(metricName, metricOffset);
        EnumSet<EMetricProperty> properties = EnumSet.noneOf(EMetricProperty.class);
        properties.addAll(Arrays.asList(metricProperties));
        this.schemaEntries.add(new MetricDirectorySchemaEntry(displayName, displayDescription, aggregation, metricValueType, properties, (IDynamicMetricComputation)ReflectionUtils.castIfPossible((Object)metricSource, IDynamicMetricComputation.class)));
        try {
            metricSource.init(metricOffset, new MetricDirectorySchema(this.schemaEntries));
        }
        catch (ConQATException e) {
            throw new ProjectConfigurationException(e);
        }
        this.metricSources.add(metricSource);
    }

    public IMetricSource createMetricIndexSource(String metricName) {
        return new IndexMetricSource(metricName);
    }

    public IMetricSource createDivisionMetricSource(String numeratorName, String denominatorName) throws ProjectConfigurationException {
        return this.createDivisionMetricSource(numeratorName, denominatorName, 0.0, Collections.emptySet());
    }

    public IMetricSource createDivisionMetricSource(String numeratorName, String denominatorName, Set<CodeScopeName> codeScopesWithDisabledDivisionMetric) throws ProjectConfigurationException {
        return this.createDivisionMetricSource(numeratorName, denominatorName, 0.0, codeScopesWithDisabledDivisionMetric);
    }

    public IMetricSource createDivisionMetricSource(String numeratorName, String denominatorName, double defaultValueIfDenominatorZero, Set<CodeScopeName> codeScopesWithDisabledDivisionMetric) throws ProjectConfigurationException {
        this.checkMetricName(numeratorName);
        this.checkMetricName(denominatorName);
        return new DivisionMetricSource(this.metricNameToIndex.get(numeratorName), this.metricNameToIndex.get(denominatorName), defaultValueIfDenominatorZero, codeScopesWithDisabledDivisionMetric);
    }

    public IMetricSource createRangedDivisionMetricSource(String numeratorName, String denominatorName, double defaultValueIfDenominatorZero, double minValue, double maxValue) throws ProjectConfigurationException {
        this.checkMetricName(numeratorName);
        this.checkMetricName(denominatorName);
        return new RangedDivisionMetricSource(this.metricNameToIndex.get(numeratorName), this.metricNameToIndex.get(denominatorName), defaultValueIfDenominatorZero, minValue, maxValue);
    }

    public IMetricSource createNormalizationMetricSource(String metricName, double normalizationFactor) throws ProjectConfigurationException {
        this.checkMetricName(metricName);
        return new NormalizationMetricSource((int)this.metricNameToIndex.get(metricName), normalizationFactor);
    }

    public IMetricSource createDynamicMetricSource(IDynamicMetricComputation computation) {
        return new DynamicMetricSource(computation);
    }

    private void checkMetricName(String metricName) throws ProjectConfigurationException {
        if (!this.hasMetric(metricName)) {
            throw new ProjectConfigurationException("Metric of name " + metricName + " not found in project " + String.valueOf(this.projectId));
        }
    }

    public boolean hasMetric(String metricName) {
        return this.metricNameToIndex.containsKey(metricName);
    }

    public IMetricSource createAssessmentMetricSource(CodeScopeAware<String> valueMetricPerCodeScope, CodeScopeAware<String> sizeMetricPerCodeScope, CodeScopeAware<List<AssessedRange>> assessmentRangesPerCodeScope, Set<CodeScopeName> codeScopesWithDisabledAssessment) throws ProjectConfigurationException {
        CodeScopeAware<Integer> valueMetricOffsetPerCodeScope = CodeScopeAware.empty();
        CodeScopeAware<Integer> sizeMetricOffsetPerCodeScope = CodeScopeAware.empty();
        CCSMAssert.isTrue((valueMetricPerCodeScope.parameter().size() == sizeMetricPerCodeScope.parameter().size() ? 1 : 0) != 0, (String)"the number of code scopes for the value metric and size metrics is expected to be equal");
        for (CodeScopeName codeScopeName : valueMetricPerCodeScope.getCodeScopeNames()) {
            String valueMetric = valueMetricPerCodeScope.getValue(codeScopeName);
            String sizeMetric = sizeMetricPerCodeScope.getValue(codeScopeName);
            this.checkMetricName(valueMetric);
            this.checkMetricName(sizeMetric);
            valueMetricOffsetPerCodeScope.setValue(codeScopeName, this.metricNameToIndex.get(valueMetric));
            sizeMetricOffsetPerCodeScope.setValue(codeScopeName, this.metricNameToIndex.get(sizeMetric));
        }
        return new DoubleAssessorMetricSource(valueMetricOffsetPerCodeScope, sizeMetricOffsetPerCodeScope, assessmentRangesPerCodeScope, codeScopesWithDisabledAssessment);
    }

    public IMetricSource createCounterSetValueSizeMetricSource(String metricName, String[] keys) throws ProjectConfigurationException {
        this.checkMetricName(metricName);
        return new CounterSetValueCountMetricSource(this.metricNameToIndex.get(metricName), keys);
    }

    void persistTo(MetricSchemaIndex metricSchemaIndex) throws StorageException {
        metricSchemaIndex.setSchema(new MetricDirectorySchema(this.schemaEntries));
        metricSchemaIndex.setMetricSources(this.metricSources);
    }
}

