/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.enums.EnumUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FindingDescriptor
extends ConfigurationItemBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="readableName")
    private final String readableName;
    @JsonProperty(value="tool")
    private final EAnalysisTool tool;
    @JsonProperty(value="languages")
    private final Set<ELanguage> languages = EnumSet.noneOf(ELanguage.class);
    @JsonProperty(value="findingEnablement")
    private EFindingEnablement findingEnablement;
    @JsonProperty(value="defaultFindingEnablement")
    private final EFindingEnablement defaultFindingEnablement;
    @JsonProperty(value="autoAllowed")
    private final boolean autoAllowed;
    @JsonProperty(value="propertyDescriptions")
    private final Map<String, String> propertyDescriptions = new HashMap<String, String>();
    @JsonProperty(value="mappedCategory")
    private @Nullable String mappedCategory = null;
    @JsonProperty(value="mappedGroup")
    private @Nullable String mappedGroup = null;
    @JsonIgnore
    private final Set<ConfigOptionDescriptorBase> referencedOptions = new HashSet<ConfigOptionDescriptorBase>();

    public FindingDescriptor(String idAndReadableName, EAnalysisTool tool, Set<ELanguage> languages, EFindingEnablement defaultEnablement, ConfigExposed.EConfigVisibility visibility, String description) {
        this(idAndReadableName, idAndReadableName, tool, languages, defaultEnablement, visibility, description);
    }

    public FindingDescriptor(String idAndReadableName, EAnalysisTool tool, Set<ELanguage> languages, EFindingEnablement defaultEnablement, String description, Map<String, String> propertyDescriptions) {
        this(idAndReadableName, idAndReadableName, tool, languages, defaultEnablement, ConfigExposed.EConfigVisibility.DEFAULT, description);
        this.propertyDescriptions.putAll(propertyDescriptions);
    }

    public FindingDescriptor(String idAndReadableName, EAnalysisTool tool, Set<ELanguage> languages, EFindingEnablement defaultEnablement, String description) {
        this(idAndReadableName, idAndReadableName, tool, languages, defaultEnablement, ConfigExposed.EConfigVisibility.DEFAULT, description);
    }

    public FindingDescriptor(String id, String readableName, EAnalysisTool tool, Set<ELanguage> languages, EFindingEnablement defaultEnablement, String description) {
        this(id, readableName, tool, languages, defaultEnablement, ConfigExposed.EConfigVisibility.DEFAULT, description);
    }

    public FindingDescriptor(String id, String readableName, EAnalysisTool tool, Set<ELanguage> languages, EFindingEnablement defaultEnablement, String description, boolean autoAllowed) {
        this(id, readableName, tool, languages, defaultEnablement, ConfigExposed.EConfigVisibility.DEFAULT, description, autoAllowed);
    }

    public FindingDescriptor(String id, String readableName, EAnalysisTool tool, Set<ELanguage> languages, EFindingEnablement defaultEnablement, ConfigExposed.EConfigVisibility visibility, String description) {
        this(id, readableName, tool, languages, defaultEnablement, visibility, description, false);
    }

    public FindingDescriptor(String id, String readableName, EAnalysisTool tool, Set<ELanguage> languages, EFindingEnablement defaultEnablement, ConfigExposed.EConfigVisibility visibility, String description, boolean autoAllowed) {
        super(id, description, visibility);
        this.readableName = readableName;
        this.tool = tool;
        this.languages.addAll(languages);
        this.findingEnablement = defaultEnablement;
        this.defaultFindingEnablement = defaultEnablement;
        this.autoAllowed = autoAllowed || defaultEnablement == EFindingEnablement.AUTO;
    }

    public FindingDescriptor(FindingDescriptor other) {
        this(other.getName(), other.getReadableName(), other.getTool(), other.getLanguages(), other.getDefaultFindingEnablement(), other.getVisibility(), other.getDescription(), other.isAutoAllowed());
        this.mappedCategory = other.mappedCategory;
        this.mappedGroup = other.mappedGroup;
        this.propertyDescriptions.putAll(other.propertyDescriptions);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public String getReadableName() {
        return this.readableName;
    }

    public EFindingEnablement getDefaultFindingEnablement() {
        return this.defaultFindingEnablement;
    }

    @Override
    public boolean requiredToolPresent(Set<EAnalysisTool> tools) {
        return this.tool == EAnalysisTool.TEAMSCALE || tools.contains((Object)this.tool);
    }

    @Override
    public void setValue(String optionValue, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        EFindingEnablement value = (EFindingEnablement)EnumUtils.valueOfIgnoreCase(EFindingEnablement.class, (String)optionValue);
        if (value == null) {
            throw new ProjectConfigurationException("Invalid value for finding " + this.getName() + ": " + optionValue);
        }
        this.findingEnablement = value;
    }

    public EFindingEnablement getEnablement() {
        return this.findingEnablement;
    }

    public void setPropertyDescription(String propertyName, String description) {
        this.propertyDescriptions.put(propertyName, description);
    }

    public UnmodifiableMap<String, String> getPropertyDescriptions() {
        return CollectionUtils.asUnmodifiable(this.propertyDescriptions);
    }

    public void setMappedCategoryAndGroup(String category, String group) {
        CCSMAssert.isNotNull((Object)category);
        CCSMAssert.isNotNull((Object)group);
        if (this.mappedCategory != null && !this.mappedCategory.equals(category)) {
            LOGGER.warn("\tThe analysis category for FindingDescriptor '%s' has already been set to quality indicator '%s', the new quality indicator is '%s'.\n\tThis is only expected for analysis configurations that do not yet support code scopes.\n\tIf the configuration logged in this warning should already support code scopes, this is a bug and we need to make sure to register one FindingDescriptor per code scope.\n".formatted(this.readableName, this.mappedCategory, category));
        }
        CCSMAssert.isTrue((this.mappedGroup == null || this.mappedGroup.equals(group) ? 1 : 0) != 0, (String)"The analysis group has already been set for FindingDescriptor '%s' with a different value '%s', the current value is '%s'".formatted(this.readableName, this.mappedGroup, group));
        this.mappedCategory = category;
        this.mappedGroup = group;
    }

    public String getMappedCategory() {
        CCSMAssert.isNotNull((Object)this.mappedCategory, (String)"Category not yet initialized!");
        return this.mappedCategory;
    }

    public String getMappedGroup() {
        CCSMAssert.isNotNull((Object)this.mappedGroup, (String)"Group not yet initialized!");
        return this.mappedGroup;
    }

    public void addReferencedOption(ConfigOptionDescriptorBase option) {
        this.referencedOptions.add(option);
    }

    public UnmodifiableSet<ConfigOptionDescriptorBase> getReferencedOptions() {
        return CollectionUtils.asUnmodifiable(this.referencedOptions);
    }

    @Override
    public String toString() {
        return this.getName() + " (" + String.valueOf((Object)this.tool) + ") : " + String.valueOf(this.findingEnablement);
    }

    public Set<ELanguage> getLanguages() {
        return this.languages;
    }

    public EAnalysisTool getTool() {
        return this.tool;
    }

    public boolean isAutoAllowed() {
        return this.autoAllowed;
    }

    @Override
    public boolean isActive() {
        return this.findingEnablement.isEnabled();
    }

    public FindingDescriptor cloneWithUpdatedFindingDescription(String updatedFindingDescription) {
        FindingDescriptor newDescriptor = new FindingDescriptor(this.getName(), this.getReadableName(), this.getTool(), this.getLanguages(), this.getEnablement(), this.getVisibility(), updatedFindingDescription);
        if (this.mappedCategory != null && this.mappedGroup != null) {
            newDescriptor.setMappedCategoryAndGroup(this.getMappedCategory(), this.getMappedGroup());
        }
        return newDescriptor;
    }

    @Override
    public @NonNull String normalizeValue(@Nullable String value) {
        if (value == null) {
            return "";
        }
        if (value.equals(EFindingEnablement.OFF.name()) || value.equals(EFindingEnablement.UNDECIDED.name())) {
            return "%s/%s".formatted(EFindingEnablement.OFF.name(), EFindingEnablement.UNDECIDED.name());
        }
        return value;
    }
}

