/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.custom;

import java.util.List;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.RollingListIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="custom-logs", options={EStorageOption.COMPRESSED})
public class CustomLogEventIndex
implements IGlobalIndex {
    private static final int DEFAULT_MAX_SIZE = 10000;
    private final RollingListIndex<LoggingEventTransport> delegate;

    public CustomLogEventIndex(IStore store) {
        this.delegate = new RollingListIndex(store, ISerializer.forSerializable(), 10000);
    }

    private Lock getLock() {
        return this.delegate.getWrappedStore().obtainLock("lock");
    }

    public void addLoggingEvents(List<LoggingEventTransport> events) throws StorageException {
        if (events.isEmpty()) {
            return;
        }
        Lock lock = this.getLock();
        lock.lock();
        try {
            this.delegate.appendElements(events);
        }
        finally {
            lock.unlock();
        }
    }

    public List<LoggingEventTransport> getEvents() throws StorageException {
        Lock lock = this.getLock();
        lock.lock();
        try {
            List list = this.delegate.getElements();
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    public void setMaxSize(int maxSize) throws StorageException {
        Lock lock = this.getLock();
        lock.lock();
        try {
            this.delegate.setMaxSize(maxSize);
        }
        finally {
            lock.unlock();
        }
    }

    public int getMaxSize() throws StorageException {
        Lock lock = this.getLock();
        lock.lock();
        try {
            int n = this.delegate.getMaxSize();
            return n;
        }
        finally {
            lock.unlock();
        }
    }
}

