/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.metrics.directory;

import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.StepParameter;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.metrics.MetricsIndex;
import com.teamscale.core.metrics.directory.HiddenMetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.directory.MetricTrendIndex;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.source.IMetricSource;
import com.teamscale.core.metrics.source.IndexMetricSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.StringLengthComparator;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public abstract class MetricDirectoryIndexSynchronizerBase
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String USE_HIDDEN_METRICS_INDEX_PARAMETER = "use-hidden-metrics-index";
    public static final String ARCHITECTURE_FILES = "-architecture-files-";
    @IndexAccess(value=EIndexAccessMode.READ_ONLY, indexName="metric-schema")
    private MetricSchemaIndex metricSchemaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private HiddenMetricDirectoryIndex hiddenMetricDirectoryIndex;
    @StepParameter(value="use-hidden-metrics-index", optional=true)
    private boolean useHiddenMetricsDirectoryIndex = true;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metric-trend")
    private MetricTrendIndex metricTrendIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="metrics-dir")
    private MetricDirectoryIndex metricDirectoryIndex;
    private MetricDirectorySchema mergedSchema;
    private int visibleSchemaEntries = 0;
    private int hiddenSchemaEntries = 0;
    private List<IMetricSource> metricSources;
    private final Map<String, MetricDirectoryEntry> metricEntries = new HashMap<String, MetricDirectoryEntry>();
    private final Set<String> deletedPaths = new HashSet<String>();
    private MetricsIndex metricsIndex;
    private ListMap<String, String> changedEntries;
    private ListMap<String, String> removedEntries;
    private final Map<String, Integer> partitionNameToIndex = new HashMap<String, Integer>();

    private static void insertWithParentPaths(List<String> paths, Set<String> containerPaths) {
        for (String path : paths) {
            while (containerPaths.add(path)) {
                path = MetricDirectoryIndexSynchronizerBase.getParentPath(path);
            }
        }
    }

    @Override
    public final void execute() throws StorageException {
        this.metricsIndex = this.getMetricsIndex();
        KeyDelta metricsDelta = this.getMetricsDelta();
        this.changedEntries = this.metricsIndex.rawIndexKeysToPartitionToUniformMap(CollectionUtils.map(metricsDelta.getAddedOrChangedKeys(), StorageKey::getKey));
        this.removedEntries = this.metricsIndex.rawIndexKeysToPartitionToUniformMap(CollectionUtils.map(metricsDelta.getDeletedKeys(), StorageKey::getKey));
        this.mergedSchema = Objects.requireNonNull(this.metricSchemaIndex.getFullSchema());
        this.hiddenSchemaEntries = this.mergedSchema.extractHiddenSchema().size();
        this.visibleSchemaEntries = this.mergedSchema.extractPublicSchema().size();
        this.metricSources = this.metricSchemaIndex.getMetricSources();
        for (int i = 0; i < this.metricSources.size(); ++i) {
            if (!(this.metricSources.get(i) instanceof IndexMetricSource)) continue;
            this.partitionNameToIndex.put(((IndexMetricSource)this.metricSources.get(i)).getMetricPartition(), i);
        }
        this.filterEntries(this.changedEntries);
        this.filterEntries(this.removedEntries);
        this.cacheEntries();
        this.updateValues();
        this.deletePaths();
        this.aggregateAndGenerate();
        this.writeToIndex();
    }

    protected abstract MetricsIndex getMetricsIndex();

    protected abstract KeyDelta getMetricsDelta();

    private void filterEntries(ListMap<String, String> entries) {
        for (String partition : new ArrayList(entries.getKeys())) {
            if (this.partitionNameToIndex.containsKey(partition)) continue;
            entries.removeCollection((Object)partition);
        }
    }

    private void cacheEntries() throws StorageException {
        HashSet<String> cachedPaths = new HashSet<String>();
        MetricDirectoryIndexSynchronizerBase.insertWithParentPaths((List)this.changedEntries.getValues(), cachedPaths);
        MetricDirectoryIndexSynchronizerBase.insertWithParentPaths((List)this.removedEntries.getValues(), cachedPaths);
        LOGGER.info("Loading " + cachedPaths.size() + " paths from directory.");
        List<MetricDirectoryEntry> visibleMetricEntries = this.metricDirectoryIndex.getMetricDirectoryEntries(new ArrayList<String>(cachedPaths));
        List<Object> hiddenEntries = this.useHiddenMetricsDirectoryIndex ? this.hiddenMetricDirectoryIndex.getMetricDirectoryEntries(new ArrayList<String>(cachedPaths)) : Collections.nCopies(cachedPaths.size(), null);
        for (int i = 0; i < visibleMetricEntries.size(); ++i) {
            MetricDirectoryEntry metricEntry = this.mergeEntries(visibleMetricEntries.get(i), (MetricDirectoryEntry)hiddenEntries.get(i));
            if (metricEntry == null) continue;
            this.metricEntries.put(metricEntry.getUniformPath(), metricEntry);
        }
    }

    public static MetricDirectoryEntry createMetricDirectoryEntryWithDefaultValue(String uniformPath, MetricDirectorySchema schema) {
        UnmodifiableList<MetricDirectorySchemaEntry> entries = schema.getAllEntries();
        Object[] defaultMetricData = CollectionUtils.map(entries, entry -> entry.getValueType().getDefaultValue()).toArray();
        return new MetricDirectoryEntry(uniformPath, defaultMetricData);
    }

    private MetricDirectoryEntry mergeEntries(MetricDirectoryEntry visibleEntry, MetricDirectoryEntry hiddenEntry) {
        if (!this.useHiddenMetricsDirectoryIndex) {
            return visibleEntry;
        }
        if (visibleEntry == null && hiddenEntry == null) {
            return null;
        }
        if (visibleEntry == null) {
            visibleEntry = new MetricDirectoryEntry(hiddenEntry.getUniformPath(), this.visibleSchemaEntries);
        } else if (hiddenEntry == null) {
            hiddenEntry = new MetricDirectoryEntry(visibleEntry.getUniformPath(), this.hiddenSchemaEntries);
        }
        Object[] values = this.mergeValues(visibleEntry.getValues(), hiddenEntry.getValues());
        MetricDirectoryEntry result = new MetricDirectoryEntry(visibleEntry.getUniformPath(), values);
        UnmodifiableMap<String, Object[]> visibleChildMetrics = visibleEntry.getChildMetricsMap();
        UnmodifiableMap<String, Object[]> hiddenChildMetrics = hiddenEntry.getChildMetricsMap();
        for (String uniformPath : visibleChildMetrics.keySet()) {
            Object[] visibleChildValues = (Object[])visibleChildMetrics.get(uniformPath);
            Object[] hiddenChildValues = (Object[])hiddenChildMetrics.get(uniformPath);
            if (hiddenChildValues == null) {
                hiddenChildValues = this.getDefaultValuesForHiddenSchemaEntries();
                this.logMissingHiddenChildValuesError(visibleEntry, hiddenEntry, (Map<String, Object[]>)visibleChildMetrics, (Map<String, Object[]>)hiddenChildMetrics, uniformPath);
            }
            result.setChildMetrics(uniformPath, this.mergeValues(visibleChildValues, hiddenChildValues));
        }
        return result;
    }

    private Object[] getDefaultValuesForHiddenSchemaEntries() {
        return CollectionUtils.filterAndMap(this.mergedSchema.getAllEntries(), MetricDirectorySchemaEntry::isHidden, entry -> entry.getValueType().getDefaultValue()).toArray();
    }

    private void logMissingHiddenChildValuesError(MetricDirectoryEntry visibleEntry, MetricDirectoryEntry hiddenEntry, Map<String, Object[]> visibleChildMetrics, Map<String, Object[]> hiddenChildMetrics, String uniformPath) {
        LOGGER.error("No hidden child values for " + uniformPath);
        LOGGER.error("Merged schema: " + String.valueOf(this.mergedSchema));
        LOGGER.error("Visible schema entries: " + this.visibleSchemaEntries);
        LOGGER.error("Hidden schema entries: " + this.hiddenSchemaEntries);
        LOGGER.error("Visible entry: " + String.valueOf(visibleEntry));
        LOGGER.error("Hidden entry: " + String.valueOf(hiddenEntry));
        LOGGER.error("Visible child metrics: " + String.valueOf(visibleChildMetrics));
        LOGGER.error("Hidden child metrics: " + String.valueOf(hiddenChildMetrics));
    }

    private Object[] mergeValues(Object[] visibleValues, Object[] hiddenValues) {
        int i;
        Object[] result = new Object[this.mergedSchema.size()];
        int visibleIndex = 0;
        int hiddenIndex = 0;
        int numberOfExistingValues = visibleValues.length + hiddenValues.length;
        for (i = 0; i < numberOfExistingValues; ++i) {
            result[i] = this.mergedSchema.getEntry(i).isHidden() ? hiddenValues[hiddenIndex++] : visibleValues[visibleIndex++];
        }
        if (numberOfExistingValues < this.mergedSchema.size()) {
            for (i = numberOfExistingValues; i < this.mergedSchema.size(); ++i) {
                result[i] = this.mergedSchema.getEntry(i).getValueType().getDefaultValue();
            }
        }
        return result;
    }

    private void updateValues() throws StorageException {
        PairList partitionsAndPaths = new PairList();
        for (String partition : this.changedEntries.getKeys()) {
            for (String path : Objects.requireNonNull((List)this.changedEntries.getCollection((Object)partition))) {
                partitionsAndPaths.add((Object)partition, (Object)path);
            }
        }
        List<Object> values = this.metricsIndex.getMetricValues((PairList<String, String>)partitionsAndPaths);
        for (int i = 0; i < partitionsAndPaths.size(); ++i) {
            String path;
            int offset = this.partitionNameToIndex.get(partitionsAndPaths.getFirst(i));
            path = (String)partitionsAndPaths.getSecond(i);
            Object value = values.get(i);
            if (value == null) {
                LOGGER.debug("Null value set. Path = '{}' Offset = {} Partition = {}", (Object)path, (Object)offset, partitionsAndPaths.getFirst(i));
            }
            this.getOrCreateEntry(path).setValue(offset, value);
        }
    }

    private void deletePaths() throws StorageException {
        for (String partition : this.removedEntries.getKeys()) {
            for (String path : Objects.requireNonNull((List)this.removedEntries.getCollection((Object)partition))) {
                int offset = this.partitionNameToIndex.get(partition);
                this.deleteLeafMetric(path, offset);
            }
        }
    }

    private void deleteLeafMetric(String uniformPath, int offset) throws StorageException {
        if (this.deletedPaths.contains(uniformPath)) {
            return;
        }
        MetricDirectoryEntry entry = this.metricEntries.get(uniformPath);
        if (entry == null) {
            return;
        }
        if (entry.hasChildren()) {
            return;
        }
        entry.setValue(offset, null);
        if (!this.allDefaultOrDerived(entry)) {
            return;
        }
        this.deleteEntry(uniformPath);
    }

    private void deleteEntry(String uniformPath) throws StorageException {
        this.deletedPaths.add(uniformPath);
        this.metricEntries.remove(uniformPath);
        this.updateParentDirectory(uniformPath);
    }

    private void updateParentDirectory(String uniformPath) throws StorageException {
        String parentDirectoryPath = MetricDirectoryIndexSynchronizerBase.getParentPath(uniformPath);
        MetricDirectoryEntry parentDirectoryEntry = this.metricEntries.get(parentDirectoryPath);
        if (parentDirectoryEntry != null) {
            parentDirectoryEntry.removeChild(uniformPath);
            if (!(parentDirectoryEntry.hasChildren() || this.deletedPaths.contains(parentDirectoryPath) || StringUtils.isEmpty((String)parentDirectoryPath))) {
                this.deleteEntry(parentDirectoryPath);
            }
            if (!parentDirectoryEntry.hasChildren() && StringUtils.isEmpty((String)parentDirectoryPath)) {
                MetricDirectoryEntry directoryEntryWithDefaultValue = MetricDirectoryIndexSynchronizerBase.createMetricDirectoryEntryWithDefaultValue(parentDirectoryPath, this.mergedSchema);
                this.metricDirectoryIndex.setMetricDirectoryEntry(parentDirectoryPath, directoryEntryWithDefaultValue);
                this.metricEntries.put(parentDirectoryPath, directoryEntryWithDefaultValue);
            }
        }
    }

    private boolean allDefaultOrDerived(MetricDirectoryEntry entry) {
        Object[] metricValues = entry.getValues();
        for (int i = 0; i < metricValues.length; ++i) {
            if (this.metricSources.get(i).isDerived() || metricValues[i] == null) continue;
            return false;
        }
        return true;
    }

    private void aggregateAndGenerate() {
        List keys = CollectionUtils.sort(this.metricEntries.keySet(), Collections.reverseOrder(new StringLengthComparator()));
        MetricDirectoryIndexSynchronizerBase.moveArtificialKeysBeforeRootPath(keys);
        for (String key : keys) {
            this.aggregateAndGenerate(this.metricEntries.get(key));
        }
    }

    private static void moveArtificialKeysBeforeRootPath(List<String> collection) {
        List<String> artificialKeys = List.of(ARCHITECTURE_FILES);
        for (String key : artificialKeys) {
            boolean containedKey = collection.remove(key);
            if (!containedKey) continue;
            collection.add(collection.size() - 1, key);
        }
    }

    private void aggregateAndGenerate(MetricDirectoryEntry entry) {
        boolean hasChildren = entry.hasChildren();
        boolean isArchitectureSummary = entry.getUniformPath().equals(ARCHITECTURE_FILES);
        if (hasChildren) {
            this.aggregate(entry, isArchitectureSummary);
        }
        this.generate(entry, hasChildren);
        String uniformPath = entry.getUniformPath();
        if (!UniformPathCompatibilityUtil.isRootPath((String)uniformPath)) {
            MetricDirectoryEntry parent = this.metricEntries.get(MetricDirectoryIndexSynchronizerBase.getParentPath(uniformPath));
            if (parent == null) {
                LOGGER.error("Parent for path '{}' is unexpectedly null. Internal reference: TS-36559.", (Object)uniformPath);
            } else {
                parent.insertOrUpdateChild(entry);
            }
        }
    }

    private void aggregate(MetricDirectoryEntry entry, boolean isArchitectureSummary) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int offset = 0; offset < this.metricSources.size(); ++offset) {
            values.clear();
            if (UniformPath.EType.ARCHITECTURE.getPrefix().equals(entry.getUniformPath())) {
                entry.setValue(offset, null);
                continue;
            }
            entry.appendChildValues(offset, values);
            MetricDirectorySchemaEntry mergedSchemaEntry = this.mergedSchema.getEntry(offset);
            if (isArchitectureSummary && !mergedSchemaEntry.hasProperty(EMetricProperty.ARCHITECTURE_RELEVANT) || values.isEmpty()) {
                entry.setValue(offset, null);
                continue;
            }
            entry.setValue(offset, this.metricSources.get(offset).aggregate(values, mergedSchemaEntry));
        }
    }

    private void generate(MetricDirectoryEntry entry, boolean hasChildren) {
        CounterSet codeScopes = entry.getValueWithoutNullAssert(this.mergedSchema, "Code Scope", CounterSet.class);
        if (codeScopes == null || codeScopes.isEmpty()) {
            LOGGER.debug("No value found for the code scope metric for MetricDirectoryEntry '%s'".formatted(entry.getUniformPath()));
            codeScopes = new CounterSet(List.of(CodeScopeAware.DEFAULT_CODE_SCOPE.name()));
        }
        for (int offset = 0; offset < this.metricSources.size(); ++offset) {
            this.metricSources.get(offset).generateValue(entry.getValues(), hasChildren, this.mergedSchema.getEntry(offset), (CounterSet<String>)codeScopes);
        }
    }

    private static String getParentPath(String uniformPath) {
        if (UniformPathUtils.isArchitectureFile((String)uniformPath)) {
            return ARCHITECTURE_FILES;
        }
        return UniformPathUtils.getParentPath((String)uniformPath);
    }

    private void writeToIndex() throws StorageException {
        ArrayList<String> deletedPathsList = new ArrayList<String>(this.deletedPaths);
        this.metricDirectoryIndex.removeMetricDirectoryEntries(deletedPathsList);
        this.metricTrendIndex.removeValues(deletedPathsList, this.getSchedulingCommit());
        if (this.useHiddenMetricsDirectoryIndex) {
            this.hiddenMetricDirectoryIndex.removeMetricDirectoryEntries(deletedPathsList);
        }
        PairList newVisibleValues = new PairList();
        PairList newHiddenValues = new PairList();
        for (MetricDirectoryEntry entry : this.metricEntries.values()) {
            this.splitAndInsertEntry(entry, (PairList<String, MetricDirectoryEntry>)newVisibleValues, (PairList<String, MetricDirectoryEntry>)newHiddenValues);
        }
        this.metricDirectoryIndex.setMetricDirectoryEntries((PairList<String, MetricDirectoryEntry>)newVisibleValues);
        if (this.useHiddenMetricsDirectoryIndex) {
            this.hiddenMetricDirectoryIndex.setMetricDirectoryEntries((PairList<String, MetricDirectoryEntry>)newHiddenValues);
        }
        PairList trendValues = new PairList();
        for (int i = 0; i < newVisibleValues.size(); ++i) {
            trendValues.add((Object)((String)newVisibleValues.getFirst(i)), (Object)((MetricDirectoryEntry)newVisibleValues.getSecond(i)).getValues());
        }
        this.metricTrendIndex.setValues(trendValues, this.getSchedulingCommit());
        LOGGER.info("Deleted " + this.deletedPaths.size() + " entries and updated " + newVisibleValues.size() + " entries");
    }

    private void splitAndInsertEntry(MetricDirectoryEntry entry, PairList<String, MetricDirectoryEntry> newVisibleValues, PairList<String, MetricDirectoryEntry> newHiddenValues) {
        Object[] visibleValues = new Object[this.visibleSchemaEntries];
        Object[] hiddenValues = new Object[this.hiddenSchemaEntries];
        this.splitValues(entry.getValues(), visibleValues, hiddenValues);
        String uniformPath = entry.getUniformPath();
        MetricDirectoryEntry visibleEntry = new MetricDirectoryEntry(uniformPath, visibleValues);
        MetricDirectoryEntry hiddenEntry = new MetricDirectoryEntry(uniformPath, hiddenValues);
        UnmodifiableMap<String, Object[]> childMetrics = entry.getChildMetricsMap();
        for (Map.Entry childEntry : childMetrics.entrySet()) {
            Object[] visibleChildValues = new Object[this.visibleSchemaEntries];
            Object[] hiddenChildValues = new Object[this.hiddenSchemaEntries];
            this.splitValues((Object[])childEntry.getValue(), visibleChildValues, hiddenChildValues);
            visibleEntry.setChildMetrics((String)childEntry.getKey(), visibleChildValues);
            hiddenEntry.setChildMetrics((String)childEntry.getKey(), hiddenChildValues);
        }
        newVisibleValues.add((Object)uniformPath, (Object)visibleEntry);
        newHiddenValues.add((Object)uniformPath, (Object)hiddenEntry);
    }

    private void splitValues(Object[] values, Object[] visibleValues, Object[] hiddenValues) {
        int visibleIndex = 0;
        int hiddenIndex = 0;
        for (int i = 0; i < values.length; ++i) {
            if (this.mergedSchema.getEntry(i).isHidden()) {
                hiddenValues[hiddenIndex++] = values[i];
                continue;
            }
            visibleValues[visibleIndex++] = values[i];
        }
    }

    private MetricDirectoryEntry getOrCreateEntry(String uniformPath) {
        MetricDirectoryEntry metricEntry = this.metricEntries.get(uniformPath);
        if (metricEntry == null) {
            metricEntry = new MetricDirectoryEntry(uniformPath, this.mergedSchema);
            this.metricEntries.put(uniformPath, metricEntry);
            if (!UniformPathCompatibilityUtil.isRootPath((String)uniformPath)) {
                String parentPath = MetricDirectoryIndexSynchronizerBase.getParentPath(uniformPath);
                MetricDirectoryEntry parent = this.getOrCreateEntry(parentPath);
                parent.insertOrUpdateChild(metricEntry);
            }
        }
        return metricEntry;
    }
}

