/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.permissions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EBasicRole;
import com.teamscale.core.permissions.roles.GlobalRole;
import com.teamscale.core.permissions.roles.ProjectRole;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class SubjectRoleAssignments
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="subjectType")
    private final ESubjectType subjectType;
    @JsonProperty(value="subjectId")
    private String subjectId;
    @JsonProperty(value="globalRoles")
    private final Set<String> globalRoles = new HashSet<String>();
    @JsonProperty(value="globalInstanceRoles")
    private final Map<EBasicPermissionScope, Set<String>> globalInstanceRoles = new HashMap<EBasicPermissionScope, Set<String>>();
    @JsonProperty(value="instanceRoles")
    private final Map<EBasicPermissionScope, Map<String, Set<String>>> instanceRoles = new HashMap<EBasicPermissionScope, Map<String, Set<String>>>();
    @JsonProperty(value="globalProjectRoles")
    private final Set<String> globalProjectRoles = new HashSet<String>();
    @JsonProperty(value="projectRoles")
    private final Map<IProjectId, Set<String>> projectRoles = new HashMap<IProjectId, Set<String>>();

    @JsonCreator
    public SubjectRoleAssignments(@JsonProperty(value="subjectType") ESubjectType subjectType, @JsonProperty(value="subjectId") String subjectId) {
        CCSMAssert.isNotNull((Object)((Object)subjectType));
        CCSMAssert.isNotNull((Object)subjectId);
        this.subjectType = subjectType;
        this.subjectId = subjectId;
    }

    public String getSubjectId() {
        return this.subjectId;
    }

    public void setSubjectId(String subjectId) {
        this.subjectId = subjectId;
    }

    public ESubjectType getSubjectType() {
        return this.subjectType;
    }

    public void addGlobalRole(GlobalRole globalRole) {
        this.globalRoles.add(globalRole.getReadableName());
    }

    public void removeGlobalRole(String roleName) {
        this.globalRoles.remove(roleName);
    }

    public Set<String> getGlobalRoleNames() {
        return this.globalRoles;
    }

    public Set<String> getGlobalBasicRoles(EBasicPermissionScope permissionScope) {
        Set<String> rolesOnScope = this.globalInstanceRoles.get((Object)permissionScope);
        if (rolesOnScope == null) {
            rolesOnScope = new HashSet<String>();
            this.globalInstanceRoles.put(permissionScope, rolesOnScope);
        }
        return rolesOnScope;
    }

    public Map<String, Set<String>> getBasicRoles(EBasicPermissionScope permissionScope) {
        return Optional.ofNullable(this.instanceRoles.get((Object)permissionScope)).orElse((Map<String, Set<String>>)CollectionUtils.emptyMap());
    }

    public Set<String> getGlobalProjectRoles() {
        return this.globalProjectRoles;
    }

    public Map<IProjectId, Set<String>> getProjectRoles() {
        return Optional.ofNullable(this.projectRoles).orElse((Map<IProjectId, Set<String>>)CollectionUtils.emptyMap());
    }

    public void addGlobalBasicRole(EBasicPermissionScope permissionScope, EBasicRole basicRole) {
        this.getGlobalBasicRoles(permissionScope).add(basicRole.getReadableName());
    }

    public void removeGlobalBasicRole(EBasicPermissionScope permissionScope, EBasicRole basicRole) {
        this.getGlobalBasicRoles(permissionScope).remove(basicRole.getReadableName());
    }

    public void addBasicRole(EBasicPermissionScope permissionScope, String instanceId, EBasicRole basicRole) {
        this.getRolesForInstance(permissionScope, instanceId).add(basicRole.getReadableName());
    }

    public void addProjectRole(IProjectId projectId, ProjectRole projectRole) {
        this.getProjectRoles(projectId).add(projectRole.getReadableName());
    }

    public void removeProjectRole(IProjectId projectId, ProjectRole projectRole) {
        this.getProjectRoles(projectId).remove(projectRole.getReadableName());
    }

    public void deleteProjectRole(String roleName) {
        this.globalProjectRoles.remove(roleName);
        this.projectRoles.values().forEach(roles -> roles.remove(roleName));
    }

    private Set<String> getRolesForInstance(EBasicPermissionScope permissionScope, String instanceId) {
        return PermissionUtils.getNestedSetSafe(this.instanceRoles, permissionScope, instanceId);
    }

    public void addGlobalProjectRole(ProjectRole projectRole) {
        this.globalProjectRoles.add(projectRole.getReadableName());
    }

    public void removeGlobalProjectRole(ProjectRole projectRole) {
        this.globalProjectRoles.remove(projectRole.getReadableName());
    }

    private Set<String> getProjectRoles(IProjectId projectId) {
        return this.projectRoles.computeIfAbsent(projectId, k -> new HashSet());
    }

    public void removeBasicRole(EBasicPermissionScope permissionScope, String instanceId, EBasicRole instanceRole) {
        this.getRolesForInstance(permissionScope, instanceId).remove(instanceRole.getReadableName());
    }

    private static void performRoleRename(Set<String> rolesNames, String oldRoleName, String newRoleName) {
        if (rolesNames.contains(oldRoleName)) {
            rolesNames.remove(oldRoleName);
            rolesNames.add(newRoleName);
        }
    }

    public void renameGlobalRole(String oldRoleName, GlobalRole newRole) {
        SubjectRoleAssignments.performRoleRename(this.globalRoles, oldRoleName, newRole.getReadableName());
    }

    public void renameProjectRole(String oldRoleName, ProjectRole newRole) {
        String newRoleName = newRole.getReadableName();
        SubjectRoleAssignments.performRoleRename(this.globalProjectRoles, oldRoleName, newRoleName);
        this.projectRoles.values().forEach(projectRoles -> SubjectRoleAssignments.performRoleRename(projectRoles, oldRoleName, newRoleName));
    }

    public boolean isEmpty() {
        return this.globalRoles.isEmpty() && this.projectRoles.isEmpty() && this.globalProjectRoles.isEmpty() && this.globalInstanceRoles.isEmpty() && this.instanceRoles.isEmpty();
    }
}

