/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.rollback;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.KeyValueCollectingCallback;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@Index(name="postponed-rollbacks", options={EStorageOption.COMPRESSED}, valueClasses={PostponedRollback.class})
public class PostponedRollbackIndex
extends IndexBase
implements IProjectIndex,
IRollbackableIndex {
    public static final String INDEX_NAME = "postponed-rollbacks";
    private static final String COUNT_KEY = "##count##";

    public PostponedRollbackIndex(IStore store) {
        super(store);
    }

    public int getEntryCount() throws StorageException {
        byte[] value = this.store.getWithString(COUNT_KEY);
        if (value == null) {
            return 0;
        }
        return ByteArrayUtils.byteArrayToInt((byte[])value);
    }

    public void insertPostponedRollback(String reason, List<CommitDescriptor> rollbackCommits) throws StorageException {
        if (this.isAlreadyContained(reason, rollbackCommits = CollectionUtils.sort(rollbackCommits, (Comparator)CommitDescriptor.BY_TIMESTAMP_COMPARATOR))) {
            return;
        }
        String id = UUID.randomUUID().toString();
        this.store.putWithString(id, StorageUtils.serialize((Serializable)new PostponedRollback(id, DateTimeUtils.millisNow(), reason, rollbackCommits)));
        this.store.performWithLock(() -> this.store.putWithString(COUNT_KEY, ByteArrayUtils.intToByteArray((int)(1 + this.getEntryCount()))));
    }

    private boolean isAlreadyContained(String reason, List<CommitDescriptor> rollbackCommits) throws StorageException {
        for (PostponedRollback postponedRollback : this.getAllPostponedRollbacks()) {
            if (!reason.equals(postponedRollback.reason) || !rollbackCommits.equals(postponedRollback.rollbackCommits)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEntryWithSameReason(String reason) throws StorageException {
        for (PostponedRollback postponedRollback : this.getAllPostponedRollbacks()) {
            if (!reason.equals(postponedRollback.reason)) continue;
            return true;
        }
        return false;
    }

    public Optional<PostponedRollback> getPostponedRollbackById(String id) throws StorageException {
        byte[] value = this.store.getWithString(id);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of((PostponedRollback)StorageUtils.deserialize((byte[])value));
    }

    public List<PostponedRollback> getAllPostponedRollbacks() throws StorageException {
        PairList entries = new PairList();
        this.store.scan(new byte[0], (IKeyValueCallback)new KeyValueCollectingCallback(entries));
        ArrayList<PostponedRollback> result = new ArrayList<PostponedRollback>();
        for (int i = 0; i < entries.size(); ++i) {
            if (COUNT_KEY.equals(StringUtils.bytesToString((byte[])((byte[])entries.getFirst(i))))) continue;
            result.add((PostponedRollback)StorageUtils.deserialize((byte[])((byte[])entries.getSecond(i))));
        }
        return result;
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        ArrayList<String> toDelete = new ArrayList<String>();
        PairList toUpdate = new PairList();
        int newCount = 0;
        for (PostponedRollback postponedRollback : this.getAllPostponedRollbacks()) {
            boolean hadRemovals = postponedRollback.rollbackCommits.removeIf(commit -> timestampByBranch.containsKey(commit.getBranchName()) && commit.getTimestamp() >= (Long)timestampByBranch.get(commit.getBranchName()));
            if (postponedRollback.rollbackCommits.isEmpty()) {
                toDelete.add(postponedRollback.id);
                continue;
            }
            if (hadRemovals) {
                toUpdate.add((Object)postponedRollback.id, (Object)StorageUtils.serialize((Serializable)postponedRollback));
                ++newCount;
                continue;
            }
            ++newCount;
        }
        if (!toDelete.isEmpty()) {
            this.store.removeWithStrings(toDelete);
        }
        toUpdate.add((Object)COUNT_KEY, (Object)ByteArrayUtils.intToByteArray((int)newCount));
        this.store.putWithStrings(toUpdate);
    }

    public void removePostponedRollback(String id) throws StorageException {
        byte[] value = this.store.getWithString(id);
        if (value == null) {
            return;
        }
        this.store.removeWithString(id);
        this.store.performWithLock(() -> this.store.putWithString(COUNT_KEY, ByteArrayUtils.intToByteArray((int)Math.max(0, this.getEntryCount() - 1))));
    }

    @IndexValueClass
    public static class PostponedRollback
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="id")
        public final String id;
        @JsonProperty(value="timestamp")
        public final long timestamp;
        @JsonProperty(value="reason")
        public final String reason;
        @JsonProperty(value="rollbackCommits")
        public final List<CommitDescriptor> rollbackCommits;

        public PostponedRollback(String id, long timestamp, String reason, List<CommitDescriptor> rollbackCommits) {
            this.id = id;
            this.timestamp = timestamp;
            this.reason = reason;
            this.rollbackCommits = rollbackCommits;
        }
    }
}

