/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckFindingBuilderBase;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.java.spring.SpringChecksUtils;
import eu.cqse.check.java.spring.TypesWithSpringScopeExtractorPhase;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Check(id="java:S6832", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={TypesWithSpringScopeExtractorPhase.class})
public class NonSingletonAutowiredInSingletonCheck
extends CheckImplementationBase {
    private static final String MESSAGE = "Don't auto-wire this non-Singleton bean into a Singleton bean (%s)";
    private static final int TYPE_GROUP_INDEX = 4;
    private static final TokenPattern ATTRIBUTE_TYPE_PATTERN = TokenPattern.of().repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).group(4).sequence(new Object[]{ETokenType.IDENTIFIER}).group(4);
    private static final TokenPattern PARAMETER_TYPE_PATTERN = TokenPattern.of().optional(new Object[]{LanguageFeatureParser.JAVA.getAnnotationPattern()}).repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).group(4).sequence(new Object[]{ETokenType.IDENTIFIER}).group(4);
    private JavaImportSensitiveTypeResolver typeResolver;
    private Map<String, TypesWithSpringScopeExtractorPhase.SpringScope> localSpringTypes;
    private List<ShallowEntity> ast;

    public void execute() throws CheckException {
        ShallowEntity rootEntity = this.context.getRootEntity(this.getCodeViewOption());
        this.ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        if (SpringChecksUtils.containsNoSpringImport(rootEntity)) {
            return;
        }
        this.typeResolver = new JavaImportSensitiveTypeResolver(rootEntity);
        this.localSpringTypes = new HashMap<String, TypesWithSpringScopeExtractorPhase.SpringScope>();
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE);
        types.forEach(type -> this.localSpringTypes.put(type.getName(), SpringChecksUtils.getScopeOfBean(type)));
        for (ShallowEntity type2 : types) {
            type2.getChildren().stream().filter(attribute -> attribute.getType() == EShallowEntityType.ATTRIBUTE).forEach(this::checkAttribute);
            type2.getChildren().stream().filter(child -> child.getType() == EShallowEntityType.METHOD).forEach(this::checkMethod);
        }
    }

    private void checkAttribute(ShallowEntity attribute) {
        if (NonSingletonAutowiredInSingletonCheck.parentIsNotSingleton(attribute)) {
            return;
        }
        if (!LanguageFeatureParser.JAVA.hasAnnotation(attribute, SpringChecksUtils.INJECTION_ANNOTATIONS)) {
            return;
        }
        this.checkScopeOfType(NonSingletonAutowiredInSingletonCheck.extractTypeOfAttribute(attribute), InjectionType.AUTOWIRED_FIELD);
    }

    private void checkMethod(ShallowEntity method) {
        boolean isSingleArgumentConstructor;
        if (NonSingletonAutowiredInSingletonCheck.parentIsNotSingleton(method)) {
            return;
        }
        boolean methodIsAutowired = LanguageFeatureParser.JAVA.hasAnnotation(method, SpringChecksUtils.INJECTION_ANNOTATIONS);
        boolean isSetter = LanguageFeatureParser.JAVA.isSetterMethod(method);
        boolean isConstructor = LanguageFeatureParser.JAVA.isConstructorOfType(method.getParent(), method);
        boolean bl = isSingleArgumentConstructor = isConstructor && !methodIsAutowired && LanguageFeatureParser.JAVA.getSplitParameterTokens(method).size() == 1;
        if (isSingleArgumentConstructor) {
            this.checkParametersOfMethod(method, true, InjectionType.SINGLE_ARGUMENT_CONSTRUCTOR);
        } else if (isConstructor) {
            this.checkParametersOfMethod(method, methodIsAutowired, InjectionType.AUTOWIRED_CONSTRUCTOR);
        } else if (isSetter) {
            this.checkParametersOfMethod(method, methodIsAutowired, InjectionType.AUTOWIRED_SETTER_METHOD);
        }
    }

    private void checkParametersOfMethod(ShallowEntity method, boolean methodIsAutowired, InjectionType injectionType) {
        for (List parameter : LanguageFeatureParser.JAVA.getSplitParameterTokens(method)) {
            if (!methodIsAutowired) {
                boolean parameterIsAutowired = LanguageFeatureParser.JAVA.extractAnnotationsFromParameter(parameter).stream().anyMatch(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, SpringChecksUtils.INJECTION_ANNOTATIONS));
                if (!parameterIsAutowired) continue;
                injectionType = InjectionType.AUTOWIRED_PARAMETER;
            }
            this.checkScopeOfType(NonSingletonAutowiredInSingletonCheck.extractTypeOfMethodParameter(parameter), injectionType);
        }
    }

    private static boolean parentIsNotSingleton(ShallowEntity entity) {
        return entity.getParent() == null || SpringChecksUtils.getScopeOfBean(entity.getParent()) != TypesWithSpringScopeExtractorPhase.SpringScope.SINGLETON;
    }

    private static List<IToken> extractTypeOfMethodParameter(List<IToken> parameter) {
        TokenPatternMatch match = PARAMETER_TYPE_PATTERN.findFirstMatch(parameter);
        if (match == null) {
            return Collections.emptyList();
        }
        return match.groupTokens(4);
    }

    private static List<IToken> extractTypeOfAttribute(ShallowEntity attribute) {
        TokenPatternMatch match = ATTRIBUTE_TYPE_PATTERN.findFirstMatch((List)attribute.ownStartTokens());
        if (match == null) {
            return Collections.emptyList();
        }
        return match.groupTokens(4);
    }

    private void checkScopeOfType(List<IToken> type, InjectionType injectionType) {
        if (type.isEmpty()) {
            return;
        }
        String typeText = TokenStreamTextUtils.concatTokenTexts(type);
        this.searchWithFullyQualifiedName(this.typeResolver.getFullyQualifiedTypeName(typeText)).or(() -> this.searchForInnerClass(type)).or(() -> this.searchInSameFile(typeText)).or(() -> this.searchInSamePackage(typeText)).filter(scope -> scope != TypesWithSpringScopeExtractorPhase.SpringScope.SINGLETON).map(scope -> this.buildFinding(injectionType.getMessage(), this.buildLocation().forTokens(type))).ifPresent(CheckFindingBuilderBase::createAndStore);
    }

    private Optional<TypesWithSpringScopeExtractorPhase.SpringScope> searchForInnerClass(List<IToken> type) {
        String first = type.getFirst().getText();
        String rest = TokenStreamTextUtils.concatTokenTexts(type.subList(1, type.size()));
        String fullyQualifiedTypeName = this.typeResolver.getFullyQualifiedTypeName(first) + rest;
        return this.searchWithFullyQualifiedName(fullyQualifiedTypeName);
    }

    private Optional<TypesWithSpringScopeExtractorPhase.SpringScope> searchWithFullyQualifiedName(String fullyQualifiedTypeName) {
        return ((List)this.context.accessPhaseInvertedResult(TypesWithSpringScopeExtractorPhase.class).apply(fullyQualifiedTypeName)).stream().findFirst().map(TypesWithSpringScopeExtractorPhase.TypeWithSpringScope::getAdditionalInformation);
    }

    private Optional<TypesWithSpringScopeExtractorPhase.SpringScope> searchInSameFile(String type) {
        return Optional.ofNullable(this.localSpringTypes.get(type));
    }

    private Optional<TypesWithSpringScopeExtractorPhase.SpringScope> searchInSamePackage(String type) {
        return LanguageFeatureParser.JAVA.getPackageName(this.ast).map(packageName -> packageName + "." + type).map(this::searchWithFullyQualifiedName).orElse(this.searchWithFullyQualifiedName(type));
    }

    private static enum InjectionType {
        AUTOWIRED_FIELD("autowired field"),
        AUTOWIRED_PARAMETER("autowired parameter"),
        AUTOWIRED_SETTER_METHOD("autowired setter method"),
        AUTOWIRED_CONSTRUCTOR("autowired constructor"),
        SINGLE_ARGUMENT_CONSTRUCTOR("single argument constructor");

        private final String stringValue;

        private InjectionType(String stringValue) {
            this.stringValue = stringValue;
        }

        private String getMessage() {
            return NonSingletonAutowiredInSingletonCheck.MESSAGE.formatted(this.stringValue);
        }
    }
}

