/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Check(id="java:S5973", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class TestStabilityCheck
extends CheckImplementationBase {
    private static final String SUCCESS_PERCENTAGE = "successPercentage";
    private static final Set<String> TESTNG_ANNOTATIONS = Set.of("Test", "org.testng.annotations.Test");

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD).forEach(this::handleMethod);
    }

    private void handleMethod(ShallowEntity method) {
        LanguageFeatureParser.JAVA.getAnnotations(method).stream().filter(annotation -> LanguageFeatureParser.JAVA.isSpecificAnnotation(annotation, TESTNG_ANNOTATIONS)).filter(annotation -> TokenStreamTextUtils.contains((List)annotation.ownStartTokens(), (String)SUCCESS_PERCENTAGE)).forEach(annotation -> this.buildFinding(TestStabilityCheck.createMessage(method), this.buildLocation().forEntityFirstLine(annotation)).createAndStore());
    }

    private static String createMessage(ShallowEntity method) {
        return "Make `%s` stable and remove the `%s` argument".formatted(method.getName(), SUCCESS_PERCENTAGE);
    }
}

