/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.CollectionUtils;

public class MatlabFunctionDeclaration {
    static final EnumSet<ETokenType> DECLARATION_RELEVANT_TOKEN_TYPES = EnumSet.of(ETokenType.FUNCTION, new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.LPAREN, ETokenType.RPAREN, ETokenType.LBRACK, ETokenType.RBRACK, ETokenType.ARRAY_SEPARATOR, ETokenType.COMMA, ETokenType.COMP});
    private final List<IToken> declaration;
    private final List<IToken> output;
    private final List<IToken> input;
    private final IToken functionName;
    private final int declarationLeftParenthesisIndex;

    private MatlabFunctionDeclaration(List<IToken> functionDeclaration) {
        this.declaration = functionDeclaration;
        this.declarationLeftParenthesisIndex = TokenStreamUtils.firstTokenMatching(functionDeclaration, (int)0, (ITokenMatcher)ETokenType.LPAREN);
        this.functionName = this.extractFunctionNameToken();
        this.output = this.extractFunctionOutputTokens();
        this.input = this.extractFunctionInputTokens();
    }

    public static MatlabFunctionDeclaration of(List<IToken> functionDeclarationTokens) {
        if (!MatlabFunctionDeclaration.isValidDeclaration(functionDeclarationTokens)) {
            return null;
        }
        return new MatlabFunctionDeclaration(functionDeclarationTokens);
    }

    private static boolean isValidDeclaration(List<IToken> functionDeclarationTokens) {
        TokenPattern argument = new TokenPattern().alternative(new Object[]{ETokenType.COMP, ETokenType.IDENTIFIER});
        TokenPattern argumentList = new TokenPattern().sequence(new Object[]{argument}).repeated(new Object[]{ETokenType.ARRAY_SEPARATOR, argument});
        TokenPattern outputPattern = new TokenPattern().optional(new Object[]{ETokenType.LBRACK}).optional(new Object[]{argumentList}).optional(new Object[]{ETokenType.RBRACK});
        TokenPattern inputPattern = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).optional(new Object[]{argumentList}).sequence(new Object[]{ETokenType.RPAREN});
        TokenPattern pattern = new TokenPattern().beginningOfStream().optional(new Object[]{ETokenType.FUNCTION}).optional(new Object[]{outputPattern, ETokenType.EQ}).sequence(new Object[]{ETokenType.IDENTIFIER}).optional(new Object[]{inputPattern}).endOfStream();
        return pattern.matchesAnywhere(functionDeclarationTokens);
    }

    private List<IToken> extractFunctionOutputTokens() {
        int eqIndex = TokenStreamUtils.firstTokenMatching(this.declaration, (int)0, (ITokenMatcher)ETokenType.EQ);
        if (eqIndex != -1) {
            return this.getIdentifierBetween(0, eqIndex);
        }
        return CollectionUtils.emptyList();
    }

    private List<IToken> extractFunctionInputTokens() {
        if (this.declarationLeftParenthesisIndex != -1) {
            return this.getIdentifierBetween(this.declarationLeftParenthesisIndex, this.declaration.size());
        }
        return CollectionUtils.emptyList();
    }

    private List<IToken> getIdentifierBetween(int startIndex, int endIndex) {
        return TokenStreamUtils.findAll(this.declaration, (int)startIndex, (int)endIndex, (ITokenMatcher)ETokenType.IDENTIFIER).stream().map(this.declaration::get).collect(Collectors.toList());
    }

    private IToken extractFunctionNameToken() {
        if (this.declarationLeftParenthesisIndex != -1) {
            return this.declaration.get(TokenStreamUtils.lastTokenMatching(this.declaration, (int)0, (int)this.declarationLeftParenthesisIndex, (ITokenMatcher)ETokenType.IDENTIFIER));
        }
        return this.declaration.get(TokenStreamUtils.lastTokenMatching(this.declaration, (ITokenMatcher)ETokenType.IDENTIFIER));
    }

    public List<IToken> getFunctionOutputTokens() {
        return this.output;
    }

    public List<IToken> getFunctionInputTokens() {
        return this.input;
    }

    public IToken getFunctionNameToken() {
        return this.functionName;
    }

    private String getFunctionNameText() {
        return this.functionName.getText();
    }

    public List<IToken> getFunctionDeclarationTokens() {
        return this.declaration;
    }

    public String toString() {
        Object representation = "";
        representation = (String)representation + "==========\n";
        representation = (String)representation + "function\t: " + this.getFunctionNameText() + "\n";
        representation = (String)representation + "input\t:\n\t " + String.valueOf(this.input.stream().map(IToken::getText).collect(Collectors.toList())) + "\n";
        representation = (String)representation + "output\t:\n\t" + String.valueOf(this.output.stream().map(IToken::getText).collect(Collectors.toList())) + "\n";
        representation = (String)representation + "==========";
        return representation;
    }
}

