/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.simulink.commented-out-elements", languages={ELanguage.SIMULINK})
public class SimulinkCommentedOutElementsCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Remove the commented-out element.");

    public void execute() throws CheckException {
        Optional model = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (model.isEmpty()) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)((SimulinkBlock)model.get()), (boolean)false, (boolean)true)) {
            this.checkBlock(block);
        }
        if (((SimulinkModel)model.get()).getStateflowMachine() != null) {
            for (StateflowChart chart : ((SimulinkModel)model.get()).getStateflowMachine().getCharts(true)) {
                this.checkStateflowChart(chart);
                this.checkTransitions(StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)true));
            }
        }
    }

    private void checkTransitions(List<StateflowTransition> allTransitions) {
        for (StateflowTransition transition : allTransitions) {
            if (!StateflowUtils.isCommented((ParameterizedElement)transition)) continue;
            this.buildFinding("Transition is commented out", (ElementLocation)this.buildLocation().forStateflowTransition(transition)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkBlock(SimulinkBlock block) {
        if (SimulinkUtils.isCommentedBlock((SimulinkBlock)block)) {
            this.buildFinding("Block is commented out", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private void checkStateflowChart(StateflowChart chart) {
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)true)) {
            if (!StateflowUtils.isCommented((ParameterizedElement)node)) continue;
            this.buildFinding("Stateflow element is commented out", (ElementLocation)this.buildLocation().forStateflowNode(node)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

