/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionAstUtils;
import eu.cqse.check.simulink.stateflow_data_typing.StateflowVariableTypeExtractor;
import eu.cqse.check.util.SimulinkCheckUtils;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowStateAction;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowDeclContainerBase;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.hisf_0003", languages={ELanguage.SIMULINK})
public class SimulinkStateflowUsageOfBitwiseOperationsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Bitwise operations {0} shall not be used with signed data type";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Consider changing the input data type to an unsigned type.");
    private static final Set<String> MATLAB_BITWISE_FUNCTIONS = Set.of("bitset", "bitget", "bitcmp", "swapbytes", "bitand", "bitor", "bitxor", "bitshift");
    private static final Set<ETokenType> BITWISE_OPERATORS_EXCEPT_RIGHT_SHIFT = EnumSet.of(ETokenType.AND, ETokenType.OR, ETokenType.XOR, ETokenType.COMP, ETokenType.LSHIFT);
    private static final String RIGHT_SHIFT_OPERATOR = ">>";
    private static final Set<String> SIGNED_TYPES = Set.of("int8", "int16", "int32", "int64", "single", "double");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        StateflowVariableTypeExtractor types = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().map(StateflowVariableTypeExtractor::new).orElse(null);
        if (model == null || types == null) {
            return;
        }
        for (StateflowChart chart : StateflowUtils.getStateflowChartsFromModel((SimulinkModel)model, (boolean)false)) {
            this.checkNodes(types, chart);
            this.checkTransitions(types, chart);
        }
    }

    private void checkNodes(StateflowVariableTypeExtractor types, StateflowChart chart) {
        for (StateflowNodeBase node : StateflowUtils.listNodesRecursively((StateflowChart)chart, (boolean)false)) {
            if (!(node instanceof StateflowState)) continue;
            List stateflowStateActions = StateflowCheckUtils.splitStateActionsFromStateLabel((StateflowState)((StateflowState)node));
            for (StateflowStateAction stateflowStateAction : stateflowStateActions) {
                if (stateflowStateAction.actionDeclaration.isEmpty() || stateflowStateAction.actionCode.isEmpty()) continue;
                this.checkBitwiseOperations(chart, stateflowStateAction.actionCode, this.buildLocation().forStateflowNode(node), types);
            }
        }
    }

    private void checkTransitions(StateflowVariableTypeExtractor types, StateflowChart chart) {
        for (StateflowTransition transition : StateflowUtils.getAllTransitionsAsSet((StateflowChart)chart, (boolean)false)) {
            StateflowTransitionParts stateflowTransitionParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
            QualifiedNameLocation location = this.buildLocation().forStateflowTransition(transition);
            this.checkBitwiseOperations(chart, stateflowTransitionParts.conditionAction, location, types);
            this.checkBitwiseOperations(chart, stateflowTransitionParts.transitionAction, location, types);
        }
    }

    private void checkBitwiseOperations(StateflowChart chart, List<IToken> codeTokens, QualifiedNameLocation location, StateflowVariableTypeExtractor types) {
        if (codeTokens.isEmpty()) {
            return;
        }
        String actionLanguage = chart.getParameter("actionLanguage");
        if (StringUtils.isEmpty((String)actionLanguage)) {
            EnumSet<ETokenType> bitwiseTokens = EnumSet.of(ETokenType.LSHIFT, ETokenType.GT);
            this.checkBitwiseOperationsInCLanguage(codeTokens, bitwiseTokens, chart, types, (ElementLocation)location);
        } else if ("1".equals(actionLanguage)) {
            EnumSet<ETokenType[]> bitwiseTokens = EnumSet.of(ETokenType.AND, new ETokenType[]{ETokenType.OR, ETokenType.XOR, ETokenType.COMP, ETokenType.LSHIFT, ETokenType.GT});
            this.checkBitwiseOperationsInCLanguage(codeTokens, bitwiseTokens, chart, types, (ElementLocation)location);
        } else {
            this.checkBitwiseOperationsInMatlabLanguage(codeTokens, chart, types, location);
        }
    }

    private void checkBitwiseOperationsInCLanguage(List<IToken> tokens, EnumSet<ETokenType> bitwiseTokenTypes, StateflowChart chart, StateflowVariableTypeExtractor types, ElementLocation location) {
        List operatorIndices = TokenStreamUtils.findAll(tokens, (ITokenMatcher)ITokenMatcher.anyOfType(bitwiseTokenTypes));
        Function<String, String> dataTypeRetriever = variable -> types.determineType(variable, (StateflowDeclContainerBase)chart);
        Iterator iterator = operatorIndices.iterator();
        while (iterator.hasNext()) {
            int operatorIndex = (Integer)iterator.next();
            this.checkRightAndLeftSidesOfBitwiseOperator(tokens, dataTypeRetriever, location, operatorIndex);
        }
    }

    private void checkRightAndLeftSidesOfBitwiseOperator(List<IToken> tokens, Function<String, String> dataTypeRetriever, ElementLocation location, int operatorIndex) {
        String operandIdentifierType;
        IToken shiftOperatorOperandToken;
        int firstOperandTokenIndex = operatorIndex + 1;
        int secondOperandTokenIndex = operatorIndex + 2;
        boolean findingCreated = false;
        if (SimulinkStateflowUsageOfBitwiseOperationsCheck.isRightShiftOperator(tokens, operatorIndex, firstOperandTokenIndex) && (shiftOperatorOperandToken = tokens.get(secondOperandTokenIndex)).getType() == ETokenType.IDENTIFIER && (operandIdentifierType = dataTypeRetriever.apply(shiftOperatorOperandToken.getText())) != null && SIGNED_TYPES.contains(operandIdentifierType)) {
            String message = MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)RIGHT_SHIFT_OPERATOR));
            this.buildFinding(message, location).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            findingCreated = true;
        }
        if (!findingCreated && BITWISE_OPERATORS_EXCEPT_RIGHT_SHIFT.contains(tokens.get(operatorIndex).getType())) {
            String bitwiseOperator = tokens.get(operatorIndex).getText();
            findingCreated = secondOperandTokenIndex > tokens.size() - 1 ? this.createsFindingIfSignedIdentifierOperand(tokens, dataTypeRetriever, location, bitwiseOperator, firstOperandTokenIndex) : this.createsFindingIfSignedOperand(tokens, dataTypeRetriever, location, bitwiseOperator, firstOperandTokenIndex, secondOperandTokenIndex, firstOperandTokenIndex);
        }
        if (!findingCreated && tokens.get(operatorIndex).getType() != ETokenType.COMP) {
            this.checkLeftSideOfBitwiseOperatorAndCreateFinding(tokens, dataTypeRetriever, location, operatorIndex);
        }
    }

    private void checkLeftSideOfBitwiseOperatorAndCreateFinding(List<IToken> tokens, Function<String, String> dataTypeRetriever, ElementLocation location, int operatorIndex) {
        int firstOperandTokenIndex = operatorIndex - 2;
        int secondOperandTokenIndex = operatorIndex - 1;
        boolean findingCreated = false;
        if (SimulinkStateflowUsageOfBitwiseOperationsCheck.isRightShiftOperator(tokens, operatorIndex, operatorIndex + 1)) {
            findingCreated = this.createsFindingIfSignedOperand(tokens, dataTypeRetriever, location, RIGHT_SHIFT_OPERATOR, firstOperandTokenIndex, secondOperandTokenIndex, secondOperandTokenIndex);
        }
        if (!findingCreated && BITWISE_OPERATORS_EXCEPT_RIGHT_SHIFT.contains(tokens.get(operatorIndex).getType())) {
            String bitwiseOperator = tokens.get(operatorIndex).getText();
            if (firstOperandTokenIndex < 0) {
                this.createsFindingIfSignedIdentifierOperand(tokens, dataTypeRetriever, location, bitwiseOperator, secondOperandTokenIndex);
            } else {
                this.createsFindingIfSignedOperand(tokens, dataTypeRetriever, location, bitwiseOperator, firstOperandTokenIndex, secondOperandTokenIndex, secondOperandTokenIndex);
            }
        }
    }

    private static boolean isRightShiftOperator(List<IToken> tokens, int operatorIndex, int nextTokenAfterOperatorIndex) {
        return tokens.get(operatorIndex).getType() == ETokenType.GT && nextTokenAfterOperatorIndex < tokens.size() && tokens.get(nextTokenAfterOperatorIndex).getType() == ETokenType.GT;
    }

    private boolean createsFindingIfSignedOperand(List<IToken> tokens, Function<String, String> dataTypeRetriever, ElementLocation location, String bitwiseOperator, int firstOperandTokenIndex, int secondOperandTokenIndex, int indexOfIdentifierOrNumericLiteral) {
        ETokenType firstOperandTokenType = tokens.get(firstOperandTokenIndex).getType();
        ETokenType secondOperandTokenType = tokens.get(secondOperandTokenIndex).getType();
        if (firstOperandTokenType == ETokenType.MINUS && Set.of(ETokenType.IDENTIFIER, ETokenType.INTEGER_LITERAL, ETokenType.FLOATING_POINT_LITERAL).contains(secondOperandTokenType)) {
            String message = MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)bitwiseOperator));
            this.buildFinding(message, location).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            return true;
        }
        return this.createsFindingIfSignedIdentifierOperand(tokens, dataTypeRetriever, location, bitwiseOperator, indexOfIdentifierOrNumericLiteral);
    }

    private boolean createsFindingIfSignedIdentifierOperand(List<IToken> tokens, Function<String, String> dataTypeRetriever, ElementLocation location, String bitwiseOperator, int operandIndex) {
        String operandIdentifierType;
        if (operandIndex < 0 || operandIndex > tokens.size() - 1) {
            return false;
        }
        IToken operandToken = tokens.get(operandIndex);
        ETokenType operandTokenType = operandToken.getType();
        if (operandTokenType == ETokenType.IDENTIFIER && (operandIdentifierType = dataTypeRetriever.apply(operandToken.getText())) != null && SIGNED_TYPES.contains(operandIdentifierType)) {
            String message = MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)bitwiseOperator));
            this.buildFinding(message, location).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
            return true;
        }
        return false;
    }

    private void checkBitwiseOperationsInMatlabLanguage(List<IToken> tokens, StateflowChart chart, StateflowVariableTypeExtractor types, QualifiedNameLocation location) {
        Optional optionalMatlabActionAstRootNode = SimulinkCheckUtils.parseMatlabTokens(tokens, (QualifiedNameLocation)location);
        if (optionalMatlabActionAstRootNode.isEmpty()) {
            return;
        }
        List matlabActionAstFunctionNodes = MatlabActionAstUtils.listNodesOfEntityTypeRecursively((MatlabActionAstNode)((MatlabActionAstNode)optionalMatlabActionAstRootNode.get()), (EMatlabActionEntityType[])new EMatlabActionEntityType[]{EMatlabActionEntityType.FUNCTION});
        for (MatlabActionAstNode functionNode : matlabActionAstFunctionNodes) {
            this.checkBitwiseFunctionCallExpression(functionNode, chart, types, (ElementLocation)location);
        }
    }

    private void checkBitwiseFunctionCallExpression(MatlabActionAstNode matlabFunctionNode, StateflowChart chart, StateflowVariableTypeExtractor types, ElementLocation location) {
        List functionCallTokens = matlabFunctionNode.getTokens();
        if (functionCallTokens.size() < 4) {
            return;
        }
        String bitwiseFunctionName = ((IToken)functionCallTokens.get(0)).getText();
        if (!MATLAB_BITWISE_FUNCTIONS.contains(bitwiseFunctionName)) {
            return;
        }
        String operandIdentifierType = types.determineType(((IToken)functionCallTokens.get(2)).getText(), (StateflowDeclContainerBase)chart);
        if (operandIdentifierType != null && SIGNED_TYPES.contains(operandIdentifierType)) {
            String message = MessageFormat.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)bitwiseFunctionName));
            this.buildFinding(message, location).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

