/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import eu.cqse.check.wia.parsable.rule.TypedSetRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.SimpleNLPUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-wia-avoid-comparative-superlative", languages={ELanguage.NL_REQUIREMENTS, ELanguage.NL_TESTS})
public class AvoidComparativeSuperlativeCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "Avoid Comparative and Superlative";
    @CheckOption(name="Avoid Comparative and Superlative - Text ignore patterns (regex)", description="A list of comma separated Java regex patterns for text parts that are ignored and\nnot included in the detection of this check.\nFor example, the regex `\".*?\"` ignores text that is enclosed in double quotes.\n")
    private List<String> ignorePatterns = List.of("\".*?\"", "(?<=\\W|^)'.*?'");
    @CheckOption(name="Avoid Comparative and Superlative - Rules", description="The list of rules that specify for which *item types* and which *item fields* this check is executed.\nMultiple rules are separated by new-lines.\n<p>\nA rule has the format:\n\n`<itemTypes> -> <fieldNames>`\n\n`<itemTypes>`: a `|` separated list of item types.<br>\nThis check is executed for all listed types.\nA type must be specified as full name (e.g., `Requirement`)\tor its abbreviation (e.g., `REQ`).\nThe special placeholder `ANY` can be used in place of a concrete type list to execute this check irrespective of the item types.\n\n`<fieldNames>`: a `|` separated list of item fields.<br>\nThis check is executed on all listed fields that are present in any of the item types of the same rule.\nThe special placeholder `ALL` can be used in place of a concrete field list to execute this check on all fields.\n\nHere are some example rules:\n+ `Requirement -> Description`<br>\n  The check is executed on the `Description` field of `Requirement` items.\n+ `REQ | WI -> Description | Status`<br>\n  The check is executed on the `Description` and `Status` fields of `REQ` and `WI` items.\n+ `ANY -> Description`<br>\n  The check is executed on the `Description` field of all items irrespective of their types.\n+ `REQ -> ALL`<br>\n  The check is executed on all fields of `REQ` items.\n+ `ANY -> ALL`<br>\n  The check is executed on all fields all items irrespective of their types.\n", multilineText=true)
    private Set<String> rawAvoidSuperlativeComparativeRules = Collections.emptySet();
    @CheckOption(name="Avoid Comparative and Superlative - Allowed Phrases", description="Comma separated list of comparative or superlative words that are ignored and not included in the superlatives and comparatives detection. Adjectives that are used along with 'more' and 'most' can also added (e.g. `dangerous`, `effective`, etc.) to the list.")
    private Set<String> allowedComparativeOrSuperlatives = Collections.emptySet();
    private final Set<TypedSetRule<String>> parsedAvoidComparativeAndSuperlativeRules = new HashSet<TypedSetRule<String>>();
    private Pattern compiledIgnorePattern;
    private Pattern compiledSuperlativePattern;
    private Pattern compiledComparativePattern;
    private static final TypedSetRule.Parser<String> PARSER = new TypedSetRule.Parser<String>().withValueParser(ParsableRule.RuleParser.TO_STRING);

    public AvoidComparativeSuperlativeCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        StringJoiner combinedIgnorePattern = new StringJoiner(")|(", "(", ")");
        this.ignorePatterns.forEach(combinedIgnorePattern::add);
        this.compiledIgnorePattern = Pattern.compile(combinedIgnorePattern.toString());
        this.allowedComparativeOrSuperlatives = this.allowedComparativeOrSuperlatives.stream().map(String::toLowerCase).collect(Collectors.toSet());
        this.createSuperlativeComparativePattern();
        for (String rawRule : this.rawAvoidSuperlativeComparativeRules) {
            this.parsedAvoidComparativeAndSuperlativeRules.add((TypedSetRule<String>)PARSER.parse(rawRule));
        }
    }

    private void createSuperlativeComparativePattern() {
        String irregularSuperlatives = "(" + String.join((CharSequence)"|", SimpleNLPUtils.IRREGULAR_SUPERLATIVES) + ")";
        String irregularComparatives = "(" + String.join((CharSequence)"|", SimpleNLPUtils.IRREGULAR_COMPARATIVES) + ")";
        String shortComparativeAdjectiveRegex = "\\b\\w+er\\s+than\\b";
        String longComparativeWithMoreOrLess = "\\b(more|less)(-|\\s)\\b\\w*?([aeiouy]+[^aeiouy\\s]+){2,}\\w*?\\b\\b";
        String shortSuperlativeAdjectiveRegex = "\\bthe\\s+\\w+est\\b";
        String longSuperlativeWithMostOrLeast = "\\b(most|least)(-|\\s)\\b\\w*?([aeiouy]+[^aeiouy\\s]+){2,}\\w*?\\b\\b";
        String comparativeRegex = shortComparativeAdjectiveRegex + "|" + longComparativeWithMoreOrLess + "|\\b" + irregularComparatives + "\\b";
        String superlativeRegex = shortSuperlativeAdjectiveRegex + "|" + longSuperlativeWithMostOrLeast + "|\\b" + irregularSuperlatives + "\\b";
        this.compiledComparativePattern = Pattern.compile(comparativeRegex, 34);
        this.compiledSuperlativePattern = Pattern.compile(superlativeRegex, 34);
    }

    @Override
    protected void execute(SpecItem workItem) throws CheckException {
        for (TypedSetRule<String> rule : this.parsedAvoidComparativeAndSuperlativeRules) {
            if (!rule.matches(workItem)) continue;
            if (rule.values.contains("ALL")) {
                for (String field : this.getDescriber((TeamscaleIssue)workItem).getNonTechnicalKeys((TeamscaleIssue)workItem)) {
                    this.checkViolation(workItem, field);
                }
                continue;
            }
            for (String field : rule.values) {
                this.checkViolation(workItem, field);
            }
        }
    }

    private void checkViolation(SpecItem item, String field) {
        WorkItemDescriberBase.IValueDescriber valueDescriber = this.getDescriber((TeamscaleIssue)item).getValueDescriber(field);
        String fieldValue = valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.WITH_HTML_TAGS_REMOVED);
        if (StringUtils.isEmpty((String)fieldValue)) {
            return;
        }
        String fieldValueWithoutIgnoredSubstrings = SimpleNLPUtils.removeIgnoredSubstrings((Pattern)this.compiledIgnorePattern, (String)fieldValue);
        Matcher comparativeMatcher = this.compiledComparativePattern.matcher(fieldValueWithoutIgnoredSubstrings);
        this.checkAndReportFinding((WorkItemDescriberBase.IValueDescriber<SpecItem>)valueDescriber, item, field, "comparative", comparativeMatcher);
        Matcher superlativeMatcher = this.compiledSuperlativePattern.matcher(fieldValueWithoutIgnoredSubstrings);
        this.checkAndReportFinding((WorkItemDescriberBase.IValueDescriber<SpecItem>)valueDescriber, item, field, "superlative", superlativeMatcher);
    }

    private void checkAndReportFinding(WorkItemDescriberBase.IValueDescriber<SpecItem> valueDescriber, SpecItem item, String field, String comparisonType, Matcher matcher) {
        while (matcher.find()) {
            String matchedText = matcher.group().toLowerCase().trim();
            if (this.allowedComparativeOrSuperlatives.stream().anyMatch(matchedText::contains)) continue;
            this.buildFinding(AvoidComparativeSuperlativeCheck.buildFindingMessage(comparisonType, matcher.group()), this.buildLocation().forAttribute(valueDescriber.getExactKeyName((TeamscaleIssue)item), valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.RAW))).addFindingProperties(AvoidComparativeSuperlativeCheck.buildProperties(item, field, matcher.group())).createAndStore();
        }
    }

    private static @NonNull FindingPropertyList buildProperties(SpecItem specItem, String violatedField, String expression) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Item Type", (Object)specItem.getHumanReadableType());
        properties.addProperty("Item Field", (Object)violatedField);
        properties.addProperty("Expression", (Object)expression);
        return properties;
    }

    public static String buildFindingMessage(String comparisonType, String expression) {
        return "Prefer exact quantification over %ss: '%s'".formatted(comparisonType, MarkupUtils.escapeMarkdownRelevantSymbols((String)expression));
    }
}

