/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.util;

import com.splunk.logging.HttpEventCollectorErrorHandler;
import com.splunk.logging.HttpEventCollectorEventInfo;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class StandardErrorCallback
implements HttpEventCollectorErrorHandler.ErrorCallback {
    public static final Locale DEFAULT_LOCALE = Locale.US;
    private static final AtomicInteger eventCount = new AtomicInteger(0);
    private static final AtomicInteger errorCount = new AtomicInteger(0);
    private static final DateTimeFormatter HUMAN_READABLE_WITH_MILLIS = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss.SSS").toFormatter(DEFAULT_LOCALE);
    private final boolean enablePrintStackTrace;

    public StandardErrorCallback() {
        this(StandardErrorCallback.checkEnablePrintStackTrace());
    }

    private static boolean checkEnablePrintStackTrace() {
        return "true".equalsIgnoreCase(System.getProperty("com.splunk.logging.util.StandardErrorCallback.enablePrintStackTrace", "false"));
    }

    public StandardErrorCallback(boolean enablePrintStackTrace) {
        this.enablePrintStackTrace = enablePrintStackTrace;
    }

    @Override
    public void error(List<HttpEventCollectorEventInfo> data, Exception ex) {
        int totalErrorCount = errorCount.incrementAndGet();
        int totalEventCount = eventCount.addAndGet(data == null ? 0 : data.size());
        String threadName = Thread.currentThread().getName();
        String fullMessage = this.createErrorMessage(data, ex, totalErrorCount, totalEventCount, threadName);
        this.printError(fullMessage);
        this.printStackTrace(ex);
    }

    private String createErrorMessage(List<HttpEventCollectorEventInfo> data, Exception ex, int totalErrorCount, int totalEventCount, String threadName) {
        String timestamp = HUMAN_READABLE_WITH_MILLIS.format(LocalDateTime.now());
        String exceptionMessage = ex == null ? "unknown (exception null)" : ex.getClass().getSimpleName() + ": " + ex.getMessage();
        String batchOrSingleText = this.createBatchOrSingleText(data);
        String fullMessage = timestamp + " [" + threadName + "] HttpEventCollectorError exception for " + batchOrSingleText + ". Total errors/events: " + totalErrorCount + "/" + totalEventCount + ". Message: " + exceptionMessage;
        return fullMessage;
    }

    private String createBatchOrSingleText(List<HttpEventCollectorEventInfo> data) {
        int size;
        String batchOrSingleText = data == null ? "unknown events (data is null)" : ((size = data.size()) == 1 ? "log event" : "batch of " + size + " log events");
        return batchOrSingleText;
    }

    private void printStackTrace(Exception ex) {
        if (this.enablePrintStackTrace && ex != null) {
            ex.printStackTrace();
        }
    }

    private void printError(String fullMessage) {
        System.err.println(fullMessage);
    }

    public int getEventCount() {
        return eventCount.get();
    }

    public int getErrorCount() {
        return errorCount.get();
    }

    public void resetCounters() {
        errorCount.set(0);
        eventCount.set(0);
    }

    public boolean isPrintStackTraceEnabled() {
        return this.enablePrintStackTrace;
    }
}

