/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.util;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

class UnsafeAccess {
    static final ByteOrder NATIVE_ORDER;
    static final Unsafe UNSAFE;
    static final long BYTE_ARRAY_OFFSET;
    private static final boolean IS_ARM;

    UnsafeAccess() {
    }

    public static void requireUnsafe() {
        if (!UnsafeAccess.isAvailable()) {
            throw new AssertionError((Object)"Unsafe is not available on this platform");
        }
    }

    public static boolean isAvailable() {
        return UNSAFE != null;
    }

    public static boolean allowUnalignedAccess() {
        return !IS_ARM;
    }

    static {
        Unsafe unsafe = null;
        long baseOffset = 0L;
        try {
            PrivilegedExceptionAction<Unsafe> action = new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Field f = Unsafe.class.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return (Unsafe)f.get(null);
                }
            };
            unsafe = AccessController.doPrivileged(action);
            baseOffset = unsafe.arrayBaseOffset(byte[].class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        UNSAFE = unsafe;
        BYTE_ARRAY_OFFSET = baseOffset;
        NATIVE_ORDER = ByteOrder.nativeOrder();
        IS_ARM = Boolean.getBoolean("jvm.isarm") || System.getProperty("os.arch", "N/A").startsWith("arm") || System.getProperty("os.arch", "N/A").startsWith("aarch");
    }
}

