/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.MainSafeCoroutinesCheckKt;

@Rule(key="S6307")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/sonarsource/kotlin/checks/MainSafeCoroutinesCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "reportBlockingFunctionCalls", "Lorg/jetbrains/kotlin/psi/KtElement;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nMainSafeCoroutinesCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainSafeCoroutinesCheck.kt\norg/sonarsource/kotlin/checks/MainSafeCoroutinesCheck\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,141:1\n221#2,9:142\n240#2:151\n221#2,9:152\n240#2:161\n222#2:162\n*S KotlinDebug\n*F\n+ 1 MainSafeCoroutinesCheck.kt\norg/sonarsource/kotlin/checks/MainSafeCoroutinesCheck\n*L\n82#1:142,9\n82#1:151\n90#1:152,9\n90#1:161\n90#1:162\n*E\n"})
public final class MainSafeCoroutinesCheck
extends AbstractCheck {
    /*
     * WARNING - void declaration
     */
    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(context, "context");
        BindingContext bindingContext2 = context.getBindingContext();
        PsiElement suspendModifier2 = ApiExtensionsKt.suspendModifier(function2);
        if (suspendModifier2 != null) {
            this.reportBlockingFunctionCalls(function2, context);
        } else {
            void $this$forEachDescendantOfType$iv;
            PsiElement psiElement = function2;
            Function1 action$iv = new Function1<KtLambdaArgument, Unit>(bindingContext2, this, context){
                final /* synthetic */ BindingContext $bindingContext;
                final /* synthetic */ MainSafeCoroutinesCheck this$0;
                final /* synthetic */ KotlinFileContext $context;
                {
                    this.$bindingContext = $bindingContext;
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull KtLambdaArgument it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    if (ApiExtensionsKt.isSuspending(it, this.$bindingContext)) {
                        MainSafeCoroutinesCheck.access$reportBlockingFunctionCalls(this.this$0, it, this.$context);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
            boolean $i$f$forEachDescendantOfType2 = false;
            PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
            $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $action;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkNotNullParameter(element, "element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtLambdaArgument) {
                        this.$action.invoke(element);
                    }
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportBlockingFunctionCalls(KtElement $this$reportBlockingFunctionCalls, KotlinFileContext context) {
        void $this$forEachDescendantOfType$iv;
        BindingContext bindingContext2 = context.getBindingContext();
        PsiElement psiElement = $this$reportBlockingFunctionCalls;
        Function1 action$iv = new Function1<KtCallExpression, Unit>(bindingContext2, this, context){
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ MainSafeCoroutinesCheck this$0;
            final /* synthetic */ KotlinFileContext $context;
            {
                this.$bindingContext = $bindingContext;
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final void invoke(@NotNull KtCallExpression call2) {
                block2: {
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                    block1: {
                        Intrinsics.checkNotNullParameter(call2, "call");
                        resolvedCall2 = CallUtilKt.getResolvedCall(call2, this.$bindingContext);
                        if (!FunMatcherKt.matches(resolvedCall2, MainSafeCoroutinesCheckKt.getTHREAD_SLEEP_MATCHER())) break block1;
                        AbstractCheck abstractCheck = this.this$0;
                        KtExpression ktExpression = call2.getCalleeExpression();
                        Intrinsics.checkNotNull(ktExpression);
                        AbstractCheck.reportIssue$default(abstractCheck, this.$context, (PsiElement)ktExpression, "Replace this \"Thread.sleep()\" call with \"delay()\".", null, null, 12, null);
                        break block2;
                    }
                    ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
                    if (resolvedCall3 == null || (resolvedCall3 = resolvedCall3.getResultingDescriptor()) == null) break block2;
                    ResolvedCall<? extends CallableDescriptor> resolvedCall4 = resolvedCall3;
                    BindingContext bindingContext2 = this.$bindingContext;
                    MainSafeCoroutinesCheck mainSafeCoroutinesCheck = this.this$0;
                    KotlinFileContext kotlinFileContext = this.$context;
                    ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall4;
                    boolean bl = false;
                    if (MainSafeCoroutinesCheckKt.access$isInsideNonSafeDispatcher(call2, bindingContext2) && ApiExtensionsKt.throwsExceptions((CallableDescriptor)((Object)descriptor2), (Collection<String>)MainSafeCoroutinesCheckKt.getBLOCKING_ANNOTATIONS())) {
                        AbstractCheck abstractCheck = mainSafeCoroutinesCheck;
                        KtExpression ktExpression = call2.getCalleeExpression();
                        Intrinsics.checkNotNull(ktExpression);
                        AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Use \"Dispatchers.IO\" to run this potentially blocking operation.", null, null, 12, null);
                    }
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        void $this$forEachDescendantOfType$iv$iv = $this$forEachDescendantOfType$iv;
        boolean $i$f$forEachDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv);
        $this$forEachDescendantOfType$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtCallExpression) {
                    this.$action.invoke(element);
                }
            }
        });
    }

    public static final /* synthetic */ void access$reportBlockingFunctionCalls(MainSafeCoroutinesCheck $this, KtElement $receiver, KotlinFileContext context) {
        $this.reportBlockingFunctionCalls($receiver, context);
    }
}

