/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.jsbuild.export;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.jsbuild.export.ETypescriptType;
import com.teamscale.jsbuild.export.TypescriptType;
import com.teamscale.jsbuild.export.TypescriptTypeExporterBase;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Member;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

public class FixedJsTypeExporter
extends TypescriptTypeExporterBase {
    private static final Map<Class<?>, String> MATCHED_JS_TYPES = new HashMap();

    @Override
    public Optional<TypescriptType> resolveJavaScriptType(Class<?> clazz, AnnotatedType annotatedType, Member member) {
        String knownExportType = FixedJsTypeExporter.getFixedTypeForField(clazz);
        if (knownExportType != null) {
            return Optional.of(new TypescriptType(knownExportType, FixedJsTypeExporter.isNullable(annotatedType)));
        }
        return Optional.empty();
    }

    public static @Nullable String getFixedTypeForField(Class<?> type) {
        return MATCHED_JS_TYPES.get(type);
    }

    static {
        MATCHED_JS_TYPES.put(Color.class, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(Pattern.class, "{regex : {flags: number, pattern: string}}");
        MATCHED_JS_TYPES.put(Point.class, "{x: number, y: number}");
        MATCHED_JS_TYPES.put(Rectangle.class, "{x: number, y: number, width: number, height: number}");
        MATCHED_JS_TYPES.put(IProjectId.class, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(InternalProjectId.class, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(PublicProjectId.class, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(ETeamscaleVersion.class, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(Enum.class, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(Character.TYPE, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(Date.class, ETypescriptType.NUMBER.getTypeName());
        MATCHED_JS_TYPES.put(UniformPath.class, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(UUID.class, ETypescriptType.STRING.getTypeName());
        MATCHED_JS_TYPES.put(JsonNode.class, ETypescriptType.UNKOWN.getTypeName());
        MATCHED_JS_TYPES.put(UnresolvedCommitDescriptor.class, ETypescriptType.UNKOWN.getTypeName());
        MATCHED_JS_TYPES.put(Object.class, ETypescriptType.UNKOWN.getTypeName());
    }
}

