/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.visualstudio.services.gallery.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.microsoft.alm.client.HttpMethod;
import com.microsoft.alm.client.VssHttpClientBase;
import com.microsoft.alm.client.VssRestClientHandler;
import com.microsoft.alm.client.VssRestRequest;
import com.microsoft.alm.client.model.NameValueCollection;
import com.microsoft.alm.visualstudio.services.gallery.webapi.AzurePublisher;
import com.microsoft.alm.visualstudio.services.gallery.webapi.AzureRestApiRequestModel;
import com.microsoft.alm.visualstudio.services.gallery.webapi.CategoriesResult;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ExtensionCategory;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ExtensionPackage;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ExtensionQuery;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ExtensionQueryFlags;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ExtensionQueryResult;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ExtensionStatisticUpdate;
import com.microsoft.alm.visualstudio.services.gallery.webapi.PublishedExtension;
import com.microsoft.alm.visualstudio.services.gallery.webapi.PublishedExtensionFlags;
import com.microsoft.alm.visualstudio.services.gallery.webapi.Publisher;
import com.microsoft.alm.visualstudio.services.gallery.webapi.PublisherQuery;
import com.microsoft.alm.visualstudio.services.gallery.webapi.PublisherQueryResult;
import com.microsoft.alm.visualstudio.services.gallery.webapi.Review;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ReviewFilterOptions;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ReviewPatch;
import com.microsoft.alm.visualstudio.services.gallery.webapi.ReviewsResult;
import com.microsoft.alm.visualstudio.services.gallery.webapi.acquisitionoption.AcquisitionOptions;
import com.microsoft.alm.visualstudio.services.gallery.webapi.acquisitionrequest.ExtensionAcquisitionRequest;
import com.microsoft.alm.visualstudio.services.webapi.ApiResourceVersion;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public abstract class GalleryHttpClientBase
extends VssHttpClientBase {
    private static final Map<String, Class<? extends Exception>> TRANSLATED_EXCEPTIONS = new HashMap<String, Class<? extends Exception>>();

    protected GalleryHttpClientBase(VssRestClientHandler clientHandler, URI baseUrl) {
        super(clientHandler, baseUrl);
    }

    @Override
    protected Map<String, Class<? extends Exception>> getTranslatedExceptions() {
        return TRANSLATED_EXCEPTIONS;
    }

    public void shareExtensionById(UUID extensionId, String accountName) {
        UUID locationId = UUID.fromString("1f19631b-a0b4-4a03-89c2-d79785d24360");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("extensionId", extensionId);
        routeValues.put("accountName", accountName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void unshareExtensionById(UUID extensionId, String accountName) {
        UUID locationId = UUID.fromString("1f19631b-a0b4-4a03-89c2-d79785d24360");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("extensionId", extensionId);
        routeValues.put("accountName", accountName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void shareExtension(String publisherName, String extensionName, String accountName) {
        UUID locationId = UUID.fromString("a1e66d8f-f5de-4d16-8309-91a4e015ee46");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("accountName", accountName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public void unshareExtension(String publisherName, String extensionName, String accountName) {
        UUID locationId = UUID.fromString("a1e66d8f-f5de-4d16-8309-91a4e015ee46");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("accountName", accountName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public AcquisitionOptions getAcquisitionOptions(String itemId, String installationTarget, Boolean testCommerce, Boolean isFreeOrTrialInstall) {
        UUID locationId = UUID.fromString("9d0a0105-075e-4760-aa15-8bcf54d1bd7d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("itemId", itemId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("installationTarget", installationTarget);
        queryParameters.addIfNotNull("testCommerce", testCommerce);
        queryParameters.addIfNotNull("isFreeOrTrialInstall", isFreeOrTrialInstall);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, AcquisitionOptions.class);
    }

    public ExtensionAcquisitionRequest requestAcquisition(ExtensionAcquisitionRequest acquisitionRequest) {
        UUID locationId = UUID.fromString("3adb1f2d-e328-446e-be73-9f6d98071c45");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, acquisitionRequest, "application/json", "application/json");
        return super.sendRequest(httpRequest, ExtensionAcquisitionRequest.class);
    }

    public InputStream getAssetByName(String publisherName, String extensionName, String version, String assetType, String accountToken, Boolean acceptDefault) {
        UUID locationId = UUID.fromString("7529171f-a002-4180-93ba-685f358a0482");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("version", version);
        routeValues.put("assetType", assetType);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("accountToken", accountToken);
        queryParameters.addIfNotNull("acceptDefault", acceptDefault);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getAsset(UUID extensionId, String version, String assetType, String accountToken, Boolean acceptDefault) {
        UUID locationId = UUID.fromString("5d545f3d-ef47-488b-8be3-f5ee1517856c");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("extensionId", extensionId);
        routeValues.put("version", version);
        routeValues.put("assetType", assetType);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("accountToken", accountToken);
        queryParameters.addIfNotNull("acceptDefault", acceptDefault);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getAssetAuthenticated(String publisherName, String extensionName, String version, String assetType, String accountToken) {
        UUID locationId = UUID.fromString("506aff36-2622-4f70-8063-77cce6366d20");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("version", version);
        routeValues.put("assetType", assetType);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("accountToken", accountToken);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public AzurePublisher associateAzurePublisher(String publisherName, String azurePublisherId) {
        UUID locationId = UUID.fromString("efd202a6-9d87-4ebc-9229-d2b8ae2fdb6d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("azurePublisherId", azurePublisherId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, AzurePublisher.class);
    }

    public AzurePublisher queryAssociatedAzurePublisher(String publisherName) {
        UUID locationId = UUID.fromString("efd202a6-9d87-4ebc-9229-d2b8ae2fdb6d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, AzurePublisher.class);
    }

    public ArrayList<String> getCategories(String languages) {
        UUID locationId = UUID.fromString("e0a5a71e-3ac3-43a0-ae7d-0bb5c3046a2a");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("languages", languages);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, new TypeReference<ArrayList<String>>(){});
    }

    public CategoriesResult getCategoryDetails(String categoryName, String languages, String product) {
        UUID locationId = UUID.fromString("75d3c04d-84d2-4973-acd2-22627587dabc");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("categoryName", categoryName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("languages", languages);
        queryParameters.addIfNotEmpty("product", product);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, CategoriesResult.class);
    }

    public InputStream getCertificate(String publisherName, String extensionName, String version) {
        UUID locationId = UUID.fromString("e905ad6a-3f1f-4d08-9f6d-7d357ff8b7d0");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("version", version);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public ExtensionQueryResult queryExtensions(ExtensionQuery extensionQuery, String accountToken) {
        UUID locationId = UUID.fromString("eb9d5ee1-6d43-456b-b80e-8a96fbc014b6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("accountToken", accountToken);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, extensionQuery, "application/json", queryParameters, "application/json");
        return super.sendRequest(httpRequest, ExtensionQueryResult.class);
    }

    public PublishedExtension createExtension(ExtensionPackage extensionPackage) {
        UUID locationId = UUID.fromString("a41192c8-9525-4b58-bc86-179fa549d80d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, extensionPackage, "application/json", "application/json");
        return super.sendRequest(httpRequest, PublishedExtension.class);
    }

    public void deleteExtensionById(UUID extensionId, String version) {
        UUID locationId = UUID.fromString("a41192c8-9525-4b58-bc86-179fa549d80d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("extensionId", extensionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("version", version);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public PublishedExtension getExtensionById(UUID extensionId, String version, ExtensionQueryFlags flags) {
        UUID locationId = UUID.fromString("a41192c8-9525-4b58-bc86-179fa549d80d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("extensionId", extensionId);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("version", version);
        queryParameters.addIfNotNull("flags", flags);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, PublishedExtension.class);
    }

    public PublishedExtension updateExtensionById(ExtensionPackage extensionPackage, UUID extensionId) {
        UUID locationId = UUID.fromString("a41192c8-9525-4b58-bc86-179fa549d80d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("extensionId", extensionId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, extensionPackage, "application/json", "application/json");
        return super.sendRequest(httpRequest, PublishedExtension.class);
    }

    public PublishedExtension createExtensionWithPublisher(ExtensionPackage extensionPackage, String publisherName) {
        UUID locationId = UUID.fromString("e11ea35a-16fe-4b80-ab11-c4cab88a0966");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, extensionPackage, "application/json", "application/json");
        return super.sendRequest(httpRequest, PublishedExtension.class);
    }

    public void deleteExtension(String publisherName, String extensionName, String version) {
        UUID locationId = UUID.fromString("e11ea35a-16fe-4b80-ab11-c4cab88a0966");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("version", version);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public PublishedExtension getExtension(String publisherName, String extensionName, String version, ExtensionQueryFlags flags, String accountToken) {
        UUID locationId = UUID.fromString("e11ea35a-16fe-4b80-ab11-c4cab88a0966");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("version", version);
        queryParameters.addIfNotNull("flags", flags);
        queryParameters.addIfNotEmpty("accountToken", accountToken);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, PublishedExtension.class);
    }

    public PublishedExtension updateExtension(ExtensionPackage extensionPackage, String publisherName, String extensionName) {
        UUID locationId = UUID.fromString("e11ea35a-16fe-4b80-ab11-c4cab88a0966");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, extensionPackage, "application/json", "application/json");
        return super.sendRequest(httpRequest, PublishedExtension.class);
    }

    public PublishedExtension updateExtensionProperties(String publisherName, String extensionName, PublishedExtensionFlags flags) {
        UUID locationId = UUID.fromString("e11ea35a-16fe-4b80-ab11-c4cab88a0966");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("flags", flags);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, PublishedExtension.class);
    }

    public void extensionValidator(AzureRestApiRequestModel azureRestApiRequestModel) {
        UUID locationId = UUID.fromString("05e8a5e1-8c59-4c2c-8856-0ff087d1a844");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, azureRestApiRequestModel, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }

    public InputStream getPackage(String publisherName, String extensionName, String version, String accountToken, Boolean acceptDefault) {
        UUID locationId = UUID.fromString("7cb576f8-1cae-4c4b-b7b1-e4af5759e965");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("version", version);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("accountToken", accountToken);
        queryParameters.addIfNotNull("acceptDefault", acceptDefault);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public InputStream getAssetWithToken(String publisherName, String extensionName, String version, String assetType, String assetToken, String accountToken, Boolean acceptDefault) {
        UUID locationId = UUID.fromString("364415a1-0077-4a41-a7a0-06edd4497492");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        routeValues.put("version", version);
        routeValues.put("assetType", assetType);
        routeValues.put("assetToken", assetToken);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotEmpty("accountToken", accountToken);
        queryParameters.addIfNotNull("acceptDefault", acceptDefault);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/octet-stream");
        return super.sendRequest(httpRequest, InputStream.class);
    }

    public PublisherQueryResult queryPublishers(PublisherQuery publisherQuery) {
        UUID locationId = UUID.fromString("2ad6ee0a-b53f-4034-9d1d-d009fda1212e");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, publisherQuery, "application/json", "application/json");
        return super.sendRequest(httpRequest, PublisherQueryResult.class);
    }

    public Publisher createPublisher(Publisher publisher) {
        UUID locationId = UUID.fromString("4ddec66a-e4f6-4f5d-999e-9e77710d7ff4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, publisher, "application/json", "application/json");
        return super.sendRequest(httpRequest, Publisher.class);
    }

    public void deletePublisher(String publisherName) {
        UUID locationId = UUID.fromString("4ddec66a-e4f6-4f5d-999e-9e77710d7ff4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public Publisher getPublisher(String publisherName, Integer flags) {
        UUID locationId = UUID.fromString("4ddec66a-e4f6-4f5d-999e-9e77710d7ff4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("flags", flags);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, Publisher.class);
    }

    public Publisher updatePublisher(Publisher publisher, String publisherName) {
        UUID locationId = UUID.fromString("4ddec66a-e4f6-4f5d-999e-9e77710d7ff4");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PUT, locationId, routeValues, apiVersion, publisher, "application/json", "application/json");
        return super.sendRequest(httpRequest, Publisher.class);
    }

    public ReviewsResult getReviews(String publisherName, String extensionName, Integer count, ReviewFilterOptions filterOptions, Date beforeDate, Date afterDate) {
        UUID locationId = UUID.fromString("5b3f819f-f247-42ad-8c00-dd9ab9ab246d");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("count", count);
        queryParameters.addIfNotNull("filterOptions", filterOptions);
        queryParameters.addIfNotNull("beforeDate", beforeDate);
        queryParameters.addIfNotNull("afterDate", afterDate);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, queryParameters, "application/json");
        return super.sendRequest(httpRequest, ReviewsResult.class);
    }

    public Review createReview(Review review, String pubName, String extName) {
        UUID locationId = UUID.fromString("e6e85b9d-aa70-40e6-aa28-d0fbf40b91a3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("pubName", pubName);
        routeValues.put("extName", extName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, review, "application/json", "application/json");
        return super.sendRequest(httpRequest, Review.class);
    }

    public void deleteReview(String pubName, String extName, long reviewId) {
        UUID locationId = UUID.fromString("e6e85b9d-aa70-40e6-aa28-d0fbf40b91a3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("pubName", pubName);
        routeValues.put("extName", extName);
        routeValues.put("reviewId", reviewId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.DELETE, locationId, routeValues, apiVersion, "application/json");
        super.sendRequest(httpRequest);
    }

    public ReviewPatch updateReview(ReviewPatch reviewPatch, String pubName, String extName, long reviewId) {
        UUID locationId = UUID.fromString("e6e85b9d-aa70-40e6-aa28-d0fbf40b91a3");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("pubName", pubName);
        routeValues.put("extName", extName);
        routeValues.put("reviewId", reviewId);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, reviewPatch, "application/json", "application/json");
        return super.sendRequest(httpRequest, ReviewPatch.class);
    }

    public ExtensionCategory createCategory(ExtensionCategory category) {
        UUID locationId = UUID.fromString("476531a3-7024-4516-a76a-ed64d3008ad6");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, apiVersion, category, "application/json", "application/json");
        return super.sendRequest(httpRequest, ExtensionCategory.class);
    }

    public void generateKey(String keyType, Integer expireCurrentSeconds) {
        UUID locationId = UUID.fromString("92ed5cf4-c38b-465a-9059-2f2fb7c624b5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("keyType", keyType);
        NameValueCollection queryParameters = new NameValueCollection();
        queryParameters.addIfNotNull("expireCurrentSeconds", expireCurrentSeconds);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.POST, locationId, routeValues, apiVersion, queryParameters, "application/json");
        super.sendRequest(httpRequest);
    }

    public String getSigningKey(String keyType) {
        UUID locationId = UUID.fromString("92ed5cf4-c38b-465a-9059-2f2fb7c624b5");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("keyType", keyType);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.GET, locationId, routeValues, apiVersion, "application/json");
        return super.sendRequest(httpRequest, String.class);
    }

    public void updateExtensionStatistics(ExtensionStatisticUpdate extensionStatisticsUpdate, String publisherName, String extensionName) {
        UUID locationId = UUID.fromString("a0ea3204-11e9-422d-a9ca-45851cc41400");
        ApiResourceVersion apiVersion = new ApiResourceVersion("3.0-preview.1");
        HashMap<String, Object> routeValues = new HashMap<String, Object>();
        routeValues.put("publisherName", publisherName);
        routeValues.put("extensionName", extensionName);
        VssRestRequest httpRequest = super.createRequest(HttpMethod.PATCH, locationId, routeValues, apiVersion, extensionStatisticsUpdate, "application/json", "application/json");
        super.sendRequest(httpRequest);
    }
}

