/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.build;

import com.microsoft.tfs.util.StringUtil;
import com.microsoft.tfs.util.URLEncode;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class GitProperties {
    public static final char PathSeparator = '/';
    public static final char WinPathSeparator = '\\';
    public static final String GIT = "git";
    public static final String RepositoryUrl = "RepositoryUrl";
    public static final String RepositoryName = "RepositoryName";
    public static final String DefaultBranch = "DefaultBranch";
    public static final String CIBranches = "CIBranches";
    public static final String LocalRepoPath = "LocalRepoPath";
    public static final String GitPathBeginning = "vstfs:///Git/VersionedItem/";
    public static final String BranchPrefix = "refs/heads/";
    private static final String BranchSeparator = ":";
    private static final String BranchInclusionOperator = "+";
    private static final String BranchExclusionOperator = "-";
    private static final String BranchPatternOperator = "*";

    public static String createUniqueRepoName(String teamProjectName, String repoName) {
        return teamProjectName + '/' + repoName;
    }

    public static String getRepoNameFromUniqueRepoName(String uniqRepoName) {
        if (StringUtil.isNullOrEmpty(uniqRepoName)) {
            return null;
        }
        String[] names = uniqRepoName.split("/");
        if (names.length == 1) {
            return uniqRepoName;
        }
        return names[names.length - 1];
    }

    public static void parseBranchSpec(String branchSpec, boolean excludeBranch, String branch, boolean isPattern, boolean removePattern) {
        excludeBranch = false;
        isPattern = false;
        branch = branchSpec;
        if (!StringUtil.isNullOrEmpty(branchSpec)) {
            if (branchSpec.startsWith(BranchExclusionOperator)) {
                excludeBranch = true;
                branch = branch.substring(1);
            } else if (branchSpec.startsWith(BranchInclusionOperator)) {
                excludeBranch = false;
                branch = branch.substring(1);
            }
            if (branchSpec.endsWith(BranchPatternOperator)) {
                isPattern = true;
                if (removePattern) {
                    branch = branch.substring(0, branch.length() - 1);
                }
            }
        }
    }

    public static String createBranchSpec(boolean excludeBranch, String branch) {
        StringBuilder sb = new StringBuilder();
        if (excludeBranch) {
            sb.append(BranchExclusionOperator);
        }
        sb.append(branch);
        return sb.toString();
    }

    public static String joinBranches(String[] branches) {
        if (branches != null && branches.length > 0) {
            return StringUtil.join(branches, BranchSeparator);
        }
        return null;
    }

    public static List<String> splitBranches(String branchString) {
        if (StringUtil.isNullOrEmpty(branchString)) {
            return null;
        }
        String[] branches = branchString.split(BranchSeparator);
        return Arrays.asList(branches);
    }

    public static String createGitRepositoryUrl(String collectionUrl, String teamProjectName, String repoName) {
        if (StringUtil.isNullOrEmpty(collectionUrl) || StringUtil.isNullOrEmpty(repoName)) {
            return null;
        }
        String cUrl = collectionUrl;
        if (!cUrl.endsWith("/")) {
            cUrl = collectionUrl + "/";
        }
        String projName = teamProjectName;
        if (StringUtil.isNullOrEmpty(teamProjectName)) {
            projName = repoName;
        }
        return collectionUrl + URLEncode.encode(projName) + "/_git/" + URLEncode.encode(repoName);
    }

    public static String gitUriToLocalRelativePath(String gitUri) {
        if (StringUtil.isNullOrEmpty(gitUri) || !gitUri.startsWith(GitPathBeginning)) {
            return null;
        }
        String text = gitUri.substring(GitPathBeginning.length());
        String[] parts = StringUtil.split("/", text);
        if (parts.length >= 4) {
            return text.substring(parts[0].length() + parts[1].length() + parts[2].length() + 3);
        }
        return "/";
    }

    public static String createGitItemUrl(String project, String repo, String branch, String relativePathInRepo) {
        if (StringUtil.isNullOrEmpty(project) && StringUtil.isNullOrEmpty(repo)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(GitPathBeginning);
        if (StringUtil.isNullOrEmpty(project)) {
            sb.append(repo);
        } else {
            sb.append(project);
        }
        sb.append('/');
        if (StringUtil.isNullOrEmpty(repo)) {
            sb.append(project);
        } else {
            sb.append(repo);
        }
        sb.append('/');
        if (StringUtil.isNullOrEmpty(branch)) {
            sb.append("master");
        } else {
            sb.append(branch);
        }
        if (!StringUtil.isNullOrEmpty(relativePathInRepo)) {
            String normalizedPath = GitProperties.normalizePathSeparator(relativePathInRepo);
            while (normalizedPath.length() > 0 && normalizedPath.charAt(0) == '/') {
                normalizedPath = normalizedPath.substring(1);
            }
            sb.append('/');
            sb.append(normalizedPath);
        }
        return sb.toString();
    }

    public static String getShortBranchName(String name) {
        if (StringUtil.isNullOrEmpty(name) || !name.startsWith(BranchPrefix)) {
            return name;
        }
        String shortName = name.substring(BranchPrefix.length());
        if (shortName.indexOf(47) != -1) {
            shortName = shortName.replace('/', '\u0000');
        }
        return shortName;
    }

    public static String normalizePathSeparator(String string) {
        return string.replace('\\', '/');
    }

    public static boolean parseGitItemUrl(String url, AtomicReference<String> projectName, AtomicReference<String> repositoryName, AtomicReference<String> branchName, AtomicReference<String> path) {
        if (StringUtil.isNullOrEmpty(url) || !url.startsWith(GitPathBeginning)) {
            return false;
        }
        String s = url.substring(GitPathBeginning.length());
        String[] parts = s.split(String.valueOf(new char[]{'/'}));
        if (parts.length < 3) {
            return false;
        }
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!StringUtil.isNullOrEmpty(parts[i])) continue;
            return false;
        }
        GitProperties.assignTo(parts[0], projectName);
        GitProperties.assignTo(parts[1], repositoryName);
        GitProperties.assignTo(parts[2], branchName);
        if (parts.length < 4) {
            GitProperties.assignTo("", path);
        } else {
            int pathOffset = parts[0].length() + 1 + parts[1].length() + 1 + parts[2].length() + 1;
            GitProperties.assignTo(s.substring(pathOffset), path);
        }
        return true;
    }

    private static void assignTo(String value, AtomicReference<String> target) {
        if (target != null) {
            target.set(value);
        }
    }
}

