/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.conflicts;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.WebServiceLevel;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictCategory;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescription;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.ConflictDescriptionStrings;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.ConflictResolutionOptions;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.CoreConflictResolution;
import com.microsoft.tfs.core.clients.versioncontrol.conflicts.resolutions.contributors.ConflictResolutionContributor;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Conflict;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Resolution;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Workspace;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;

public final class FilenameConflictDescription
extends ConflictDescription {
    protected FilenameConflictDescription(Workspace workspace, Conflict conflict, ItemSpec[] conflictItemSpecs) {
        super(workspace, conflict, conflictItemSpecs);
    }

    @Override
    public ConflictCategory getConflictCategory() {
        return ConflictCategory.FILENAME;
    }

    @Override
    public String getName() {
        return Messages.getString("FilenameConflictDescription.Name");
    }

    @Override
    public String getDescription() {
        return Messages.getString("FilenameConflictDescription.Description");
    }

    @Override
    public ConflictResolution[] getResolutions(ConflictResolutionContributor resolutionContributor) {
        Workspace workspace = this.getWorkspace();
        if (workspace == null || workspace.getClient().getServiceLevel().getValue() >= WebServiceLevel.TFS_2010.getValue()) {
            return new ConflictResolution[]{new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_ACCEPT_THEIRS, ConflictDescriptionStrings.VERSION_ACCEPT_THEIRS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_THEIRS), new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_ACCEPT_YOURS, ConflictDescriptionStrings.VERSION_ACCEPT_YOURS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_YOURS)};
        }
        return new ConflictResolution[]{new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_RENAME_LOCAL, ConflictDescriptionStrings.VERSION_RENAME_LOCAL_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_MERGE), new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_RENAME_SERVER, ConflictDescriptionStrings.VERSION_RENAME_SERVER_TOOLTIP, ConflictResolutionOptions.SELECT_NAME, Resolution.ACCEPT_YOURS_RENAME_THEIRS), new CoreConflictResolution(this, ConflictDescriptionStrings.VERSION_ACCEPT_THEIRS, ConflictDescriptionStrings.VERSION_ACCEPT_THEIRS_TOOLTIP, ConflictResolutionOptions.NONE, Resolution.ACCEPT_THEIRS)};
    }
}

