/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.fields;

import com.microsoft.tfs.core.clients.workitem.fields.Field;
import com.microsoft.tfs.core.clients.workitem.fields.FieldCollection;
import com.microsoft.tfs.core.clients.workitem.fields.FieldStatus;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.WorkItemImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldDefinitionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldImpl;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldModificationType;
import com.microsoft.tfs.core.clients.workitem.internal.fields.FieldReferenceBasedCache;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FieldCollectionImpl
implements FieldCollection {
    private static final Log log = LogFactory.getLog(FieldCollectionImpl.class);
    private final WorkItemImpl workItem;
    private final WITContext context;
    private final FieldReferenceBasedCache<Field> cache = new FieldReferenceBasedCache();

    public FieldCollectionImpl(WorkItemImpl workItem, WITContext context) {
        this.workItem = workItem;
        this.context = context;
    }

    @Override
    public Field getField(String name) {
        return this.getFieldInternal(name);
    }

    @Override
    public boolean contains(String name) {
        return this.cache.get(name) != null;
    }

    @Override
    public Iterator<Field> iterator() {
        return this.cache.values().iterator();
    }

    @Override
    public int size() {
        return this.cache.values().size();
    }

    @Override
    public int getAreaID() {
        return (Integer)this.getField("System.AreaId").getValue();
    }

    @Override
    public int getID() {
        return (Integer)this.getField("System.Id").getValue();
    }

    @Override
    public int getRevision() {
        return (Integer)this.getField("System.Rev").getValue();
    }

    @Override
    public String getWorkItemType() {
        return (String)this.getField("System.WorkItemType").getValue();
    }

    private IllegalArgumentException newIllegalFieldNameException(String illegalFieldName) {
        throw new IllegalArgumentException(MessageFormat.format("field [{0}] does not exist in this collection (wi={1},size={2})", illegalFieldName, Integer.toString(this.getID()), this.cache.size()));
    }

    private IllegalArgumentException newIllegalFieldIDException(int illegalFieldId) {
        throw new IllegalArgumentException(MessageFormat.format("field id [{0}] does not exist in this collection (wi={1},size={2})", Integer.toString(illegalFieldId), Integer.toString(this.getID()), this.cache.size()));
    }

    public void resetAfterUpdate() {
        for (Field field : this.cache.values()) {
            FieldImpl fieldImpl = (FieldImpl)field;
            fieldImpl.resetAfterUpdate();
        }
    }

    public void reset() {
        for (Field field : this.cache.values()) {
            FieldImpl fieldImpl = (FieldImpl)field;
            fieldImpl.reset();
        }
    }

    public void fireFieldChangeListeners() {
        for (Field field : this.cache.values()) {
            FieldImpl fieldImpl = (FieldImpl)field;
            fieldImpl.fireFieldChangeListeners();
        }
    }

    public void copy(FieldCollectionImpl targetCollection) {
        boolean newProject;
        int targetProjectId = targetCollection.getWorkItemInternal().getType().getProject().getID();
        int projectId = this.getWorkItemInternal().getType().getProject().getID();
        boolean bl = newProject = projectId != targetProjectId;
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("copying fields from {0} (project {1}) to {2} (project {3})", Integer.toString(this.workItem.getID()), Integer.toString(projectId), Integer.toString(targetCollection.getWorkItemInternal().getID()), Integer.toString(targetProjectId)));
        }
        for (Field field : this.cache.values()) {
            FieldImpl fieldImpl = (FieldImpl)field;
            if (fieldImpl.getFieldDefinitionInternal().canCopy()) {
                if ((field.getID() == -2 || field.getID() == -104) && newProject) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)MessageFormat.format("skipping copy of field {0}", Integer.toString(field.getID())));
                    continue;
                }
                Object value = field.getValue();
                targetCollection.getFieldInternal(field.getID()).setValue(value, FieldModificationType.NEW);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)MessageFormat.format("copied field {0}, value = [{1}]", Integer.toString(field.getID()), value));
                continue;
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)MessageFormat.format("skipping copy of field {0}", Integer.toString(field.getID())));
        }
    }

    public void ensureAllFieldsInWIPhysicalType() {
        FieldDefinitionImpl[] fieldDefinitions = this.context.getWorkItemFieldUsages().getFieldDefinitions();
        ArrayList<FieldDefinitionImpl> fieldDefsToEnsure = new ArrayList<FieldDefinitionImpl>();
        for (int i = 0; i < fieldDefinitions.length; ++i) {
            if (!fieldDefinitions[i].isUsedInPhysicalType()) continue;
            fieldDefsToEnsure.add(fieldDefinitions[i]);
        }
        this.ensureFieldsExist(fieldDefsToEnsure.toArray(new FieldDefinitionImpl[fieldDefsToEnsure.size()]));
    }

    private FieldImpl addField(FieldDefinitionImpl fieldDefinition) {
        if (this.cache.get(fieldDefinition.getID()) != null) {
            throw new IllegalStateException(MessageFormat.format("attempting to add field [{0}] but it already exists", Integer.toString(fieldDefinition.getID())));
        }
        FieldImpl field = new FieldImpl(fieldDefinition, this, this.workItem, this.context);
        this.cache.put(field, fieldDefinition.getName(), fieldDefinition.getReferenceName(), fieldDefinition.getID());
        return field;
    }

    public void ensureFieldsExist(FieldDefinitionImpl[] fieldDefinitions) {
        for (int i = 0; i < fieldDefinitions.length; ++i) {
            if (this.cache.get(fieldDefinitions[i].getID()) != null) continue;
            this.addField(fieldDefinitions[i]);
        }
    }

    public void addOriginalFieldValueFromServer(String name, String data, boolean create) {
        this.findFieldInternal(name, create).setOriginalValue(data);
    }

    public void addOriginalFieldValueFromServer(int fieldId, String data, boolean create) {
        this.findFieldInternal(fieldId, create).setOriginalValue(data);
    }

    public void addOriginalFieldValueLocal(int fieldId, Object data, boolean create) {
        this.findFieldInternal(fieldId, create).setOriginalValueLocal(data);
    }

    private FieldImpl findFieldInternal(String name, boolean create) {
        FieldImpl field = (FieldImpl)this.cache.get(name);
        if (field == null) {
            if (!create) {
                throw this.newIllegalFieldNameException(name);
            }
            FieldDefinitionImpl fieldDefinition = this.context.getWorkItemFieldUsages().getFieldDefinitionByName(name);
            if (fieldDefinition == null || !fieldDefinition.isUsedInPhysicalType()) {
                throw this.newIllegalFieldNameException(name);
            }
            field = this.addField(fieldDefinition);
        }
        return field;
    }

    private FieldImpl findFieldInternal(int fieldId, boolean create) {
        FieldImpl field = (FieldImpl)this.cache.get(fieldId);
        if (field == null) {
            if (!create) {
                throw this.newIllegalFieldIDException(fieldId);
            }
            FieldDefinitionImpl fieldDefinition = this.context.getWorkItemFieldUsages().getFieldDefinitionByID(fieldId);
            if (fieldDefinition == null || !fieldDefinition.isUsedInPhysicalType()) {
                throw this.newIllegalFieldIDException(fieldId);
            }
            field = this.addField(fieldDefinition);
        }
        return field;
    }

    public boolean isDirty() {
        for (Field field : this.cache.values()) {
            FieldImpl fieldImpl = (FieldImpl)field;
            if (!field.isDirty() || fieldImpl.getModificationType() != FieldModificationType.USER) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        for (Field field : this.cache.values()) {
            if (field.getStatus() == FieldStatus.VALID) continue;
            return false;
        }
        return true;
    }

    public FieldImpl getFieldInternal(String name) {
        FieldImpl field = (FieldImpl)this.cache.get(name);
        if (field == null && (field = this.addCalculatedFieldIfPossible(name)) == null) {
            throw this.newIllegalFieldNameException(name);
        }
        return field;
    }

    public FieldImpl getFieldInternal(int fieldId) {
        FieldImpl field = (FieldImpl)this.cache.get(fieldId);
        if (field == null && (field = this.addCalculatedFieldIfPossible(fieldId)) == null) {
            throw this.newIllegalFieldIDException(fieldId);
        }
        return field;
    }

    public boolean hasField(int fieldId) {
        return this.cache.get(fieldId) != null;
    }

    public WorkItemImpl getWorkItemInternal() {
        return this.workItem;
    }

    private FieldImpl addCalculatedFieldIfPossible(int fieldId) {
        return this.addCalculatedFieldIfPossible(this.context.getWorkItemFieldUsages().getFieldDefinitionByID(fieldId));
    }

    private FieldImpl addCalculatedFieldIfPossible(String fieldName) {
        return this.addCalculatedFieldIfPossible(this.context.getWorkItemFieldUsages().getFieldDefinitionByName(fieldName));
    }

    private FieldImpl addCalculatedFieldIfPossible(FieldDefinitionImpl fieldDefinition) {
        if (fieldDefinition == null || !fieldDefinition.isUsedInPhysicalType()) {
            return null;
        }
        switch (fieldDefinition.getID()) {
            case -1: {
                if (!this.hasField(-6)) break;
                return this.addField(fieldDefinition);
            }
            case -105: {
                if (!this.hasField(-104)) break;
                return this.addField(fieldDefinition);
            }
            case -42: 
            case -12: 
            case -7: {
                if (!this.hasField(-2)) break;
                return this.addField(fieldDefinition);
            }
        }
        return null;
    }
}

