/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.httpclient.auth;

import com.microsoft.tfs.core.httpclient.Credentials;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.HttpMethod;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import com.microsoft.tfs.core.httpclient.auth.AuthScheme;
import com.microsoft.tfs.core.httpclient.auth.AuthScope;
import com.microsoft.tfs.core.httpclient.auth.AuthenticationException;
import com.microsoft.tfs.core.httpclient.auth.AuthorizationHeaderScheme;
import com.microsoft.tfs.core.httpclient.auth.MalformedChallengeException;
import com.microsoft.tfs.core.httpclient.auth.WindowsUser;
import com.microsoft.tfs.core.httpclient.util.EncodingUtil;
import com.microsoft.tfs.jni.AuthenticationEngine;
import com.microsoft.tfs.jni.NTLMEngine;
import com.microsoft.tfs.jni.helpers.LocalHost;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTLMScheme
extends AuthorizationHeaderScheme
implements AuthScheme {
    private static final Log LOG = LogFactory.getLog(NTLMScheme.class);
    private static final int STATUS_NONE = 0;
    private static final int STATUS_INITIATED = 1;
    private static final int STATUS_EXCHANGING = 2;
    private static final int STATUS_COMPLETE = 3;
    private static final int STATUS_ERROR = 4;
    private int status = 0;
    private byte[] inputToken = null;
    private NTLMEngine.NTLMClient ntlmClient;
    private final String localHostname = LocalHost.getShortName();

    @Override
    public String getSchemeName() {
        return "ntlm";
    }

    public static boolean isSupported() {
        try {
            return NTLMEngine.getInstance().isAvailable();
        }
        catch (Exception e) {
            LOG.debug((Object)"NTLM authentication not supported", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean supportsCredentials(Credentials credentials) {
        if (credentials == null) {
            return false;
        }
        return NTLMScheme.supportsCredentials(credentials.getClass());
    }

    @Override
    public void cleanup() {
        if (this.ntlmClient != null) {
            this.ntlmClient.dispose();
            this.ntlmClient = null;
        }
        this.inputToken = null;
    }

    public static boolean supportsCredentials(Class<?> credentialClass) {
        if (credentialClass == null || !NTLMScheme.isSupported()) {
            return false;
        }
        if (credentialClass.equals(DefaultNTCredentials.class)) {
            return NTLMEngine.getInstance().supportsCredentialsDefault();
        }
        if (credentialClass.equals(UsernamePasswordCredentials.class)) {
            return NTLMEngine.getInstance().supportsCredentialsSpecified();
        }
        return false;
    }

    public static String getDefaultCredentials() {
        if (!NTLMScheme.isSupported()) {
            return null;
        }
        return NTLMEngine.getInstance().getCredentialsDefault();
    }

    public String getRealm() {
        return null;
    }

    @Override
    public String getParameter(String name) {
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.status == 3 || this.status == 4;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    public void processChallenge(String challenge) throws MalformedChallengeException {
        if (this.status == 0 && challenge.equals("NTLM")) {
            if (this.ntlmClient != null) {
                try {
                    this.ntlmClient.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.ntlmClient = null;
            this.inputToken = null;
            this.status = 1;
        } else if (this.status == 2 && challenge.startsWith("NTLM ")) {
            this.inputToken = Base64.decodeBase64((byte[])EncodingUtil.getAsciiBytes(challenge.substring(5)));
        } else if (challenge.startsWith("NTLM")) {
            this.status = 4;
        } else {
            throw new MalformedChallengeException("Unknown challenge: " + challenge);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String authenticate(AuthScope authscope, Credentials credentials, HttpMethod method) throws AuthenticationException {
        byte[] token;
        if (authscope == null || credentials == null || method == null) {
            throw new AuthenticationException("Invalid authentication usage");
        }
        if (!this.supportsCredentials(credentials)) {
            throw new AuthenticationException("Credential type unsupported");
        }
        try {
            if (this.status == 1 && this.ntlmClient == null && this.inputToken == null) {
                this.ntlmClient = (NTLMEngine.NTLMClient)NTLMEngine.getInstance().newClient();
                this.ntlmClient.setTarget(authscope.getHost());
                if (credentials instanceof DefaultNTCredentials) {
                    this.ntlmClient.setCredentialsDefault();
                } else {
                    if (!(credentials instanceof UsernamePasswordCredentials)) throw new AuthenticationException("Unsupported credential type");
                    WindowsUser user = new WindowsUser(((UsernamePasswordCredentials)credentials).getUsername());
                    this.ntlmClient.setCredentialsSpecified(user.getUsername(), user.getDomain(), ((UsernamePasswordCredentials)credentials).getPassword());
                    this.ntlmClient.setLocalhost(this.localHostname);
                }
            } else if (this.status != 2 || this.ntlmClient == null || this.inputToken == null) {
                LOG.error((Object)("NTLM authenticate called in invalid state " + this.status));
                this.status = 4;
                throw new AuthenticationException("NTLM Authentication Routines Used Out of Order");
            }
            token = this.ntlmClient.getToken(this.inputToken);
            if (this.ntlmClient.isComplete()) {
                this.status = 3;
                this.cleanup();
            } else {
                this.status = 2;
            }
        }
        catch (AuthenticationEngine.AuthenticationException e) {
            LOG.error((Object)("NTLM failure: " + e.getMessage()));
            this.status = 4;
            return null;
        }
        if (token == null || token.length == 0) {
            this.status = 4;
            throw new AuthenticationException("NTLM Scheme did not provided token");
        }
        String tokenBase64 = EncodingUtil.getAsciiString(Base64.encodeBase64((byte[])token));
        return "NTLM " + tokenBase64;
    }
}

