/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.util.serverlist.internal;

import com.microsoft.tfs.core.internal.persistence.DOMObjectSerializer;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.core.util.serverlist.ServerList;
import com.microsoft.tfs.core.util.serverlist.ServerListCollectionEntry;
import com.microsoft.tfs.core.util.serverlist.ServerListConfigurationEntry;
import com.microsoft.tfs.core.util.serverlist.ServerListEntryType;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServerListSerializer
extends DOMObjectSerializer {
    private static final Log log = LogFactory.getLog(ServerListSerializer.class);
    private static final int SCHEMA_VERSION = 1;
    private static final String SERVERS_ELEMENT_NAME = "servers";
    private static final String SERVER_ELEMENT_NAME = "server";
    private static final String COLLECTIONS_ELEMENT_NAME = "collections";
    private static final String COLLECTION_ELEMENT_NAME = "collection";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String OFFLINE_ATTRIBUTE_NAME = "offline";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String URI_ATTRIBUTE_NAME = "uri";

    @Override
    protected Document createDocumentFromComponent(Object object) {
        ServerList serverList = (ServerList)object;
        Document document = DOMCreateUtils.newDocument(SERVERS_ELEMENT_NAME);
        Element rootElement = document.getDocumentElement();
        rootElement.setAttribute(VERSION_ATTRIBUTE_NAME, String.valueOf(1));
        for (ServerListConfigurationEntry server : serverList.getServers()) {
            Element serverElement = DOMUtils.appendChild(rootElement, SERVER_ELEMENT_NAME);
            serverElement.setAttribute(NAME_ATTRIBUTE_NAME, server.getName());
            serverElement.setAttribute(TYPE_ATTRIBUTE_NAME, Integer.toString(server.getType().getValue()));
            serverElement.setAttribute(URI_ATTRIBUTE_NAME, URIUtils.removeTrailingSlash(server.getURI()).toString());
            Set<ServerListCollectionEntry> collections = server.getCollections();
            if (collections == null || collections.size() <= 0) continue;
            Element collectionsElement = DOMUtils.appendChild(serverElement, COLLECTIONS_ELEMENT_NAME);
            for (ServerListCollectionEntry collection : collections) {
                Element collectionElement = DOMUtils.appendChild(collectionsElement, COLLECTION_ELEMENT_NAME);
                collectionElement.setAttribute(NAME_ATTRIBUTE_NAME, collection.getName());
                if (collection.getOffline() != null) {
                    collectionElement.setAttribute(OFFLINE_ATTRIBUTE_NAME, Boolean.toString(collection.getOffline()));
                }
                collectionElement.setAttribute(TYPE_ATTRIBUTE_NAME, Integer.toString(collection.getType().getValue()));
                collectionElement.setAttribute(URI_ATTRIBUTE_NAME, URIUtils.removeTrailingSlash(collection.getURI()).toString());
            }
        }
        return document;
    }

    @Override
    protected Object createComponentFromDocument(Document document) {
        Element root = document.getDocumentElement();
        if (!SERVERS_ELEMENT_NAME.equals(root.getNodeName())) {
            throw new RuntimeException(MessageFormat.format("Unexpected root element {0}", root.getNodeName()));
        }
        String sSchemaVersion = root.getAttribute(VERSION_ATTRIBUTE_NAME);
        if (sSchemaVersion != null && sSchemaVersion.length() > 0) {
            try {
                Integer.parseInt(sSchemaVersion);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        ServerList serverList = new ServerList();
        Element[] serverElements = DOMUtils.getChildElements(root, SERVER_ELEMENT_NAME);
        for (int i = 0; i < serverElements.length; ++i) {
            String serverName = ServerListSerializer.getName(serverElements[i].getAttribute(NAME_ATTRIBUTE_NAME));
            ServerListEntryType serverType = ServerListSerializer.getType(serverElements[i].getAttribute(TYPE_ATTRIBUTE_NAME));
            URI serverUri = ServerListSerializer.getURI(serverElements[i].getAttribute(URI_ATTRIBUTE_NAME));
            if (serverName == null || serverType == null || serverUri == null) continue;
            ServerListConfigurationEntry server = new ServerListConfigurationEntry(serverName, serverType, serverUri);
            Element[] collectionsElements = DOMUtils.getChildElements(serverElements[i], COLLECTIONS_ELEMENT_NAME);
            for (int j = 0; j < collectionsElements.length; ++j) {
                Element[] collectionElements = DOMUtils.getChildElements(serverElements[i], COLLECTION_ELEMENT_NAME);
                for (int k = 0; k < collectionElements.length; ++k) {
                    String collectionName = ServerListSerializer.getName(collectionElements[k].getAttribute(NAME_ATTRIBUTE_NAME));
                    Boolean collectionOffline = ServerListSerializer.getOffline(collectionElements[k].getAttribute(OFFLINE_ATTRIBUTE_NAME));
                    ServerListEntryType collectionType = ServerListSerializer.getType(collectionElements[k].getAttribute(TYPE_ATTRIBUTE_NAME));
                    URI collectionUri = ServerListSerializer.getURI(collectionElements[k].getAttribute(URI_ATTRIBUTE_NAME));
                    if (collectionName == null || collectionType == null || collectionUri == null) continue;
                    ServerListCollectionEntry collection = new ServerListCollectionEntry(collectionName, collectionType, collectionUri, collectionOffline);
                    server.getCollections().add(collection);
                }
            }
            serverList.add(server);
        }
        return serverList;
    }

    private static String getName(String nameAttribute) {
        if (nameAttribute == null || nameAttribute.length() == 0) {
            return null;
        }
        return nameAttribute;
    }

    private static Boolean getOffline(String offlineAttribute) {
        if (offlineAttribute == null || offlineAttribute.length() == 0) {
            return null;
        }
        return Boolean.valueOf(offlineAttribute);
    }

    private static ServerListEntryType getType(String typeAttribute) {
        if (typeAttribute == null || typeAttribute.length() == 0) {
            return null;
        }
        try {
            return ServerListEntryType.fromValue(Integer.parseInt(typeAttribute));
        }
        catch (Exception e) {
            log.warn((Object)"Could not deserialize type", (Throwable)e);
            return null;
        }
    }

    private static URI getURI(String uriAttribute) {
        try {
            return URIUtils.newURI(uriAttribute);
        }
        catch (Exception e) {
            log.warn((Object)"Could not deserialize uri", (Throwable)e);
            return null;
        }
    }
}

