/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.stax.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DOMStreamReader
implements XMLStreamReader {
    public Map properties = new HashMap();
    private final ArrayList frames = new ArrayList();
    private ElementFrame frame;
    private int currentEvent = 7;
    private Node content;
    private final Document document;
    private DOMNamespaceContext context;

    public DOMStreamReader(Element element) {
        this.frame = new ElementFrame(element, null);
        this.frames.add(this.frame);
        this.newFrame(this.frame);
        this.document = element.getOwnerDocument();
    }

    protected ElementFrame getCurrentFrame() {
        return this.frame;
    }

    @Override
    public Object getProperty(String key) throws IllegalArgumentException {
        return this.properties.get(key);
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.frame.ended) {
            this.frames.remove(this.frames.size() - 1);
            if (!this.frames.isEmpty()) {
                this.frame = (ElementFrame)this.frames.get(this.frames.size() - 1);
            } else {
                this.currentEvent = 8;
                return this.currentEvent;
            }
        }
        if (!this.frame.started) {
            this.frame.started = true;
            this.currentEvent = 1;
        } else if (this.frame.currentAttribute < this.getAttributeCount() - 1) {
            ++this.frame.currentAttribute;
            this.currentEvent = 10;
        } else if (this.frame.currentNamespace < this.getNamespaceCount() - 1) {
            ++this.frame.currentNamespace;
            this.currentEvent = 13;
        } else if (this.frame.currentChild < this.getChildCount() - 1) {
            ++this.frame.currentChild;
            this.currentEvent = this.moveToChild(this.frame.currentChild);
            if (this.currentEvent == 1) {
                ElementFrame newFrame = this.getChildFrame(this.frame.currentChild);
                newFrame.started = true;
                this.frame = newFrame;
                this.frames.add(this.frame);
                this.currentEvent = 1;
                this.newFrame(newFrame);
            }
        } else {
            this.frame.ended = true;
            this.currentEvent = 2;
            this.endElement();
        }
        return this.currentEvent;
    }

    protected void skipFrame() {
        this.frame.ended = true;
        this.currentEvent = 2;
    }

    @Override
    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        while (this.hasNext()) {
            int e = this.next();
            if (e != 1 && e != 2) continue;
            return e;
        }
        return this.currentEvent;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        return this.frames.size() != 0 || !this.frame.ended;
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public boolean isStartElement() {
        return this.currentEvent == 1;
    }

    @Override
    public boolean isEndElement() {
        return this.currentEvent == 2;
    }

    @Override
    public boolean isCharacters() {
        return this.currentEvent == 4;
    }

    @Override
    public boolean isWhiteSpace() {
        return this.currentEvent == 6;
    }

    @Override
    public int getEventType() {
        return this.currentEvent;
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        char[] src = this.getText().toCharArray();
        if (sourceStart + length >= src.length) {
            length = src.length - sourceStart;
        }
        for (int i = 0; i < length; ++i) {
            target[targetStart + i] = src[i + sourceStart];
        }
        return length;
    }

    @Override
    public boolean hasText() {
        return this.currentEvent == 4 || this.currentEvent == 11 || this.currentEvent == 9 || this.currentEvent == 5 || this.currentEvent == 6;
    }

    @Override
    public Location getLocation() {
        return new Location(){

            @Override
            public int getCharacterOffset() {
                return 0;
            }

            @Override
            public int getColumnNumber() {
                return 0;
            }

            @Override
            public int getLineNumber() {
                return 0;
            }

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }
        };
    }

    @Override
    public boolean hasName() {
        return this.currentEvent == 1 || this.currentEvent == 2;
    }

    @Override
    public String getVersion() {
        return null;
    }

    @Override
    public boolean isStandalone() {
        return false;
    }

    @Override
    public boolean standaloneSet() {
        return false;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return null;
    }

    public Document getDocument() {
        return this.document;
    }

    protected void newFrame(ElementFrame frame) {
        Element element = this.getCurrentElement();
        frame.uris = new ArrayList();
        frame.prefixes = new ArrayList();
        frame.attributes = new ArrayList();
        if (this.context == null) {
            this.context = new DOMNamespaceContext();
        }
        this.context.setElement(element);
        NamedNodeMap nodes = element.getAttributes();
        String ePrefix = element.getPrefix();
        if (ePrefix == null) {
            ePrefix = "";
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String prefix = node.getPrefix();
            String localName = node.getLocalName();
            String value = node.getNodeValue();
            String name = node.getNodeName();
            if (prefix == null) {
                prefix = "";
            }
            if (name != null && name.equals("xmlns")) {
                frame.uris.add(value);
                frame.prefixes.add("");
                continue;
            }
            if (prefix.length() > 0 && prefix.equals("xmlns")) {
                frame.uris.add(value);
                frame.prefixes.add(localName);
                continue;
            }
            if (name.startsWith("xmlns:")) {
                prefix = name.substring(6);
                frame.uris.add(value);
                frame.prefixes.add(prefix);
                continue;
            }
            frame.attributes.add(node);
        }
    }

    protected void endElement() {
    }

    protected Element getCurrentElement() {
        return (Element)this.getCurrentFrame().element;
    }

    public Element skipElement() {
        Element e = (Element)this.getCurrentFrame().element;
        this.skipFrame();
        return e;
    }

    protected ElementFrame getChildFrame(int currentChild) {
        return new ElementFrame(this.getCurrentElement().getChildNodes().item(currentChild), this.getCurrentFrame());
    }

    protected int getChildCount() {
        return this.getCurrentElement().getChildNodes().getLength();
    }

    protected int moveToChild(int currentChild) {
        this.content = this.getCurrentElement().getChildNodes().item(currentChild);
        if (this.content instanceof Text) {
            return 4;
        }
        if (this.content instanceof Element) {
            return 1;
        }
        if (this.content instanceof CDATASection) {
            return 12;
        }
        if (this.content instanceof Comment) {
            return 4;
        }
        if (this.content instanceof EntityReference) {
            return 9;
        }
        throw new IllegalStateException();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.getText();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        ElementFrame frame = this.getCurrentFrame();
        while (null != frame) {
            int index = frame.prefixes.indexOf(prefix);
            if (index != -1) {
                return (String)frame.uris.get(index);
            }
            frame = frame.parent;
        }
        return null;
    }

    @Override
    public String getAttributeValue(String ns, String local) {
        if (ns == null || ns.equals("")) {
            return this.getCurrentElement().getAttribute(local);
        }
        return this.getCurrentElement().getAttributeNS(ns, local);
    }

    @Override
    public int getAttributeCount() {
        return this.getCurrentFrame().attributes.size();
    }

    Attr getAttribute(int i) {
        return (Attr)this.getCurrentFrame().attributes.get(i);
    }

    private String getLocalName(Attr attr) {
        String name = attr.getLocalName();
        if (name == null) {
            name = attr.getNodeName();
        }
        return name;
    }

    @Override
    public QName getAttributeName(int i) {
        Attr at = this.getAttribute(i);
        String prefix = at.getPrefix();
        String ln = this.getLocalName(at);
        String ns = at.getNamespaceURI();
        if (prefix == null) {
            return new QName(ns, ln);
        }
        return new QName(ns, ln, prefix);
    }

    @Override
    public String getAttributeNamespace(int i) {
        return this.getAttribute(i).getNamespaceURI();
    }

    @Override
    public String getAttributeLocalName(int i) {
        Attr attr = this.getAttribute(i);
        String name = this.getLocalName(attr);
        return name;
    }

    @Override
    public String getAttributePrefix(int i) {
        return this.getAttribute(i).getPrefix();
    }

    @Override
    public String getAttributeType(int i) {
        return DOMStreamReader.toStaxType(this.getAttribute(i).getNodeType());
    }

    public static String toStaxType(short jdom) {
        switch (jdom) {
            default: 
        }
        return null;
    }

    @Override
    public String getAttributeValue(int i) {
        return this.getAttribute(i).getValue();
    }

    @Override
    public boolean isAttributeSpecified(int i) {
        return this.getAttribute(i).getValue() != null;
    }

    @Override
    public int getNamespaceCount() {
        return this.getCurrentFrame().prefixes.size();
    }

    @Override
    public String getNamespacePrefix(int i) {
        return (String)this.getCurrentFrame().prefixes.get(i);
    }

    @Override
    public String getNamespaceURI(int i) {
        return (String)this.getCurrentFrame().uris.get(i);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.context;
    }

    @Override
    public String getText() {
        Node node = this.getCurrentElement().getChildNodes().item(this.getCurrentFrame().currentChild);
        return node.getNodeValue();
    }

    @Override
    public char[] getTextCharacters() {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextStart() {
        return 0;
    }

    @Override
    public int getTextLength() {
        return this.getText().length();
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public QName getName() {
        Element el = this.getCurrentElement();
        String prefix = this.getPrefix();
        String ln = this.getLocalName();
        if (prefix == null) {
            return new QName(el.getNamespaceURI(), ln);
        }
        return new QName(el.getNamespaceURI(), ln, prefix);
    }

    @Override
    public String getLocalName() {
        String name = this.getCurrentElement().getLocalName();
        if (name == null) {
            name = this.getCurrentElement().getNodeName();
        }
        return name;
    }

    @Override
    public String getNamespaceURI() {
        return this.getCurrentElement().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        String prefix = this.getCurrentElement().getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        return prefix;
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException();
    }

    public static class ElementFrame {
        final Object element;
        final ElementFrame parent;
        boolean started = false;
        boolean ended = false;
        int currentChild = -1;
        int currentAttribute = -1;
        int currentNamespace = -1;
        int currentElement = -1;
        List uris;
        List prefixes;
        List attributes;
        List allAttributes;

        public ElementFrame(Object element, ElementFrame parent) {
            this.element = element;
            this.parent = parent;
        }
    }

    public class DOMNamespaceContext
    implements NamespaceContext {
        private Element currentNode;

        @Override
        public String getNamespaceURI(String prefix) {
            String name = prefix;
            name = name.length() == 0 ? "xmlns" : "xmlns:" + prefix;
            return this.getNamespaceURI(this.currentNode, name);
        }

        private String getNamespaceURI(Element e, String name) {
            Attr attr = e.getAttributeNode(name);
            if (attr == null) {
                Node n = e.getParentNode();
                if (n instanceof Element && n != e) {
                    return this.getNamespaceURI((Element)n, name);
                }
            } else {
                return attr.getValue();
            }
            return null;
        }

        @Override
        public String getPrefix(String uri) {
            return this.getPrefix(this.currentNode, uri);
        }

        private String getPrefix(Element e, String uri) {
            NamedNodeMap attributes = e.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr a = (Attr)attributes.item(i);
                String val = a.getValue();
                if (val == null || !val.equals(uri)) continue;
                String name = a.getNodeName();
                if (name.equals("xmlns")) {
                    return "";
                }
                return name.substring(6);
            }
            Node n = e.getParentNode();
            if (n instanceof Element && n != e) {
                return this.getPrefix((Element)n, uri);
            }
            return null;
        }

        public Iterator getPrefixes(String uri) {
            ArrayList<String> prefixes = new ArrayList<String>();
            String prefix = this.getPrefix(uri);
            if (prefix != null) {
                prefixes.add(prefix);
            }
            return prefixes.iterator();
        }

        public Element getElement() {
            return this.currentNode;
        }

        public void setElement(Element currentNode) {
            this.currentNode = currentNode;
        }
    }
}

