/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.chunkingcodec;

import com.microsoft.tfs.util.chunkingcodec.ChunkedEncoder;
import java.io.IOException;

public abstract class ChunkedEncoderArray
implements ChunkedEncoder {
    private ChunkedEncoder currentEncoder;
    private int encoderIdx = 0;
    private boolean complete = false;

    protected ChunkedEncoderArray() {
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    protected abstract ChunkedEncoder start(int var1);

    private void getNextEncoder() {
        this.currentEncoder = this.start(this.encoderIdx);
        ++this.encoderIdx;
        if (this.currentEncoder == null) {
            this.complete = true;
        }
    }

    @Override
    public int encode(byte[] buf, int off, int len) throws IOException {
        int doneLen = 0;
        if (this.currentEncoder == null) {
            this.getNextEncoder();
        }
        while (doneLen < len && !this.complete) {
            doneLen += this.currentEncoder.encode(buf, off + doneLen, len - doneLen);
            if (!this.currentEncoder.isComplete()) continue;
            this.getNextEncoder();
        }
        return doneLen;
    }
}

