/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.proxy;

import com.microsoft.tfs.util.proxy.DelegatingInvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Calendar;
import org.apache.commons.logging.Log;

public class LoggingInvocationHandler
implements DelegatingInvocationHandler {
    private final Object proxiedObject;
    private final Log log;

    public LoggingInvocationHandler(Object proxiedObject, Log log) {
        this.proxiedObject = proxiedObject;
        this.log = log;
    }

    @Override
    public Object getProxiedObject() {
        return this.proxiedObject;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long stTime = System.currentTimeMillis();
        try {
            Object object = method.invoke(this.proxiedObject, args);
            return object;
        }
        catch (InvocationTargetException ex) {
            throw ex.getCause();
        }
        finally {
            long elapsed = System.currentTimeMillis() - stTime;
            if (this.log.isTraceEnabled()) {
                this.traceLog(method, args, elapsed);
            } else if (this.log.isDebugEnabled()) {
                this.debugLog(method, elapsed);
            }
        }
    }

    private void traceLog(Method method, Object[] args, long elapsed) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(elapsed);
        buffer.append(": ");
        buffer.append(method.getName());
        buffer.append("(");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                buffer.append(this.getArgumentRepresentation(args[i]));
                if (i >= args.length - 1) continue;
                buffer.append(",");
            }
        }
        buffer.append(")");
        this.log.trace((Object)buffer.toString());
    }

    private String getArgumentRepresentation(Object object) {
        if (object == null) {
            return null;
        }
        String s = null;
        if (object.getClass().isArray()) {
            s = object.getClass().getComponentType().getName();
            if (s.lastIndexOf(".") != -1) {
                s = s.substring(s.lastIndexOf(".") + 1);
            }
            s = s + "[]";
        } else if (object instanceof Calendar) {
            s = ((Calendar)object).getTime().toString();
        } else {
            s = object.toString();
            s = s.replace('\n', ' ');
            s = s.replace('\r', ' ');
            if ((s = s.replace(',', ' ')).length() > 40 && (s = object.getClass().getName()).lastIndexOf(".") != -1) {
                s = s.substring(s.lastIndexOf(".") + 1);
            }
        }
        return s;
    }

    private void debugLog(Method method, long elapsed) {
        this.log.debug((Object)(method.getName() + ": " + elapsed));
    }
}

