/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.OAuthStateUtils;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.GitHubAuthenticationUtils;
import com.teamscale.core.authenticate.github.index.OAuthTokenIndex;
import com.teamscale.core.authenticate.index.OAuthStateIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.authenticate.SSORequestCookieHandler;
import com.teamscale.service.authenticate.SsoAuthenticationServiceBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.RedirectionException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/github/oauth")
public class GitHubAuthenticationService
extends SsoAuthenticationServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Handles the redirection of the GitHub OAuth authentication.", description="Redirects the user to the target that has been passed in the state parameter or dashboard if it does not exist.", tags={"Voting Connectors"})
    @RequiresNoLogin
    public Response authenticate(@Parameter(description="The authentication code from GitHub.", required=true) @QueryParam(value="code") String code, @Parameter(description="The state that was passed to GitHub.") @QueryParam(value="state") String state, @Context ContainerRequestContext requestContext) throws StorageException, AuthenticationToolException {
        GitHubApplicationDescription.State parsedState = this.parseState(state);
        this.validateCsrfToken(parsedState, requestContext);
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        String appId = parsedState.appId();
        GitHubApplicationDescription description = GitHubAppUtils.loadConfiguredApplication((String)appId, (String)parsedState.serverUrl(), (ServerOptionIndex)optionIndex, InternalServerErrorException::new);
        if (!Objects.requireNonNull(description).useForSso) {
            throw new BadRequestException("SSO is disabled for this GitHub app.");
        }
        try {
            User user = this.authenticateUser(code, description);
            return this.buildSsoResponse(user, parsedState.redirectionTarget());
        }
        catch (ServiceCallException e) {
            throw new RedirectionException("Failed to login via Github. Secret ID of GitHub App is incorrect.", 302, this.buildErrorURI("GithubOAuthSecret"));
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }

    private GitHubApplicationDescription.State parseState(String state) {
        try {
            return GitHubApplicationDescription.State.fromQueryString((String)state);
        }
        catch (ConQATException e) {
            LOGGER.error("Failed to deserialize state from: {}", (Object)state, (Object)e);
            throw new RedirectionException("Failed to login via GitHub. Provided state did not have the desired format.", 302, this.buildErrorURI("GitHubState"));
        }
    }

    private User authenticateUser(String code, GitHubApplicationDescription description) throws StorageException, ServiceCallException, AuthenticationToolException {
        OAuthTokenIndex oAuthTokenIndex = this.openGlobalIndex(OAuthTokenIndex.class);
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        UserGroupIndex userGroupIndex = this.openGlobalIndex(UserGroupIndex.class);
        String accessToken = GitHubAuthenticationService.requestAccessToken(code, description);
        Optional userOptional = GitHubAuthenticationUtils.getOrCreateAuthenticatedUser((String)accessToken, (String)description.serverUrl, (GitHubApplicationDescription)description, (UserIndex)userIndex, (UserGroupIndex)userGroupIndex, (OAuthTokenIndex)oAuthTokenIndex, (IMessageBroker)this.serviceInfo.getMessageBroker());
        if (!userOptional.map(User::getAuthenticator).orElse("").startsWith("GitHubOAuth")) {
            throw new RedirectionException("Failed to login via GitHub. GitHub user does not exist as Teamscale User.", 302, this.buildErrorURI("GithubNoSuchTeamscaleUser"));
        }
        return (User)userOptional.get();
    }

    private void validateCsrfToken(GitHubApplicationDescription.State parsedState, ContainerRequestContext requestContext) throws StorageException {
        String csrfToken = parsedState.csrfToken();
        try {
            Optional<String> currentSessionContext = SSORequestCookieHandler.getSSOCookieValue(requestContext);
            if (currentSessionContext.isEmpty()) {
                throw new IllegalArgumentException("Missing Cookie for CSRF protection.");
            }
            OAuthStateIndex stateIndex = this.openGlobalIndex(OAuthStateIndex.class);
            OAuthStateUtils.validateCsrfToken((String)csrfToken, (String)currentSessionContext.get(), (OAuthStateIndex)stateIndex);
        }
        catch (IllegalArgumentException e) {
            throw new RedirectionException("Failed to login via GitHub. " + e.getMessage(), 302, this.buildErrorURI("GitHubState"));
        }
    }

    private static String requestAccessToken(String code, GitHubApplicationDescription description) throws ServiceCallException {
        return GitHubAuthenticationUtils.requestAccessToken((String)code, (GitHubApplicationDescription)description);
    }
}

