/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.commits;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.commit_alert.CommitAlertIndex;
import com.teamscale.index.commit_alert.CommitAlerts;
import com.teamscale.index.issues.model.TeamscaleIssueStatus;
import com.teamscale.index.repository.RepositoryLogEntry;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileChurn;
import com.teamscale.index.repository.RepositoryLogFileChurnIndex;
import com.teamscale.index.tracking.FindingChurnCount;
import com.teamscale.index.tracking.index.FindingChurnCountIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.issues.CommitIssuesService;
import com.teamscale.service.project.ProjectPlatformLinkUtils;
import com.teamscale.service.project.ProjectPlatformLinks;
import com.teamscale.service.user.UserResolveUtils;
import com.teamscale.service.user.UserResolvedRepositoryLogEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class LogEntryResolver {
    private final UserAliasLookup userAliasLookup;
    private final CommitResolvingStorageSystem projectStorageSystem;
    private final FindingChurnCountIndex findingChurnCountIndex;
    private final CommitAlertIndex commitAlertIndex;
    private final CommitDescriptorIndex commitDescriptorIndex;
    private final RepositoryLogFileChurnIndex repositoryLogFileChurnIndex;
    private final PublicProjectId projectId;
    private final IndexLayer indexLayer;

    private LogEntryResolver(UserAliasLookup userAliasLookup, CommitResolvingStorageSystem projectStorageSystem, PublicProjectId publicProjectId, IndexLayer indexLayer) throws StorageException {
        this.projectStorageSystem = projectStorageSystem;
        this.userAliasLookup = userAliasLookup;
        this.findingChurnCountIndex = (FindingChurnCountIndex)projectStorageSystem.openProjectIndex(FindingChurnCountIndex.class, null);
        this.commitAlertIndex = (CommitAlertIndex)projectStorageSystem.openProjectIndex(CommitAlertIndex.class, null);
        this.commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        this.repositoryLogFileChurnIndex = (RepositoryLogFileChurnIndex)projectStorageSystem.openProjectIndex(RepositoryLogFileChurnIndex.class, null);
        this.projectId = publicProjectId;
        this.indexLayer = indexLayer;
    }

    public static LogEntryResolver of(ITeamscaleServiceInfo serviceInfo) throws StorageException {
        return LogEntryResolver.of(serviceInfo.getGlobalStorageSystem(), serviceInfo.getProjectStorageSystem(), serviceInfo.getPrimaryPublicId(), serviceInfo.getIndexLayer());
    }

    public static LogEntryResolver of(GlobalStorageSystem globalStorageSystem, CommitResolvingStorageSystem projectStorageSystem, PublicProjectId projectId, IndexLayer indexLayer) throws StorageException {
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)globalStorageSystem);
        return new LogEntryResolver(userAliasLookup, projectStorageSystem, projectId, indexLayer);
    }

    public static LogEntryResolver of(ITeamscaleServiceInfo serviceInfo, UserAliasLookup userAliasLookup) throws StorageException {
        return new LogEntryResolver(userAliasLookup, serviceInfo.getProjectStorageSystem(), serviceInfo.getPrimaryPublicId(), serviceInfo.getIndexLayer());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<ExtendedRepositoryLogEntry> resolveExtendedRepositoryLogEntry(List<? extends @NonNull RepositoryLogEntry> entries, @Nullable String mergeRequestId) throws StorageException {
        List<UserResolvedRepositoryLogEntry> logEntries = this.getUserResolvedRepositoryLogEntries(entries);
        List commitDescriptors = CollectionUtils.map(logEntries, CommitAssociatedObjectBase::getCommit);
        @Nullable List findingChurns = this.findingChurnCountIndex.getEntries(commitDescriptors);
        List<List<TeamscaleIssueStatus>> issues = CommitIssuesService.getIssuesForCommits((ProjectStorageSystem)this.projectStorageSystem, commitDescriptors);
        Map<String, ProjectPlatformLinks> platformLinksMap = ProjectPlatformLinkUtils.determineProjectPlatformLinksMap(this.projectId, this.indexLayer);
        @Nullable List alertsList = this.commitAlertIndex.getEntries(commitDescriptors);
        @Nullable List fileChurns = this.repositoryLogFileChurnIndex.getEntries(commitDescriptors);
        ArrayList<ExtendedRepositoryLogEntry> extendedLogEntries = new ArrayList<ExtendedRepositoryLogEntry>();
        for (int i = 0; i < logEntries.size(); ++i) {
            UserResolvedRepositoryLogEntry logEntry = logEntries.get(i);
            FindingChurnCount findingChurn = Optional.ofNullable((FindingChurnCount)findingChurns.get(i)).orElseGet(() -> new FindingChurnCount((CommitDescriptor)logEntry.getCommit(), 0, 0, 0, 0, 0));
            List linkedIssues = Optional.ofNullable(issues.get(i)).orElseGet(ArrayList::new);
            String externalLink = LogEntryResolver.getExternalLink(mergeRequestId, platformLinksMap, logEntry);
            int alertCount = Optional.ofNullable((CommitAlerts)alertsList.get(i)).map(CommitAlerts::getAlertCount).orElse(0);
            RepositoryLogFileChurn logFileChurn = Optional.ofNullable((RepositoryLogFileChurn)fileChurns.get(i)).orElseGet(() -> new RepositoryLogFileChurn((CommitDescriptor)logEntry.getCommit(), 0, 0, 0, 0, 0));
            ExtendedRepositoryLogEntry extendedRepositoryLogEntry = new ExtendedRepositoryLogEntry(logEntry, logFileChurn, findingChurn, alertCount, linkedIssues, externalLink);
            extendedLogEntries.add(extendedRepositoryLogEntry);
        }
        return extendedLogEntries;
    }

    private @NonNull List<UserResolvedRepositoryLogEntry> getUserResolvedRepositoryLogEntries(List<? extends @NonNull RepositoryLogEntry> entries) throws StorageException {
        List commitDescriptors = CollectionUtils.map(entries, CommitAssociatedObjectBase::getCommit);
        List parentedCommits = this.commitDescriptorIndex.getCommits(commitDescriptors);
        return UserResolveUtils.resolveRepositoryLogEntryUsers(entries, parentedCommits, this.userAliasLookup);
    }

    private static @Nullable String getExternalLink(@Nullable String mergeRequestId, Map<String, ProjectPlatformLinks> platformLinksMap, UserResolvedRepositoryLogEntry logEntry) {
        ProjectPlatformLinks platformLinks = platformLinksMap.get(logEntry.getRepositoryIdentifier());
        if (platformLinks == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)mergeRequestId)) {
            return platformLinks.commitLinkTemplate.replace("{commitId}", logEntry.getRevision());
        }
        return platformLinks.commitInMergeRequestLinkTemplate.replace("{commitId}", logEntry.getRevision()).replace("{mergeRequestId}", mergeRequestId);
    }

    public List<ExtendedRepositoryLogEntry> resolveRepositoryLogEntryAggregatesAsSeparateEntries(List<@NonNull RepositoryLogEntryAggregate> entries, @Nullable String mergeRequestId) throws StorageException {
        return this.resolveExtendedRepositoryLogEntry(entries.stream().map(RepositoryLogEntryAggregate::getAllEntries).flatMap(Collection::stream).toList(), mergeRequestId);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public List<ExtendedRepositoryLogEntry> resolveRepositoryLogEntryAggregatesAsAggregatedEntries(List<@Nullable RepositoryLogEntryAggregate> entries, @Nullable String mergeRequestId) throws StorageException {
        @NonNull List filteredList = CollectionUtils.filterNullEntries(entries);
        return this.resolveExtendedRepositoryLogEntry(CollectionUtils.map((Collection)filteredList, RepositoryLogEntryAggregate::toAggregateLogEntryWithMultipleRepositories), mergeRequestId);
    }
}

