/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/external-analysis/session/{sessionId}/external-analysis-import-infos")
public class ExternalAnalysisImportService
extends SessionBasedExternalAnalysisServiceBase<SessionBasedExternalAnalysisServiceQueryOptions> {
    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Upload external analysis data", description="Adds external analysis data to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis"}, responses={@ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="404", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Session has been committed or deleted.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void uploadExternalAnalysisResults(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId, @BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) ExternalAnalysisImportInfos externalAnalysisImportInfos) throws StorageException {
        this.process(EHttpMethod.POST, Collections.singletonList(new ExternalAnalysisImportInfosWrapper(externalAnalysisImportInfos)), parameters, sessionId);
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionManager sessionManager, List<IExternalUploadRequestPart> request, SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        sessionManager.storeNewImportInfosForSession(session, ((ExternalAnalysisImportInfosWrapper)request.getFirst()).getRequestBody());
    }

    private static class ExternalAnalysisImportInfosWrapper
    implements IExternalUploadRequestPart {
        private final ExternalAnalysisImportInfos requestBody;

        private ExternalAnalysisImportInfosWrapper(ExternalAnalysisImportInfos requestBody) {
            this.requestBody = requestBody;
        }

        public ExternalAnalysisImportInfos getRequestBody() {
            return this.requestBody;
        }
    }
}

