/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.teamscale.index.findings.calculation.ExcludedFindingsCount;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.wia.SpecItem;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.FindingsSummaryInfo;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.Nullable;

public record PaginatedFindingsWithCount(@JsonProperty(value="findings") List<ExtendedTrackedFinding> findings, @JsonProperty(value="summary") FindingsSummaryInfo summary, @JsonUnwrapped ExcludedFindingsCount excludedFindingsCount, @JsonProperty(value="referencedSpecItems") Map<String, SpecItem> referencedSpecItems, @JsonProperty(value="nextStartIndex") @Nullable Integer nextStartIndex, @JsonProperty(value="resultSize") int resultSize, @JsonProperty(value="hasFindingsWithTasks") boolean hasFindingsWithTasks, @JsonProperty(value="commonProperties") List<String> commonProperties) {
    static PaginatedFindingsWithCount from(ExcludedFindingsCount excludedFindingsCount, FindingsSummaryInfo summary, List<ExtendedTrackedFinding> allFindings, List<ExtendedTrackedFinding> paginatedFindingsWithTask, Map<String, SpecItem> referencedSpecItems, @Nullable Integer nextStartIndex) {
        boolean hasFindingsWithTasks = allFindings.stream().anyMatch(finding -> finding.getNumberOfTasks() > 0);
        List<String> commonProperties = PaginatedFindingsWithCount.getCommonFindingProperties(allFindings);
        return new PaginatedFindingsWithCount(paginatedFindingsWithTask, summary, excludedFindingsCount, referencedSpecItems, nextStartIndex, allFindings.size(), hasFindingsWithTasks, commonProperties);
    }

    private static List<String> getCommonFindingProperties(List<ExtendedTrackedFinding> findings) {
        if (findings.isEmpty()) {
            return List.of();
        }
        HashSet properties = Set.copyOf(findings.getFirst().getProperties().keySet());
        for (ExtendedTrackedFinding finding : findings) {
            properties = CollectionUtils.intersectionSet(properties, (Collection[])new Collection[]{finding.getProperties().keySet()});
        }
        return CollectionUtils.sort(properties);
    }
}

