/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.debug;

import com.teamscale.commons.TeamscaleInstallationUtils;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.client.HttpClientUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.jspecify.annotations.NonNull;

@Path(value="api/findings/debug/generate-findings-descriptions/model-advisor")
public class GenerateModelAdvisorFindingsDescriptionOverrideFilesService
extends ApiBase {
    private static final URI MATHWORKS_MODEL_ADVISOR_DOC_PAGE = URI.create("https://de.mathworks.com/help/slcheck/ref/mab-jmaab-model-advisor-checks.html");

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Downloads extended finding descriptions for findings that we import from Model Advisor reports and stores them in a folder on disk. If the generated files are copied to the folder finding-descriptions in the Teamscale config, they will override the default descriptions.", tags={"Debugging"})
    public String generateDescriptionFiles(@Parameter(description="URL of the matlab page that contains the description of the model-advisor checks (page title is Model Advisor Checks for MAB and JMAAB Compliance). Defaults to the currently working url.") @QueryParam(value="doc-source-url") URI sourceUri, @Parameter(description="The directory where we should write the description files to (defaults to the config directory).") @QueryParam(value="destination-folder") String userDefinedDestinationFolder) throws IOException, URISyntaxException {
        Optional<String> htmlText;
        if (sourceUri == null) {
            sourceUri = MATHWORKS_MODEL_ADVISOR_DOC_PAGE;
        }
        if ((htmlText = this.getHtmlPage(sourceUri)).isEmpty()) {
            throw new InternalServerErrorException("Could not download the website " + String.valueOf(sourceUri) + ". Try to store the Webpage on the Teamscale Server and use a file url instead (e.g., doc-source-url=file:///C:/test.html on a Windows server).");
        }
        Document htmlDocument = Jsoup.parse((String)htmlText.get());
        ArrayList<String> writtenFiles = new ArrayList<String>();
        Elements titles = htmlDocument.getElementsByClass("title");
        File targetDir = this.locateTargetDir(userDefinedDestinationFolder);
        for (Element titleElement : titles) {
            if (!titleElement.tagName().equals("h3") || !titleElement.hasParent()) continue;
            String checkTitle = titleElement.text();
            Element parent = titleElement.parent();
            URI linkResolvingURI = sourceUri;
            if (sourceUri.getScheme().equals("file")) {
                linkResolvingURI = MATHWORKS_MODEL_ADVISOR_DOC_PAGE;
            }
            String markdownDescription = GenerateModelAdvisorFindingsDescriptionOverrideFilesService.extractDescription(parent, linkResolvingURI);
            File descriptionFile = this.overwriteFile(new File(targetDir, FileSystemUtils.toValidFileName((String)checkTitle) + ".md"), markdownDescription);
            writtenFiles.add(descriptionFile.getAbsolutePath());
        }
        return "Written Files: \n" + StringUtils.concat(writtenFiles, (String)"\n");
    }

    @VisibleForTesting
    protected @NonNull File overwriteFile(File descriptionFile, String markdownDescription) throws IOException {
        FileSystemUtils.writeFileUTF8((File)descriptionFile, (String)markdownDescription);
        return descriptionFile;
    }

    private static String extractDescription(Element parent, URI uri) {
        String baseUrl = StringUtils.removeLastPart((String)uri.toString(), (char)'/');
        parent.getElementsByTag("h3").remove();
        parent.getElementsByAttribute("id").removeAttr("id");
        for (Element hrefElement : parent.getElementsByAttribute("href")) {
            String hrefLink = hrefElement.attr("href");
            if (!hrefLink.startsWith("..")) continue;
            hrefElement.removeAttr("href");
            hrefElement.attr("href", baseUrl + "/" + hrefLink);
        }
        return parent.outerHtml();
    }

    @VisibleForTesting
    protected @NonNull File locateTargetDir(String configPath) {
        File targetConfigDir = !StringUtils.isEmpty((String)configPath) ? new File(configPath) : (TeamscaleInstallationUtils.locateConfigFile((String)"teamscale.properties").isPresent() ? ((File)TeamscaleInstallationUtils.locateConfigFile((String)"teamscale.properties").get()).getParentFile() : new File(""));
        return new File(new File(targetConfigDir, "finding-descriptions"), EAnalysisTool.MODEL_ADVISOR.name());
    }

    @VisibleForTesting
    protected Optional<String> getHtmlPage(URI uri) throws IOException, URISyntaxException {
        if (uri.getScheme().equalsIgnoreCase("file")) {
            File file = new File(uri);
            return Optional.ofNullable(FileSystemUtils.readFile((File)file, (Charset)FileSystemUtils.SYSTEM_CHARSET));
        }
        try (CloseableHttpResponse response = GenerateModelAdvisorFindingsDescriptionOverrideFilesService.getCloseableHttpResponse(uri);){
            Optional<String> optional = Optional.ofNullable(EntityUtils.toString((HttpEntity)response.getEntity()));
            return optional;
        }
    }

    private static @NonNull CloseableHttpResponse getCloseableHttpResponse(URI uri) throws URISyntaxException, IOException {
        CloseableHttpClient httpclient = HttpClientUtils.createHttpClientBuilder((long)DurationUtils.ONE_MINUTE.toMillis()).build();
        HttpClientContext context = HttpClientUtils.getContext((String)uri.toURL().toString(), (String)"", (String)"", Collections.emptyList());
        CloseableHttpResponse response = HttpClientUtils.executeGet((CloseableHttpClient)httpclient, (URI)uri, (HttpClientContext)context);
        HttpClientUtils.checkStatusCode((StatusLine)response.getStatusLine(), (String)"Webserver", (URI)uri, InternalServerErrorException::new);
        return response;
    }
}

