/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.powershellscriptanalyzer;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.findings.powershellscriptanalyzer.PowerShellScriptAnalyzerRunner;
import com.teamscale.index.findings.powershellscriptanalyzer.PowerShellScriptAnalyzerSynchronizer;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.SetupVerificationServiceUtils;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;

@Path(value="api/verify/powershell-script-analyzer-setup")
public class VerifyPowershellScriptAnalyzerSetupService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String EXAMPLE_FILE_CONTENT = "b = \"b\"; \nfunction eliminate-file () { }";
    private static final List<String> SELECTED_CHECKS = Arrays.asList("PSUseApprovedVerbs", "PSAvoidTrailingWhitespace");
    private static final Map<String, String> CHECK_OPTIONS = Collections.emptyMap();
    private static final String EXPECTED_FINDINGS = "\tLine has trailing whitespace at src/test.ps1:1-1\n\tThe cmdlet 'eliminate-file' uses an unapproved verb. at src/test.ps1:2-2";

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Operation(summary="Verifies that there is a PowerShellScriptAnalyzer installed on the server, has the required\n version, and can be called by Teamscale.", description="Verifies the PowerShellScriptAnalyzer installation on the server.", tags={"Source Code"})
    public String verifyPowershellScriptAnalyzerSetup() {
        StringBuilder resultMessage = new StringBuilder("This service verifies that there is a PowershellScriptAnalyzer installed on the Teamscale host. It checks whether the PowershellScriptAnalyzer executable can be called, has the required version, and tries to analyze a small example program.\n\n");
        try {
            SetupVerificationServiceUtils.printVersionInformation(resultMessage, "pwsh", PowerShellScriptAnalyzerRunner.loadConfiguredPowerShellExe(), PowerShellScriptAnalyzerSynchronizer.loadExpectedPowerShellScriptAnalyzerVersion(), "com.teamscale.powershell-exe");
            PowerShellScriptAnalyzerSynchronizer.verifyPowerShellScriptAnalyzerVersion();
            resultMessage.append("OK\n");
            resultMessage.append("\n\nSetting up test example in temporary directory.\n");
            VerifyPowershellScriptAnalyzerSetupService.analyzeExampleCode(resultMessage);
        }
        catch (Throwable t) {
            resultMessage.append("Caught an exception (more details in the service log):\n");
            resultMessage.append(t.getMessage());
            resultMessage.append("\n");
            LOGGER.error((Object)t);
        }
        return resultMessage.toString();
    }

    private static PowerShellScriptAnalyzerRunner initializeRunner(TokenElementInfo mainFile) throws StorageException {
        TokenElementIndex contentIndex = new TokenElementIndex((IStore)new InMemoryStore());
        contentIndex.setTokenElement(mainFile.getUniformPath(), mainFile);
        return new PowerShellScriptAnalyzerRunner(CodeScopeAware.defaultCodeScopeWithValue(CHECK_OPTIONS));
    }

    private static void analyzeExampleCode(StringBuilder resultMessage) throws StorageException, IOException {
        TokenElementInfo mainFile = TokenElementInfo.createWithLocalPreprocessing((String)"src/test.ps1", (ELanguage)ELanguage.POWERSHELL, (String)EXAMPLE_FILE_CONTENT);
        mainFile.addDetail((TokenElementDetailBase)new CodeScopeDetail(CodeScopeName.DEFAULT));
        PowerShellScriptAnalyzerRunner runner = VerifyPowershellScriptAnalyzerSetupService.initializeRunner(mainFile);
        File tempDir = new File(FileSystemUtils.getTmpDir(), "powershellscriptanalyzer_verifier_" + System.currentTimeMillis());
        resultMessage.append("Using temp dir ").append(tempDir.getAbsolutePath()).append("\n");
        SetupVerificationServiceUtils.setupCleanTargetDir(tempDir.getAbsolutePath());
        resultMessage.append("Using example file\n").append(EXAMPLE_FILE_CONTENT).append("\n");
        resultMessage.append("Using checks\n");
        for (String check : SELECTED_CHECKS) {
            resultMessage.append("\t").append(check).append("\n");
        }
        resultMessage.append("Generating execution environment and running PowerShellScriptAnalyzer.\n");
        ListMap analysisResults = runner.prepareAndRunPowerShellScriptAnalyzer(Collections.singletonList(mainFile), (File)new CanonicalFile(tempDir), CodeScopeAware.defaultCodeScopeWithValue(SELECTED_CHECKS), false);
        if (analysisResults.getKeys().contains((Object)mainFile.getUniformPath())) {
            resultMessage.append("generatedFindings:").append("\n");
            String actualFindings = SetupVerificationServiceUtils.formatFindingsString((List)analysisResults.getCollection((Object)mainFile.getUniformPath()));
            resultMessage.append(actualFindings);
            if (SetupVerificationServiceUtils.linesAreEqualAnyOrder(actualFindings, EXPECTED_FINDINGS)) {
                resultMessage.append("These are exactly the expected findings. Everything is ok.\n");
            } else {
                resultMessage.append("These are not exactly the expected findings. Something is wrong.\n");
                resultMessage.append("The expected findings are:\n").append(EXPECTED_FINDINGS);
            }
        } else {
            resultMessage.append("PowerShellScriptAnalyzer did not generate findings (something is wrong).\n");
        }
    }
}

