/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request.metrics;

import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.metrics.source.IndexMetricSource;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.metrics.assessment.context.PartitionUpdateType;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.findings.DeltaAnalysisServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.merge_request.metrics.SingleMetricDeltaParams;
import com.teamscale.service.merge_request.metrics.SingleMetricDeltaQueryOptions;
import com.teamscale.service.merge_request.metrics.SingleMetricDeltaTableBuilder;
import com.teamscale.service.merge_request.metrics.SingleMetricDeltaTreemapBuilder;
import com.teamscale.service.merge_request.metrics.SingleMetricDeltaTreemapNode;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/merge-requests/single-metric")
public class MergeRequestSingleMetricDeltaService
extends DeltaAnalysisServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get single metric delta treemap", description="Creates a treemap with the changes of a single metric in a merge request.", tags={"Metrics", "Merge Requests"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp."), @ApiResponse(responseCode="404", description="Requested metric could not be found in index.")})
    @Path(value="delta-treemap")
    public SingleMetricDeltaTreemapData getSingleMetricDeltaTreemap(@BeanParam SingleMetricDeltaQueryOptions deltaQueryParameters, @BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters) throws StorageException {
        SingleMetricDeltaParams deltaParams = this.determineMetricDeltaParameters(deltaQueryParameters, timeRangeParameters);
        SingleMetricDeltaTreemapBuilder trendMetricTreemapBuilder = new SingleMetricDeltaTreemapBuilder(deltaParams);
        return new SingleMetricDeltaTreemapData(MergeRequestSingleMetricDeltaService.buildTreeMap(trendMetricTreemapBuilder, deltaParams.uniformPath()), deltaParams.metricRetrievalStrategy().getMetricDirectorySchemaEntry(deltaQueryParameters.getMetricName()));
    }

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get single metric delta table", description="Creates a table with the changes of a single metric in a merge request.", tags={"Metrics", "Merge Requests"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp."), @ApiResponse(responseCode="404", description="Requested metric could not be found in index.")})
    @Path(value="delta-table")
    public SingleMetricDeltaTableData getSingleMetricDeltaTable(@BeanParam SingleMetricDeltaQueryOptions deltaQueryParameters, @BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters) throws StorageException {
        SingleMetricDeltaParams deltaParams = this.determineMetricDeltaParameters(deltaQueryParameters, timeRangeParameters);
        return new SingleMetricDeltaTableData(new SingleMetricDeltaTableBuilder(deltaParams).build(), deltaParams.metricRetrievalStrategy().getMetricDirectorySchema().getEntry(deltaParams.metricIndex()));
    }

    private SingleMetricDeltaParams determineMetricDeltaParameters(SingleMetricDeltaQueryOptions deltaQueryParameters, TimeRangeResourceServiceQueryOptions timeRangeParameters) throws StorageException {
        UniformPath uniformPath = timeRangeParameters.getUniformPath();
        IMetricRetrievalStrategy metricRetrievalStrategy = this.getMetricRetrievalStrategy(uniformPath);
        int metricIndex = this.getMetricIndex(deltaQueryParameters.getThresholdConfiguration(), deltaQueryParameters.getMetricGroup(), deltaQueryParameters.getMetricName(), metricRetrievalStrategy);
        TimeRange timeRange = this.resolveTimeRange(timeRangeParameters, this.openCommitDescriptorIndex());
        HistoryAccessOption startHistoryAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)timeRange.start());
        HistoryAccessOption endHistoryAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)timeRange.end());
        BasicTokenElementIndex startBasicContentIndex = (BasicTokenElementIndex)this.getProjectStorageSystem().openProjectIndex(BasicTokenElementIndex.class, startHistoryAccessOption);
        BasicTokenElementIndex endBasicContentIndex = (BasicTokenElementIndex)this.getProjectStorageSystem().openProjectIndex(BasicTokenElementIndex.class, endHistoryAccessOption);
        PartitionUpdateType partitionUpdateType = PartitionUpdateType.BOTH_COMPLETE;
        if (uniformPath.isNonCodePath()) {
            String metricId = this.getMetricId(deltaQueryParameters.getMetricName(), uniformPath, deltaQueryParameters.getThresholdConfiguration(), deltaQueryParameters.getMetricGroup());
            partitionUpdateType = PartitionUpdateType.computePartitionUpdateType((ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)startHistoryAccessOption, (HistoryAccessOption)endHistoryAccessOption, (String)metricId, (UniformPath)uniformPath);
        }
        return new SingleMetricDeltaParams(uniformPath, timeRange, metricRetrievalStrategy, metricIndex, startBasicContentIndex, endBasicContentIndex, partitionUpdateType, deltaQueryParameters.isColorBlindModeEnabled(), deltaQueryParameters.isHideRefactoredEntries(), deltaQueryParameters.isFilterUnchangedEntries(), deltaQueryParameters.isShowDeletedEntries(), deltaQueryParameters.isCalculateEntryBasedDeltaPercentage());
    }

    private TimeRange resolveTimeRange(TimeRangeResourceServiceQueryOptions timeRangeParameters, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        TimeRange timeRange = TimeRange.resolveTimeRange(timeRangeParameters.getStart(), timeRangeParameters.getEnd(), timeRangeParameters.getLength(), (IFactory<ProjectStorageSystem, StorageException>)((IFactory)() -> this.getProjectStorageSystem()));
        return MergeRequestSingleMetricDeltaService.resolveEndCommit(timeRange, commitDescriptorIndex);
    }

    private static TimeRange resolveEndCommit(TimeRange timeRange, CommitDescriptorIndex commitDescriptorIndex) throws StorageException {
        Optional branchHead;
        CommitDescriptor endCommit = timeRange.end();
        if (endCommit.isHeadCommit() && !StringUtils.isEmpty((String)endCommit.getBranchName()) && (branchHead = commitDescriptorIndex.getLatestCommitForBranch(endCommit.getBranchName())).isPresent()) {
            return new TimeRange(timeRange.start(), (CommitDescriptor)branchHead.get());
        }
        return timeRange;
    }

    private IMetricRetrievalStrategy getMetricRetrievalStrategy(UniformPath uniformPath) {
        return MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
    }

    private int getMetricIndex(String thresholdConfiguration, String metricGroup, String metricName, IMetricRetrievalStrategy metricRetrievalStrategy) throws StorageException {
        int metricIndex = metricRetrievalStrategy.getMetricDirectorySchema().getValuePosition(this.loadMetricThreshold(thresholdConfiguration, metricGroup, metricName).getMetricName());
        if (metricIndex == -1) {
            throw new NotFoundException("Metric '%s' not found in index.".formatted(metricName));
        }
        return metricIndex;
    }

    private MetricThreshold loadMetricThreshold(String thresholdConfiguration, String metricGroup, String metricName) throws StorageException {
        return (MetricThreshold)((MetricThresholdConfigurationIndex)this.getIndexLayer().openGlobalIndex(MetricThresholdConfigurationIndex.class)).getConfiguration(thresholdConfiguration).findThreshold(metricGroup, metricName).orElseThrow(() -> new NotFoundException("Metric with name '%s' not found in threshold configuration '%s' and group '%s'.".formatted(metricName, thresholdConfiguration, metricGroup)));
    }

    private static @Nullable SingleMetricDeltaTreemapNode buildTreeMap(SingleMetricDeltaTreemapBuilder trendMetricTreemapBuilder, UniformPath uniformPath) throws StorageException {
        try {
            return trendMetricTreemapBuilder.buildTreeMap(uniformPath);
        }
        catch (TreeMapBuilderException e) {
            throw new InternalServerErrorException("Exception during creation of treemap.", (Throwable)((Object)e));
        }
    }

    private String getMetricId(String metricName, UniformPath path, String thresholdConfiguration, String metricGroup) throws StorageException {
        int metricValuePosition = this.getMetricIndex(thresholdConfiguration, metricGroup, metricName, this.getMetricRetrievalStrategy(path));
        MetricSchemaIndex metricSchemaIndex = this.openProjectIndex(MetricSchemaIndex.class, "process-metric-schema", HistoryAccessOption.readHeadUnbranched());
        return ((IndexMetricSource)metricSchemaIndex.getMetricSources().get(metricValuePosition)).getMetricPartition();
    }

    public record SingleMetricDeltaTreemapData(@Nullable SingleMetricDeltaTreemapNode treeMap, MetricDirectorySchemaEntry schema) {
    }

    public record SingleMetricDeltaTableData(List<SingleMetricDeltaTableBuilder.SingleMetricDeltaTableRowData> rows, MetricDirectorySchemaEntry schema) {
    }
}

