/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.history;

import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.framework.util.CsvServiceUtils;
import com.teamscale.service.metrics.history.MetricHistoryService;
import com.teamscale.service.metrics.history.MetricHistoryServiceQueryOptions;
import com.teamscale.service.metrics.history.MetricTrendEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.supercsv.io.CsvListWriter;

@ReadCacheEnabled
@Path(value="api/projects/{project}/metrics/history/csv")
public class MetricHistoryCSVService
extends ApiBase {
    @GET
    @Operation(summary="Download metric history", description="Downloads metric history as CSV", tags={"Metrics"}, responses={@ApiResponse(responseCode="400", description="Additional paths are only supported for a single metric.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Response downloadMetricHistory(@Parameter(description="Uniform path to retrieve the metric history for.", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @BeanParam MetricHistoryServiceQueryOptions parameters, @Parameter(description="The index(es) of the metric in the schema for which to retrieve the history", required=true) @QueryParam(value="metric-indexes") List<Integer> metricIndexes, @Parameter(description="Additional uniform paths for which to retrieve the metric history. This parameter is only supported for single metric mode, i.e. if this parameter is used, the number of metric indexes must be 1.") @QueryParam(value="additional-path") List<String> additionalPaths) throws StorageException {
        if (additionalPaths != null && metricIndexes.size() > 1) {
            throw new BadRequestException("Additional paths are only supported for a single metric");
        }
        return CsvServiceUtils.createCsvResponse((String)"metric-history", csvListWriter -> {
            if (metricIndexes.size() > 1) {
                this.appendSinglePathMetricHistory(parameters, uniformPath, metricIndexes, (CsvListWriter)csvListWriter);
            } else {
                ArrayList<String> projectAndUniformPaths = new ArrayList<String>();
                projectAndUniformPaths.add(String.valueOf(this.serviceInfo.getPrimaryPublicId()) + "/" + String.valueOf(uniformPath));
                projectAndUniformPaths.addAll(additionalPaths);
                this.appendMultiPathMetricHistory(parameters, (List<String>)projectAndUniformPaths, (Integer)metricIndexes.getFirst(), (CsvListWriter)csvListWriter);
            }
        });
    }

    private void appendMultiPathMetricHistory(MetricHistoryServiceQueryOptions parameters, List<String> projectAndUniformPaths, int metricIndex, CsvListWriter csvListWriter) throws BadRequestException, StorageException, IOException {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Timestamp");
        headers.addAll(projectAndUniformPaths);
        csvListWriter.writeHeader(headers.toArray(new String[0]));
        HashSet<Long> allTimestamps = new HashSet<Long>();
        List<Map<Long, MetricTrendEntry>> metricHistories = this.getMetricHistories(parameters, projectAndUniformPaths, allTimestamps);
        ArrayList<Object> lastValues = new ArrayList<Object>(Collections.nCopies(projectAndUniformPaths.size(), null));
        for (Long timestamp : CollectionUtils.sort(allTimestamps)) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(timestamp);
            for (int i = 0; i < projectAndUniformPaths.size(); ++i) {
                MetricTrendEntry entry = metricHistories.get(i).get(timestamp);
                if (entry != null) {
                    Object value = entry.getValue()[metricIndex];
                    lastValues.set(i, value);
                    result.add(value);
                    continue;
                }
                if (lastValues.get(i) == null) continue;
                result.add(lastValues.get(i));
            }
            csvListWriter.write(result);
        }
    }

    private List<Map<Long, MetricTrendEntry>> getMetricHistories(MetricHistoryServiceQueryOptions parameters, List<String> projectAndUniformPaths, Set<Long> allTimestamps) throws StorageException, BadRequestException {
        ArrayList<Map<Long, MetricTrendEntry>> metricHistories = new ArrayList<Map<Long, MetricTrendEntry>>();
        for (String projectAndUniformPath : projectAndUniformPaths) {
            HashMap<Long, MetricTrendEntry> metricHistoryAsMap = new HashMap<Long, MetricTrendEntry>();
            List<MetricTrendEntry> metricHistory = MetricHistoryService.getMetricHistory(parameters, UniformPathCompatibilityUtil.convert((String)UniformPathUtils.stripProject((String)projectAndUniformPath)), (ProjectStorageSystem)this.getProjectStorageSystem((IProjectId)new PublicProjectId(UniformPathUtils.extractProject((String)projectAndUniformPath))), this.getGlobalStorageSystem(), this.getUser());
            for (MetricTrendEntry entry : metricHistory) {
                metricHistoryAsMap.put(entry.getTimestamp(), entry);
                allTimestamps.add(entry.getTimestamp());
            }
            metricHistories.add(metricHistoryAsMap);
        }
        return metricHistories;
    }

    private void appendSinglePathMetricHistory(MetricHistoryServiceQueryOptions parameters, UniformPath uniformPath, List<Integer> metricIndexes, CsvListWriter csvListWriter) throws StorageException, BadRequestException, IOException {
        MetricDirectorySchema metricDirectorySchema = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser()).getMetricDirectorySchema();
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Timestamp");
        for (Integer metricIndex : metricIndexes) {
            headers.add(metricDirectorySchema.getEntry(metricIndex.intValue()).getName());
        }
        csvListWriter.writeHeader(headers.toArray(new String[0]));
        List<MetricTrendEntry> metricHistory = MetricHistoryService.getMetricHistory(parameters, uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), this.getGlobalStorageSystem(), this.getUser());
        for (MetricTrendEntry entry : metricHistory) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(entry.getTimestamp());
            for (Integer metricIndex : metricIndexes) {
                result.add(entry.getValue()[metricIndex]);
            }
            csvListWriter.write(result);
        }
    }
}

