/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.index.configuration.MetricThresholdConfigurationUtils;
import com.teamscale.index.dashboard.templates.DashboardTemplateIndex;
import com.teamscale.service.dashboard.DashboardTemplateService;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.BiConsumerWithException;
import org.conqat.lib.commons.function.PredicateWithException;
import org.conqat.lib.commons.resources.Resource;

public final class DefaultArtifacts {
    private static final String DEFAULT_DASHBOARD_TEMPLATE = "dashboard-templates/Overview Dashboard.tstemplate";
    private static final Set<String> DEFAULT_DASHBOARD_TEMPLATES = Set.of("dashboard-templates/Overview Dashboard.tstemplate", "dashboard-templates/Code-and-Test-Quality-Trend-Overview.tstemplate");
    private static final Set<String> DEFAULT_THRESHOLD_PROFILES = Set.of("thresholds/Code-and-Test-Quality-Overview.tsthresholds");

    public static void loadDefaultDashboardTemplates(GlobalStorageSystem schemaAwareGlobalPartition) throws StorageException {
        DefaultArtifacts.createDefaultArtifacts(schemaAwareGlobalPartition, DashboardTemplateIndex.class, index -> index.getAllDashboardTemplates().isEmpty(), DEFAULT_DASHBOARD_TEMPLATES, (index, resource) -> {
            try {
                DashboardTemplateService.saveDashboardTemplate(resource.getContent(), index, false);
            }
            catch (MigrationException e) {
                throw new StorageException((Throwable)e);
            }
        });
    }

    public static void loadDefaultThresholdProfiles(GlobalStorageSystem schemaAwareGlobalPartition) throws StorageException {
        DefaultArtifacts.createDefaultArtifacts(schemaAwareGlobalPartition, MetricThresholdConfigurationIndex.class, index -> index.getAllThresholdConfigurations().isEmpty(), DEFAULT_THRESHOLD_PROFILES, (index, resource) -> {
            try {
                MetricThresholdConfigurationUtils.createMetricThresholdConfiguration((ObjectNode)((ObjectNode)JsonUtils.deserializeFromJson((String)resource.getContent(), ObjectNode.class)), (MetricThresholdConfigurationIndex)index, null, (boolean)true, (GlobalStorageSystem)schemaAwareGlobalPartition, Collections.emptyMap());
            }
            catch (MigrationException | JsonSerializationException e) {
                throw new StorageException(e);
            }
        });
    }

    private static <T extends IGlobalIndex> void createDefaultArtifacts(GlobalStorageSystem schemaAwareGlobalPartition, Class<T> targetIndexClass, PredicateWithException<T, StorageException> emptyCheck, Set<String> resourceNames, BiConsumerWithException<T, Resource, StorageException> creator) throws StorageException {
        IGlobalIndex targetIndex = schemaAwareGlobalPartition.openGlobalIndex(targetIndexClass);
        if (!emptyCheck.test((Object)targetIndex)) {
            return;
        }
        DefaultArtifacts.loadDefaultArtifactResources(resourceNames).forEach(CollectionUtils.asSneakyConsumer(resource -> {
            try {
                creator.accept((Object)targetIndex, resource);
            }
            catch (StorageException e) {
                throw new StorageException("Could not create default resource: " + resource.getAbsolutePath(), (Throwable)e);
            }
        }));
    }

    private static Stream<Resource> loadDefaultArtifactResources(Set<String> resourcePaths) {
        if (EFeatureToggle.DISABLE_DEFAULT_ANALYSIS_PROFILES_CREATION.isEnabled()) {
            return Stream.of(new Resource[0]);
        }
        return resourcePaths.stream().map(resourcePath -> {
            if (!Resource.exists(DefaultArtifacts.class, (String)resourcePath)) {
                throw new IllegalArgumentException("Could not find the resource " + resourcePath);
            }
            return Resource.of(DefaultArtifacts.class, (String)resourcePath);
        });
    }
}

