/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.resource;

import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.util.ResponseUtils;
import jakarta.ws.rs.NotAcceptableException;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class SourceCodeDownloadServiceBase
extends ApiBase {
    @Context
    private ContainerRequestContext requestContext;

    protected Optional<Response> doGetCode(UniformPath uniformPath, HistoryAccessOption historyOption) throws StorageException {
        Optional<Entity<?>> entity = this.getEntity(uniformPath = uniformPath.resolveToCodePath(), historyOption);
        if (entity.isEmpty()) {
            return Optional.empty();
        }
        String downloadedFileName = uniformPath.getLastSegment();
        MediaType contentType = entity.get().getMediaType();
        return Optional.of(ResponseUtils.getFileDownloadResponse((Object)entity.get().getEntity(), (MediaType)contentType, (String)downloadedFileName));
    }

    private Optional<Entity<?>> getEntity(UniformPath uniformPath, HistoryAccessOption historyOption) throws StorageException {
        byte[] binaryElement = this.getBinaryElement(uniformPath, historyOption);
        if (binaryElement != null) {
            byte[] entity = this.processBinaryElement(binaryElement);
            List<MediaType> possibleMediaTypes = List.of(MediaType.APPLICATION_OCTET_STREAM_TYPE);
            return Optional.of(Entity.entity((Object)entity, (MediaType)this.getMatchingMediaTypeOrFailWithNotAcceptable(uniformPath, possibleMediaTypes)));
        }
        TokenElementInfo tokenElement = this.getTokenElement(uniformPath, historyOption);
        if (tokenElement != null) {
            String responseText = this.processTokenElement(tokenElement);
            List<MediaType> possibleMediaTypes = List.of(MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            return Optional.of(Entity.entity((Object)responseText, (MediaType)this.getMatchingMediaTypeOrFailWithNotAcceptable(uniformPath, possibleMediaTypes)));
        }
        return Optional.empty();
    }

    private MediaType getMatchingMediaTypeOrFailWithNotAcceptable(UniformPath uniformPath, List<MediaType> possibleMediaTypes) {
        List acceptableTypes = this.requestContext.getAcceptableMediaTypes();
        return (MediaType)ResponseUtils.getBestMatchingType((Iterable)acceptableTypes, possibleMediaTypes).orElseThrow(() -> SourceCodeDownloadServiceBase.mediaTypeNotAcceptableException(uniformPath, possibleMediaTypes));
    }

    private static NotAcceptableException mediaTypeNotAcceptableException(UniformPath uniformPath, List<MediaType> possibleMediaTypes) {
        return new NotAcceptableException(String.format("File \"%s\" can only be provided with media types: %s", uniformPath, possibleMediaTypes));
    }

    private byte[] getBinaryElement(UniformPath uniformPath, HistoryAccessOption historyOption) throws StorageException {
        BinaryElementIndex binaryElementIndex = this.openProjectIndex(BinaryElementIndex.class, historyOption);
        return binaryElementIndex.getContent(uniformPath);
    }

    private TokenElementInfo getTokenElement(UniformPath uniformPath, HistoryAccessOption historyOption) throws StorageException {
        TokenElementIndex tokenElementIndex = ResourceServiceUtils.openContentIndex((UniformPath)uniformPath, (HistoryAccessOption)historyOption, (ProjectStorageSystem)this.getProjectStorageSystem());
        return tokenElementIndex.getTokenElementByPath(uniformPath);
    }

    protected abstract String processTokenElement(TokenElementInfo var1);

    protected abstract byte[] processBinaryElement(byte[] var1);
}

