/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.index.repository.RepositoryUpdateUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/post-commit-hook")
public class CommitHookService
extends ApiBase {
    public static final String SERVICE_NAME = "post-commit-hook";
    public static final String REPOSITORY_PARAMETER = "repository";
    private static final String REPOSITORY_PARAM_DESCRIPTION = "The URL of the repository affected. To determine triggers that should be scheduled, this URL must match the repository URLs used by the triggers. The protocol, path separators (/ vs \\\\) or trailing slashes are canonicalized automatically.";

    @POST
    @Operation(summary="Trigger commit hook", description="Allows to trigger periodic jobs via a commit hook.")
    @RequiresNoPermission(description="The user needs the Trigger Commit Hook permission on all projects that are affected by the commit hook")
    @Consumes(value={"*/*"})
    public void triggerCommitHookPost(@Parameter(description="The URL of the repository affected. To determine triggers that should be scheduled, this URL must match the repository URLs used by the triggers. The protocol, path separators (/ vs \\\\) or trailing slashes are canonicalized automatically.") @QueryParam(value="repository") String repository) throws StorageException {
        RepositoryUpdateUtils.extractAndScheduleAffectedTriggers((String)repository, (IndexLayer)this.getIndexLayer(), projects -> CommitHookService.checkPermissions(this.getPermissions(), projects));
    }

    private static void checkPermissions(ServicePermissions permissions, Set<InternalProjectId> externallyTriggeredProjects) {
        try {
            for (InternalProjectId project : externallyTriggeredProjects) {
                permissions.checkCommitHook((IProjectId)project);
            }
        }
        catch (ForbiddenException | StorageException e) {
            throw new ForbiddenException(e.getMessage(), e);
        }
    }
}

