/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.tasks;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.task.ETaskStatus;
import com.teamscale.index.task.Task;
import com.teamscale.index.task.TaskIndex;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;

@Path(value="api/projects/{project}/findings/{findingId}/tasks")
public class TaskFindingMappingService
extends ApiBase {
    @GET
    @Operation(summary="Get finding to task mapping", description="Returns the IDs of all tasks containing the given findings.", tags={"Findings", "Tasks"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public ListMap<ETaskStatus, ExtendedTrackedFinding.SimpleTask> getTasksForFinding(@Parameter(description="Finding ID to determine tasks for") @PathParam(value="findingId") String findingId, @Parameter(description="Tasks statuses to be filtered for") @QueryParam(value="task-status") Set<ETaskStatus> taskStatuses) throws StorageException {
        TaskIndex taskIndex = this.openProjectIndex(TaskIndex.class, null);
        ListMap resultingTasks = new ListMap();
        List allTasks = taskIndex.getAllTasks();
        allTasks.sort(Comparator.comparingLong(Task::getCreated).reversed());
        allTasks.stream().filter(task -> task.getFindingIds().contains(findingId) && (taskStatuses.isEmpty() || taskStatuses.contains(task.getStatus()))).forEach(task -> resultingTasks.add((Object)task.getStatus(), (Object)new ExtendedTrackedFinding.SimpleTask(Integer.valueOf(task.getId()), task.getSubject())));
        return resultingTasks;
    }
}

