/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.testgap.upload;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoLineCoverage;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoReport;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.testgap.SourceLocation;
import com.teamscale.index.testgap.dotnet.DotNetVersionIndex;
import com.teamscale.reportparser.model.TeamscaleCompactCoverageReport;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.util.BodyPartWrapper;
import com.teamscale.service.testgap.upload.VersionBasedExternalUploadServiceQueryOptions;
import com.teamscale.service.upload.base.ExternalUploadServiceUtils;
import jakarta.ws.rs.BadRequestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;

public abstract class SourceLocationBasedUploadServiceBase<T, S extends SessionBasedExternalAnalysisServiceQueryOptions>
extends SessionBasedExternalAnalysisServiceBase<S> {
    private static final String COMPACT_COVERAGE_REPORT_FILE_NAME = "compact.coverage";

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionManager sessionManager, List<IExternalUploadRequestPart> bodyParts, S parameters) throws BadRequestException, StorageException {
        HashSet<T> ids = new HashSet<T>();
        for (IExternalUploadRequestPart part : bodyParts) {
            ids.addAll(this.parseReport((BodyPartWrapper)part));
        }
        HistoryAccessOption historyAccessOption = ExternalUploadServiceUtils.getAccessOptionForDefaultBranch(session.getCommit());
        sessionManager.storeNewImportInfosForSession(session, this.doMappingAndCreateImportInfos(historyAccessOption, ids, parameters, session.getTargetStorage().isPresent()));
    }

    protected void processVersionBased(S parameters, List<FormDataBodyPart> reports) throws StorageException, IOException {
        List<BodyPartWrapper> bodyParts = SourceLocationBasedUploadServiceBase.readFormDataBodyParts(reports);
        this.logManager.logReports(bodyParts);
        this.process(EHttpMethod.POST, new ArrayList<BodyPartWrapper>(bodyParts), parameters, "auto-create");
    }

    protected VersionBasedExternalUploadServiceQueryOptions createParameters(String version, String message, String partition) throws StorageException {
        this.logManager.logParameter("version", version);
        DotNetVersionIndex versionIndex = this.openProjectIndex(DotNetVersionIndex.class, null);
        CommitDescriptor commitDescriptor = ExternalUploadServiceUtils.getCommitDescriptorFromVersionIndex(versionIndex, version);
        UnresolvedCommitDescriptor unresolvedCommitDescriptor = commitDescriptor.toUnresolvedCommitDescriptor();
        VersionBasedExternalUploadServiceQueryOptions parameters = new VersionBasedExternalUploadServiceQueryOptions();
        parameters.setVersion(version);
        parameters.setUploadMessage(message);
        parameters.setPartition(partition);
        parameters.setCommit(unresolvedCommitDescriptor);
        return parameters;
    }

    public static List<ExternalAnalysisImportInfo<?>> createImportInfo(long targetCommitTimestamp, String uniformPath, List<SourceLocation> locations, boolean targetsExternalStorage) throws BadRequestException {
        LineCoverageInfo coverageInfo = new LineCoverageInfo(-1L, targetCommitTimestamp, true);
        for (SourceLocation location : locations) {
            for (int i = location.getRegion().getStart(); i <= location.getRegion().getEnd(); ++i) {
                coverageInfo.addLineCoverage(i, ELineCoverage.PARTIALLY_COVERED);
            }
        }
        if (!targetsExternalStorage) {
            return List.of(new ExternalAnalysisImportInfoLineCoverage(uniformPath, coverageInfo));
        }
        ArrayList<TeamscaleCompactCoverageReport.CompactCoverageFileInfo> coverageInfos = new ArrayList<TeamscaleCompactCoverageReport.CompactCoverageFileInfo>();
        coverageInfos.add(new TeamscaleCompactCoverageReport.CompactCoverageFileInfo(uniformPath, coverageInfo.getFullyCoveredLines(), coverageInfo.getPartiallyCoveredLines(), coverageInfo.getUncoveredLines(), null));
        TeamscaleCompactCoverageReport teamscaleCompactCoverageReport = new TeamscaleCompactCoverageReport(Integer.valueOf(1), coverageInfos);
        ExternalAnalysisImportInfoReport.Builder builder = new ExternalAnalysisImportInfoReport.Builder("", EReportFormat.TEAMSCALE_COMPACT_COVERAGE);
        try {
            builder.addReport(COMPACT_COVERAGE_REPORT_FILE_NAME, teamscaleCompactCoverageReport.buildReport());
        }
        catch (JsonProcessingException e) {
            throw new BadRequestException((Throwable)e);
        }
        return builder.build().getInfos();
    }

    protected abstract Set<T> parseReport(BodyPartWrapper var1);

    protected abstract ExternalAnalysisImportInfos doMappingAndCreateImportInfos(HistoryAccessOption var1, Set<T> var2, S var3, boolean var4) throws StorageException, BadRequestException;
}

